/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.mail.internet.MimeMessage;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.admin.model.workflow.WorkflowManagementTest;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class UserSessionRefreshTimeWorkflowTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    @InjectUser(ref="alice", config=DefaultUserConfig.class, lifecycle=LifeCycle.METHOD)
    private ManagedUser userAlice;
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectWebDriver
    WebDriver driver;
    @InjectPage
    LoginPage loginPage;
    @InjectOAuthClient
    OAuthClient oauth;
    @InjectMailServer
    private MailServer mailServer;

    @BeforeEach
    public void onBefore() {
        this.oauth.realm(REALM_NAME);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowsManager manager = new WorkflowsManager(session);
            manager.removeWorkflows();
        });
    }

    @Test
    public void testDisabledUserAfterInactivityPeriod() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build()).close();
        this.oauth.openLoginForm();
        String username = this.userAlice.getUsername();
        this.loginPage.fillLogin(username, this.userAlice.getPassword());
        this.loginPage.submit();
        Assertions.assertTrue((this.driver.getPageSource() != null && this.driver.getPageSource().contains("Happy days") ? 1 : 0) != 0);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, username);
            Assertions.assertTrue((boolean)user.isEnabled());
            manager.runScheduledSteps();
            user = session.users().getUserByUsername(realm, username);
            Assertions.assertTrue((boolean)user.isEnabled());
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(5L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, username);
                Assertions.assertTrue((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "master-admin@email.org");
        Assertions.assertNotNull((Object)testUserMessage, (String)"The first step (notify) should have sent an email.");
        this.mailServer.runCleanup();
        this.oauth.openLoginForm();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            UserModel user;
            WorkflowsManager manager;
            RealmModel realm;
            try {
                realm = UserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(11L).toSeconds()));
                manager = new WorkflowsManager(session);
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, username);
                Assertions.assertTrue((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
            try {
                realm = UserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(17L).toSeconds()));
                manager = new WorkflowsManager(session);
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, username);
                Assertions.assertFalse((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    @Test
    public void testMultipleWorkflows() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).withConfig("custom_subject_key", "notifier1_subject").withConfig("custom_message", "notifier1_message").build()}).of("user-refresh-time-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(10L)).withConfig("custom_subject_key", "notifier2_subject").withConfig("custom_message", "notifier2_message").build()}).build()).close();
        this.oauth.openLoginForm();
        String username = this.userAlice.getUsername();
        this.loginPage.fillLogin(username, this.userAlice.getPassword());
        this.loginPage.submit();
        Assertions.assertTrue((this.driver.getPageSource() != null && this.driver.getPageSource().contains("Happy days") ? 1 : 0) != 0);
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserProvider users = session.users();
            UserModel user = users.getUserByUsername(realm, username);
            Assertions.assertTrue((boolean)user.isEnabled());
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(7L).toSeconds()));
                manager.runScheduledSteps();
                user = users.getUserByUsername(realm, username);
                Assertions.assertTrue((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        List<MimeMessage> testUserMessages = WorkflowManagementTest.findEmailsByRecipient(this.mailServer, "master-admin@email.org");
        Assertions.assertEquals((int)1, (int)testUserMessages.size());
        Assertions.assertNotNull((Object)testUserMessages.get(0), (String)"The first step (notify) should have sent an email.");
        WorkflowManagementTest.verifyEmailContent(testUserMessages.get(0), "master-admin@email.org", "notifier1_subject", "notifier1_message");
        this.mailServer.runCleanup();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = UserSessionRefreshTimeWorkflowTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, username);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(11L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserByUsername(realm, username);
                Assertions.assertTrue((boolean)user.isEnabled());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        testUserMessages = WorkflowManagementTest.findEmailsByRecipient(this.mailServer, "master-admin@email.org");
        Assertions.assertEquals((int)1, (int)testUserMessages.size());
        Assertions.assertNotNull((Object)testUserMessages.get(0), (String)"The second step (notify) should have sent an email.");
        WorkflowManagementTest.verifyEmailContent(testUserMessages.get(0), "master-admin@email.org", "notifier2_subject", "notifier2_message");
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }

    private static class DefaultUserConfig
    implements UserConfig {
        private DefaultUserConfig() {
        }

        public UserConfigBuilder configure(UserConfigBuilder user) {
            user.username("alice");
            user.password("alice");
            user.name("alice", "alice");
            user.email("master-admin@email.org");
            return user;
        }
    }
}

