/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.workflows.WorkflowConditionRepresentation;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;
import org.keycloak.tests.utils.MailUtils;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class WorkflowManagementTest {
    private static final String REALM_NAME = "default";
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests", "org.hamcrest"})
    RunOnServerClient runOnServer;
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectMailServer
    private MailServer mailServer;

    @Test
    public void testCreate() {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
        List actualWorkflows = workflows.list();
        MatcherAssert.assertThat((Object)actualWorkflows, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((WorkflowRepresentation)actualWorkflows.get(0)).getUses(), (Matcher)Matchers.is((Object)"user-creation-time-workflow"));
        MatcherAssert.assertThat((Object)((WorkflowRepresentation)actualWorkflows.get(0)).getSteps(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((WorkflowStepRepresentation)((WorkflowRepresentation)actualWorkflows.get(0)).getSteps().get(0)).getUses(), (Matcher)Matchers.is((Object)"notify-user"));
        MatcherAssert.assertThat((Object)((WorkflowStepRepresentation)((WorkflowRepresentation)actualWorkflows.get(0)).getSteps().get(1)).getUses(), (Matcher)Matchers.is((Object)"disable-user"));
        MatcherAssert.assertThat((Object)((WorkflowRepresentation)actualWorkflows.get(0)).getState(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCreateWithNoConditions() {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("event-based-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build();
        ((WorkflowRepresentation)expectedWorkflows.getWorkflows().get(0)).setConditions(null);
        try (Response response = this.managedRealm.admin().workflows().create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
    }

    @Test
    public void testCreateWithNoWorkflowSetDefaultWorkflow() {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of(null).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build();
        ((WorkflowRepresentation)expectedWorkflows.getWorkflows().get(0)).setConditions(null);
        try (Response response = this.managedRealm.admin().workflows().create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
        Assertions.assertEquals((int)1, (int)this.managedRealm.admin().workflows().list().size());
        Assertions.assertEquals((Object)"event-based-workflow", (Object)((WorkflowRepresentation)this.managedRealm.admin().workflows().list().get(0)).getUses());
    }

    @Test
    public void testDelete() {
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        workflows.create(WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_ADD.toString()).recurring().withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build()}).of("event-based-workflow").onEvent(ResourceOperationType.USER_LOGIN.toString()).recurring().withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").email("testuser@example.com").build()).close();
        List actualWorkflows = workflows.list();
        MatcherAssert.assertThat((Object)actualWorkflows, (Matcher)Matchers.hasSize((int)2));
        WorkflowRepresentation workflow = actualWorkflows.stream().filter(p -> "user-creation-time-workflow".equals(p.getUses())).findAny().orElse(null);
        MatcherAssert.assertThat((Object)workflow, (Matcher)Matchers.notNullValue());
        String id = workflow.getId();
        workflows.workflow(id).delete().close();
        actualWorkflows = workflows.list();
        MatcherAssert.assertThat((Object)actualWorkflows, (Matcher)Matchers.hasSize((int)1));
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            List registeredWorkflows = manager.getWorkflows();
            Assertions.assertEquals((int)1, (int)registeredWorkflows.size());
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStateProvider.class).create(session);
            List steps = stateProvider.getScheduledStepsByWorkflow(id);
            Assertions.assertTrue((boolean)steps.isEmpty());
        });
    }

    @Test
    public void testUpdate() {
        WorkflowSetRepresentation expectedWorkflows = WorkflowRepresentation.create().of("user-creation-time-workflow").name("test-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(10L)).build()}).build();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        try (Response response = workflows.create(expectedWorkflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        }
        List actualWorkflows = workflows.list();
        MatcherAssert.assertThat((Object)actualWorkflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)actualWorkflows.get(0);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)Matchers.is((Object)"test-workflow"));
        workflow.setName("changed");
        this.managedRealm.admin().workflows().workflow(workflow.getId()).update(workflow).close();
        actualWorkflows = workflows.list();
        workflow = (WorkflowRepresentation)actualWorkflows.get(0);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)Matchers.is((Object)"changed"));
        String previousOn = (String)workflow.getOn();
        workflow.setOn(new String[]{ResourceOperationType.USER_LOGIN.toString()});
        try (Response response = workflows.workflow(workflow.getId()).update(workflow);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        }
        workflow.setOn(new String[]{previousOn});
        workflow.setConditions(Collections.singletonList(WorkflowConditionRepresentation.create().of("has-identity-provider-link").withConfig("alias", "someidp").build()));
        response = workflows.workflow(workflow.getId()).update(workflow);
        try {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        workflow.setConditions(null);
        ((WorkflowStepRepresentation)workflow.getSteps().get(0)).setAfter(Duration.ofDays(8L).toMillis());
        response = workflows.workflow(workflow.getId()).update(workflow);
        try {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    @Test
    public void testWorkflowDoesNotFallThroughStepsInSingleRun() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_ADD.toString()).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(10L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").email("testuser@example.com").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "testuser");
            List registeredWorkflows = manager.getWorkflows();
            Assertions.assertEquals((int)1, (int)registeredWorkflows.size());
            Workflow workflow = (Workflow)registeredWorkflows.get(0);
            Assertions.assertEquals((int)2, (int)manager.getSteps(workflow.getId()).size());
            WorkflowStep notifyStep = (WorkflowStep)manager.getSteps(workflow.getId()).get(0);
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
            WorkflowStateProvider.ScheduledStep scheduledStep = stateProvider.getScheduledStep(workflow.getId(), user.getId());
            Assertions.assertNotNull((Object)scheduledStep, (String)("A step should have been scheduled for the user " + user.getUsername()));
            Assertions.assertEquals((Object)notifyStep.getId(), (Object)scheduledStep.stepId());
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserById(realm, user.getId());
                WorkflowStep disableStep = (WorkflowStep)manager.getSteps(workflow.getId()).get(1);
                scheduledStep = stateProvider.getScheduledStep(workflow.getId(), user.getId());
                Assertions.assertNotNull((Object)scheduledStep, (String)("A step should have been scheduled for the user " + user.getUsername()));
                Assertions.assertEquals((Object)disableStep.getId(), (Object)scheduledStep.stepId(), (String)"The second step should have been scheduled");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "testuser@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"The first step (notify) should have sent an email.");
        this.mailServer.runCleanup();
    }

    @Test
    public void testAssignWorkflowToExistingResources() {
        int i;
        int i2;
        for (i2 = 0; i2 < 10; ++i2) {
            this.managedRealm.admin().users().create(UserConfigBuilder.create().username("user-" + i2).build()).close();
        }
        for (i2 = 0; i2 < 10; ++i2) {
            this.managedRealm.admin().users().create(UserConfigBuilder.create().username("idp-user-" + i2).federatedLink("someidp", UUID.randomUUID().toString(), "idp-user-" + i2).build()).close();
        }
        IdentityProviderRepresentation idp = new IdentityProviderRepresentation();
        idp.setAlias("someidp");
        idp.setProviderId("keycloak-oidc");
        idp.setEnabled(true);
        this.managedRealm.admin().identityProviders().create(idp).close();
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_FEDERATED_IDENTITY_ADD.name()).onConditions(new WorkflowConditionRepresentation[]{WorkflowConditionRepresentation.create().of("has-identity-provider-link").withConfig("alias", "someidp").build()}).withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(10L)).build()}).build()).close();
        for (i = 0; i < 3; ++i) {
            this.managedRealm.admin().users().create(UserConfigBuilder.create().username("new-idp-user-" + i).federatedLink("someidp", UUID.randomUUID().toString(), "new-idp-user-" + i).build()).close();
        }
        for (i = 0; i < 3; ++i) {
            this.managedRealm.admin().users().create(UserConfigBuilder.create().username("new-user-" + i).build()).close();
        }
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager workflowsManager = new WorkflowsManager(session);
            List registeredWorkflows = workflowsManager.getWorkflows();
            Assertions.assertEquals((int)1, (int)registeredWorkflows.size());
            Workflow workflow = (Workflow)registeredWorkflows.get(0);
            Assertions.assertEquals((int)2, (int)workflowsManager.getSteps(workflow.getId()).size());
            WorkflowStep notifyStep = (WorkflowStep)workflowsManager.getSteps(workflow.getId()).get(0);
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStateProvider.class).create(session);
            List scheduledSteps = stateProvider.getScheduledStepsByWorkflow(workflow);
            Assertions.assertEquals((int)3, (int)scheduledSteps.size());
            scheduledSteps.forEach(scheduledStep -> {
                Assertions.assertEquals((Object)notifyStep.getId(), (Object)scheduledStep.stepId());
                UserModel user = session.users().getUserById(realm, scheduledStep.resourceId());
                Assertions.assertNotNull((Object)user);
                Assertions.assertTrue((boolean)user.getUsername().startsWith("new-idp-user-"));
            });
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                workflowsManager.runScheduledSteps();
                WorkflowStep disableStep = (WorkflowStep)workflowsManager.getSteps(workflow.getId()).get(1);
                scheduledSteps = stateProvider.getScheduledStepsByWorkflow(workflow);
                Assertions.assertEquals((int)3, (int)scheduledSteps.size());
                scheduledSteps.forEach(scheduledStep -> {
                    Assertions.assertEquals((Object)disableStep.getId(), (Object)scheduledStep.stepId());
                    UserModel user = session.users().getUserById(realm, scheduledStep.resourceId());
                    Assertions.assertNotNull((Object)user);
                    Assertions.assertTrue((boolean)user.getUsername().startsWith("new-idp-user-"));
                });
                workflowsManager.scheduleAllEligibleResources(workflow);
                scheduledSteps = stateProvider.getScheduledStepsByWorkflow(workflow);
                Assertions.assertEquals((int)13, (int)scheduledSteps.size());
                List<WorkflowStateProvider.ScheduledStep> scheduledToNotify = scheduledSteps.stream().filter(step -> notifyStep.getId().equals(step.stepId())).toList();
                Assertions.assertEquals((int)10, (int)scheduledToNotify.size());
                scheduledToNotify.forEach(scheduledStep -> {
                    UserModel user = session.users().getUserById(realm, scheduledStep.resourceId());
                    Assertions.assertNotNull((Object)user);
                    Assertions.assertTrue((boolean)user.getUsername().startsWith("idp-user-"));
                });
                List<WorkflowStateProvider.ScheduledStep> scheduledToDisable = scheduledSteps.stream().filter(step -> disableStep.getId().equals(step.stepId())).toList();
                Assertions.assertEquals((int)3, (int)scheduledToDisable.size());
                scheduledToDisable.forEach(scheduledStep -> {
                    UserModel user = session.users().getUserById(realm, scheduledStep.resourceId());
                    Assertions.assertNotNull((Object)user);
                    Assertions.assertTrue((boolean)user.getUsername().startsWith("new-idp-user-"));
                });
            }
            finally {
                Time.setOffset((int)0);
            }
        });
    }

    @Test
    public void testDisableWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_ADD.toString()).name("test-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(5L)).build()}).build()).close();
        WorkflowsResource workflows = this.managedRealm.admin().workflows();
        List actualWorkflows = workflows.list();
        MatcherAssert.assertThat((Object)actualWorkflows, (Matcher)Matchers.hasSize((int)1));
        WorkflowRepresentation workflow = (WorkflowRepresentation)actualWorkflows.get(0);
        MatcherAssert.assertThat((Object)workflow.getName(), (Matcher)Matchers.is((Object)"test-workflow"));
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").email("testuser@example.com").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "testuser");
                Assertions.assertTrue((boolean)user.isEnabled(), (String)"The second step (disable) should NOT have run.");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "testuser@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"The first step (notify) should have sent an email.");
        this.mailServer.runCleanup();
        workflow.setEnabled(Boolean.valueOf(false));
        this.managedRealm.admin().workflows().workflow(workflow.getId()).update(workflow).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("anotheruser").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            List registeredWorkflow = manager.getWorkflows();
            Assertions.assertEquals((int)1, (int)registeredWorkflow.size());
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStateProvider.class).create(session);
            List scheduledSteps = stateProvider.getScheduledStepsByWorkflow((Workflow)registeredWorkflow.get(0));
            Assertions.assertEquals((int)1, (int)scheduledSteps.size());
            UserModel scheduledStepUser = session.users().getUserById(realm, ((WorkflowStateProvider.ScheduledStep)scheduledSteps.get(0)).resourceId());
            Assertions.assertNotNull((Object)scheduledStepUser);
            Assertions.assertTrue((boolean)scheduledStepUser.getUsername().startsWith("testuser"));
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "testuser");
                Assertions.assertTrue((boolean)user.isEnabled(), (String)"The second step (disable) should NOT have run as the workflow is disabled.");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        workflow.getConfig().putSingle((Object)"enabled", (Object)"true");
        this.managedRealm.admin().workflows().workflow(workflow.getId()).update(workflow).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("thirduser").email("thirduser@example.com").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "testuser");
                Assertions.assertFalse((boolean)user.isEnabled(), (String)"The second step (disable) should have run as the workflow was re-enabled.");
                user = session.users().getUserByUsername(realm, "thirduser");
                Assertions.assertTrue((boolean)user.isEnabled(), (String)"The second step (disable) should NOT have run");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "thirduser@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"The first step (notify) should have sent an email.");
        this.mailServer.runCleanup();
    }

    @Test
    public void testRecurringWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_ADD.toString()).recurring().withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").email("testuser@example.com").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(6L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "testuser");
                Workflow workflow = (Workflow)manager.getWorkflows().get(0);
                WorkflowStep step = (WorkflowStep)manager.getSteps(workflow.getId()).get(0);
                WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
                WorkflowStateProvider.ScheduledStep scheduledStep = stateProvider.getScheduledStep(workflow.getId(), user.getId());
                Assertions.assertNotNull((Object)scheduledStep, (String)("A step should have been scheduled for the user " + user.getUsername()));
                Assertions.assertEquals((Object)step.getId(), (Object)scheduledStep.stepId(), (String)"The step should have been scheduled again");
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(12L).toSeconds()));
                manager.runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        Assertions.assertEquals((int)2, (int)WorkflowManagementTest.findEmailsByRecipient(this.mailServer, "testuser@example.com").size());
        this.mailServer.runCleanup();
    }

    @Test
    public void testRunImmediateWorkflow() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").withConfig("message", "message").build(), WorkflowStepRepresentation.create().of("disable-user").build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowManagementTest.configureSessionContext(session);
            UserModel user = session.users().getUserByUsername(session.getContext().getRealm(), "testuser");
            MatcherAssert.assertThat((Object)user, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((List)user.getAttributes().get("message")), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)((String)((List)user.getAttributes().get("message")).get(0)), (Matcher)Matchers.is((Object)"message"));
            Assertions.assertFalse((boolean)user.isEnabled());
        });
    }

    @Test
    public void testFailCreateWorkflowWithNegativeTime() {
        WorkflowSetRepresentation workflows = WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("set-user-attribute").after(Duration.ofDays(-5L)).withConfig("key", "value").build()}).build();
        try (Response response = this.managedRealm.admin().workflows().create(workflows);){
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)Response.Status.BAD_REQUEST.getStatusCode()));
            MatcherAssert.assertThat((Object)((ErrorRepresentation)response.readEntity(ErrorRepresentation.class)).getErrorMessage(), (Matcher)Matchers.equalTo((Object)"Step 'after' time condition cannot be negative."));
        }
    }

    @Test
    public void testNotifyUserStepSendsEmailWithDefaultDisableMessage() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(7L)).withConfig("reason", "inactivity").build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(3L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser").email("test@example.com").name("John", "").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(7L).toSeconds()));
                manager.runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "test@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"No email found for test@example.com");
        WorkflowManagementTest.verifyEmailContent(testUserMessage, "test@example.com", "Disable", "John", "3", "inactivity");
        this.mailServer.runCleanup();
    }

    @Test
    public void testNotifyUserStepSendsEmailWithDefaultDeleteMessage() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(15L)).withConfig("reason", "inactivity").build(), WorkflowStepRepresentation.create().of("delete-user").after(Duration.ofDays(15L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser2").email("test2@example.com").name("Jane", "").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(15L).toSeconds()));
                manager.runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "test2@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"No email found for test2@example.com");
        WorkflowManagementTest.verifyEmailContent(testUserMessage, "test2@example.com", "Deletion", "Jane", "15", "inactivity", "permanently deleted");
        this.mailServer.runCleanup();
    }

    @Test
    public void testNotifyUserStepWithCustomMessageOverride() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).withConfig("reason", "compliance requirement").withConfig("custom_message", "Your account requires immediate attention due to new compliance policies.").withConfig("custom_subject_key", "customComplianceSubject").build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(7L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser3").email("test3@example.com").name("Bob", "").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(5L).toSeconds()));
                manager.runScheduledSteps();
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "test3@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"No email found for test3@example.com");
        WorkflowManagementTest.verifyEmailContent(testUserMessage, "test3@example.com", "", "Bob", "2", "immediate attention due to new compliance policies");
        this.mailServer.runCleanup();
    }

    @Test
    public void testNotifyUserStepSkipsUsersWithoutEmailButLogsWarning() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(5L)).build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(10L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser4").name("NoEmail", "").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(5L).toSeconds()));
                manager.runScheduledSteps();
                UserModel user = session.users().getUserByUsername(realm, "testuser4");
                WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getProvider(WorkflowStateProvider.class);
                List scheduledSteps = stateProvider.getScheduledStepsByResource(user.getId());
                Assertions.assertEquals((int)1, (int)scheduledSteps.size());
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = this.findEmailByRecipientContaining("testuser4");
        Assertions.assertNull((Object)testUserMessage, (String)"No email should be sent to user without email address");
    }

    @Test
    public void testCompleteUserLifecycleWithMultipleNotifications() {
        this.managedRealm.admin().workflows().create(WorkflowRepresentation.create().of("user-creation-time-workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(15L)).withConfig("reason", "inactivity").build(), WorkflowStepRepresentation.create().of("disable-user").after(Duration.ofDays(15L)).build()}).build()).close();
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("testuser5").email("testuser5@example.com").name("TestUser5", "").build()).close();
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            RealmModel realm = WorkflowManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            UserModel user = session.users().getUserByUsername(realm, "testuser5");
            try {
                Time.setOffset((int)Math.toIntExact(Duration.ofDays(15L).toSeconds()));
                manager.runScheduledSteps();
                user = session.users().getUserById(realm, user.getId());
                Assertions.assertTrue((boolean)user.isEnabled(), (String)"User should still be enabled after notification");
                Time.setOffset((int)(Math.toIntExact(Duration.ofDays(30L).toSeconds()) + Math.toIntExact(Duration.ofMinutes(15L).toSeconds())));
                manager.runScheduledSteps();
                user = session.users().getUserById(realm, user.getId());
                Assertions.assertNotNull((Object)user, (String)"User should still exist after disable");
                Assertions.assertFalse((boolean)user.isEnabled(), (String)"User should be disabled");
            }
            finally {
                Time.setOffset((int)0);
            }
        });
        MimeMessage testUserMessage = WorkflowManagementTest.findEmailByRecipient(this.mailServer, "testuser5@example.com");
        Assertions.assertNotNull((Object)testUserMessage, (String)"No email found for testuser5@example.com");
        WorkflowManagementTest.verifyEmailContent(testUserMessage, "testuser5@example.com", "Disable", "TestUser5", "15", "inactivity");
        this.mailServer.runCleanup();
    }

    public static List<MimeMessage> findEmailsByRecipient(MailServer mailServer, String expectedRecipient) {
        return Arrays.stream(mailServer.getReceivedMessages()).filter(msg -> {
            try {
                return MailUtils.getRecipient((MimeMessage)msg).equals(expectedRecipient);
            }
            catch (Exception e) {
                return false;
            }
        }).toList();
    }

    public static MimeMessage findEmailByRecipient(MailServer mailServer, String expectedRecipient) {
        return Arrays.stream(mailServer.getReceivedMessages()).filter(msg -> {
            try {
                return MailUtils.getRecipient((MimeMessage)msg).equals(expectedRecipient);
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
    }

    private MimeMessage findEmailByRecipientContaining(String recipientPart) {
        return Arrays.stream(this.mailServer.getReceivedMessages()).filter(msg -> {
            try {
                return MailUtils.getRecipient((MimeMessage)msg).contains(recipientPart);
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
    }

    private static RealmModel configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName(REALM_NAME);
        session.getContext().setRealm(realm);
        return realm;
    }

    public static void verifyEmailContent(MimeMessage message, String expectedRecipient, String subjectContains, String ... contentContains) {
        try {
            Assertions.assertEquals((Object)expectedRecipient, (Object)MailUtils.getRecipient((MimeMessage)message));
            MatcherAssert.assertThat((Object)message.getSubject(), (Matcher)Matchers.containsString((String)subjectContains));
            MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
            String textContent = body.getText();
            String htmlContent = body.getHtml();
            for (String expectedContent : contentContains) {
                boolean foundInText = textContent.contains(expectedContent);
                boolean foundInHtml = htmlContent.contains(expectedContent);
                Assertions.assertTrue((foundInText || foundInHtml ? 1 : 0) != 0, (String)("Email content should contain: " + expectedContent + "\nText: " + textContent + "\nHTML: " + htmlContent));
            }
        }
        catch (MessagingException | IOException e) {
            Assertions.fail((String)("Failed to read email message: " + e.getMessage()));
        }
    }
}

