/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.model.workflow;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.WorkflowResource;
import org.keycloak.admin.client.resource.WorkflowStepsResource;
import org.keycloak.admin.client.resource.WorkflowsResource;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.ResourceOperationType;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStateProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.representations.workflows.WorkflowSetRepresentation;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.model.workflow.WorkflowsServerConfig;

@KeycloakIntegrationTest(config=WorkflowsServerConfig.class)
public class WorkflowStepManagementTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectRunOnServer(permittedPackages={"org.keycloak.tests"})
    RunOnServerClient runOnServer;
    private WorkflowsResource workflowsResource;
    private String workflowId;

    @BeforeEach
    public void setup() {
        this.workflowsResource = this.managedRealm.admin().workflows();
        WorkflowSetRepresentation workflows = WorkflowRepresentation.create().of("user-creation-time-workflow").onEvent(ResourceOperationType.USER_ADD.toString()).name("Test Workflow").withSteps(new WorkflowStepRepresentation[]{WorkflowStepRepresentation.create().of("notify-user").after(Duration.ofDays(1L)).build()}).build();
        try (Response response = this.workflowsResource.create(workflows);){
            if (response.getStatus() != 201) {
                String responseBody = (String)response.readEntity(String.class);
                System.err.println("Workflow creation failed with status: " + response.getStatus());
                System.err.println("Response body: " + responseBody);
            }
            Assertions.assertEquals((int)201, (int)response.getStatus());
            List createdWorkflows = this.workflowsResource.list();
            Assertions.assertNotNull((Object)createdWorkflows);
            Assertions.assertEquals((int)1, (int)createdWorkflows.size());
            this.workflowId = ((WorkflowRepresentation)createdWorkflows.get(0)).getId();
        }
    }

    @Test
    public void testAddStepToWorkflow() {
        WorkflowResource workflow = this.workflowsResource.workflow(this.workflowId);
        WorkflowStepsResource steps = workflow.steps();
        WorkflowStepRepresentation stepRep = new WorkflowStepRepresentation();
        stepRep.setUses("disable-user");
        stepRep.setConfig("name", "Test Step");
        stepRep.setConfig("after", String.valueOf(Duration.ofDays(30L).toMillis()));
        try (Response response = steps.create(stepRep);){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            WorkflowStepRepresentation addedStep = (WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class);
            Assertions.assertNotNull((Object)addedStep);
            Assertions.assertNotNull((Object)addedStep.getId());
            Assertions.assertEquals((Object)"disable-user", (Object)addedStep.getUses());
        }
        List allSteps = steps.list();
        Assertions.assertEquals((int)2, (int)allSteps.size());
        boolean foundOurStep = allSteps.stream().anyMatch(step -> "disable-user".equals(step.getUses()) && "Test Step".equals(step.getConfig().getFirst((Object)"name")));
        Assertions.assertTrue((boolean)foundOurStep, (String)"Our added step should be present in the workflow");
    }

    @Test
    public void testRemoveStepFromWorkflow() {
        String step1Id;
        WorkflowResource workflow = this.workflowsResource.workflow(this.workflowId);
        WorkflowStepsResource steps = workflow.steps();
        WorkflowStepRepresentation step1 = new WorkflowStepRepresentation();
        step1.setUses("disable-user");
        step1.setConfig("after", String.valueOf(Duration.ofDays(30L).toMillis()));
        try (Response response = steps.create(step1);){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            step1Id = ((WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class)).getId();
        }
        List allSteps = steps.list();
        Assertions.assertEquals((int)2, (int)allSteps.size());
        try (Response response = steps.delete(step1Id);){
            Assertions.assertEquals((int)204, (int)response.getStatus());
        }
        allSteps = steps.list();
        Assertions.assertEquals((int)1, (int)allSteps.size());
    }

    @Test
    public void testAddStepAtSpecificPosition() {
        String step3Id;
        String step2Id;
        String step1Id;
        WorkflowResource workflow = this.workflowsResource.workflow(this.workflowId);
        WorkflowStepsResource steps = workflow.steps();
        WorkflowStepRepresentation step1 = new WorkflowStepRepresentation();
        step1.setUses("notify-user");
        step1.setConfig("name", "Step 1");
        step1.setConfig("after", String.valueOf(Duration.ofDays(30L).toMillis()));
        try (Response response = steps.create(step1, Integer.valueOf(0));){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            step1Id = ((WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class)).getId();
        }
        List allSteps = steps.list();
        Assertions.assertEquals((Object)step1Id, (Object)((WorkflowStepRepresentation)allSteps.get(0)).getId());
        WorkflowStepRepresentation step2 = new WorkflowStepRepresentation();
        step2.setUses("disable-user");
        step2.setConfig("name", "Step 2");
        step2.setConfig("after", String.valueOf(Duration.ofDays(60L).toMillis()));
        try (Response response = steps.create(step2, Integer.valueOf(1));){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            step2Id = ((WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class)).getId();
        }
        allSteps = steps.list();
        Assertions.assertEquals((Object)step2Id, (Object)((WorkflowStepRepresentation)allSteps.get(1)).getId());
        WorkflowStepRepresentation step3 = new WorkflowStepRepresentation();
        step3.setUses("notify-user");
        step3.setConfig("name", "Step 3");
        step3.setConfig("after", String.valueOf(Duration.ofDays(45L).toMillis()));
        try (Response response = steps.create(step3, Integer.valueOf(1));){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            step3Id = ((WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class)).getId();
        }
        allSteps = steps.list();
        Assertions.assertEquals((Object)step1Id, (Object)((WorkflowStepRepresentation)allSteps.get(0)).getId());
        Assertions.assertEquals((Object)step3Id, (Object)((WorkflowStepRepresentation)allSteps.get(1)).getId());
        Assertions.assertEquals((Object)step2Id, (Object)((WorkflowStepRepresentation)allSteps.get(2)).getId());
    }

    @Test
    public void testGetSpecificStep() {
        String stepId;
        WorkflowResource workflow = this.workflowsResource.workflow(this.workflowId);
        WorkflowStepsResource steps = workflow.steps();
        WorkflowStepRepresentation stepRep = new WorkflowStepRepresentation();
        stepRep.setUses("notify-user");
        stepRep.setConfig("name", "Test Step");
        stepRep.setConfig("after", String.valueOf(Duration.ofDays(15L).toMillis()));
        try (Response response = steps.create(stepRep);){
            Assertions.assertEquals((int)200, (int)response.getStatus());
            stepId = ((WorkflowStepRepresentation)response.readEntity(WorkflowStepRepresentation.class)).getId();
        }
        WorkflowStepRepresentation retrievedStep = steps.get(stepId);
        Assertions.assertNotNull((Object)retrievedStep);
        Assertions.assertEquals((Object)stepId, (Object)retrievedStep.getId());
        Assertions.assertEquals((Object)"notify-user", (Object)retrievedStep.getUses());
        Assertions.assertEquals((Object)"Test Step", (Object)retrievedStep.getConfig().getFirst((Object)"name"));
    }

    @Test
    public void testScheduledStepTableUpdatesAfterStepManagement() {
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            WorkflowStepManagementTest.configureSessionContext(session);
            WorkflowsManager manager = new WorkflowsManager(session);
            Workflow workflow = manager.addWorkflow("user-creation-time-workflow", Map.of());
            WorkflowStep step1 = new WorkflowStep("notify-user", null);
            step1.setAfter(Long.valueOf(Duration.ofDays(30L).toMillis()));
            WorkflowStep step2 = new WorkflowStep("disable-user", null);
            step2.setAfter(Long.valueOf(Duration.ofDays(60L).toMillis()));
            WorkflowStep addedStep1 = manager.addStepToWorkflow(workflow, step1, null);
            WorkflowStep addedStep2 = manager.addStepToWorkflow(workflow, step2, null);
            String testResourceId = "test-user-123";
            manager.bind(workflow, ResourceType.USERS, testResourceId);
            WorkflowStateProvider stateProvider = (WorkflowStateProvider)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStateProvider.class).create(session);
            List scheduledStepsBeforeRemoval = stateProvider.getScheduledStepsByWorkflow(workflow.getId());
            Assertions.assertNotNull((Object)scheduledStepsBeforeRemoval);
            manager.removeStepFromWorkflow(workflow, addedStep1.getId());
            List scheduledStepsAfterRemoval = stateProvider.getScheduledStepsByWorkflow(workflow.getId());
            Assertions.assertNotNull((Object)scheduledStepsAfterRemoval);
            List remainingSteps = manager.getSteps(workflow.getId());
            Assertions.assertEquals((int)1, (int)remainingSteps.size());
            Assertions.assertEquals((Object)addedStep2.getId(), (Object)((WorkflowStep)remainingSteps.get(0)).getId());
            Assertions.assertEquals((int)1, (int)((WorkflowStep)remainingSteps.get(0)).getPriority());
            WorkflowStep step3 = new WorkflowStep("notify-user", null);
            step3.setAfter(Long.valueOf(Duration.ofDays(15L).toMillis()));
            manager.addStepToWorkflow(workflow, step3, Integer.valueOf(0));
            List finalSteps = manager.getSteps(workflow.getId());
            Assertions.assertEquals((int)2, (int)finalSteps.size());
            Assertions.assertEquals((Object)step3.getProviderId(), (Object)((WorkflowStep)finalSteps.get(0)).getProviderId());
            Assertions.assertEquals((int)1, (int)((WorkflowStep)finalSteps.get(0)).getPriority());
            Assertions.assertEquals((Object)addedStep2.getId(), (Object)((WorkflowStep)finalSteps.get(1)).getId());
            Assertions.assertEquals((int)2, (int)((WorkflowStep)finalSteps.get(1)).getPriority());
        });
    }

    private static void configureSessionContext(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("default");
        session.getContext().setRealm(realm);
    }
}

