/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialexport;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentExportRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.ScopeMappingRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class PartialExportTest {
    private static final String EXPORT_TEST_REALM = "partial-export-test";
    @InjectAdminClient
    private Keycloak adminClient;

    @BeforeEach
    public void initializeRealm() {
        RealmRepresentation realmRepresentation = PartialExportTest.loadJson(PartialExportTest.class.getResourceAsStream("partialexport-testrealm.json"), RealmRepresentation.class);
        this.adminClient.realms().create(realmRepresentation);
    }

    @AfterEach
    public void cleanupRealm() {
        this.adminClient.realms().realm(EXPORT_TEST_REALM).remove();
    }

    @Test
    public void testExport() {
        RealmRepresentation rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertNull((Object)rep.getUsers(), (String)"Users are null");
        Assert.assertNull((Object)rep.getDefaultGroups(), (String)"Default groups are empty");
        Assert.assertNull((Object)rep.getGroups(), (String)"Groups are empty");
        Assert.assertNull((Object)rep.getRoles(), (String)"Realm and client roles are empty");
        Assert.assertNull((Object)rep.getClients(), (String)"Clients are empty");
        this.checkScopeMappings(rep.getScopeMappings(), true);
        Assert.assertNull((Object)rep.getClientScopeMappings(), (String)"Client scope mappings empty");
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertNull((Object)rep.getUsers(), (String)"Users are null");
        Assert.assertNull((Object)rep.getDefaultGroups(), (String)"Default groups are empty");
        Assert.assertNotNull((Object)rep.getGroups(), (String)"Groups not empty");
        this.checkGroups(rep.getGroups());
        Assert.assertNotNull((Object)rep.getRoles(), (String)"Realm and client roles not empty");
        Assert.assertNotNull((Object)rep.getRoles().getRealm(), (String)"Realm roles not empty");
        this.checkRealmRoles(rep.getRoles().getRealm());
        Assert.assertNull((Object)rep.getRoles().getClient(), (String)"Client roles are empty");
        Assert.assertNull((Object)rep.getClients(), (String)"Clients are empty");
        this.checkScopeMappings(rep.getScopeMappings(), true);
        Assert.assertNull((Object)rep.getClientScopeMappings(), (String)"Client scope mappings empty");
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(false), Boolean.valueOf(true));
        Assert.assertNotNull((Object)rep.getUsers(), (String)"The service account user should be exported");
        Assert.assertEquals((int)1, (int)rep.getUsers().size(), (String)"Only one client has a service account");
        this.checkServiceAccountRoles((UserRepresentation)rep.getUsers().get(0), false);
        Assert.assertNull((Object)rep.getDefaultGroups(), (String)"Default groups are empty");
        Assert.assertNull((Object)rep.getGroups(), (String)"Groups are empty");
        Assert.assertNull((Object)rep.getRoles(), (String)"Realm and client roles are empty");
        Assert.assertNotNull((Object)rep.getClients(), (String)"Clients not empty");
        this.checkClients(rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), false);
        this.checkClientScopeMappings(rep.getClientScopeMappings());
        rep = this.adminClient.realm(EXPORT_TEST_REALM).partialExport(Boolean.valueOf(true), Boolean.valueOf(true));
        Assert.assertNotNull((Object)rep.getUsers(), (String)"The service accout user should be exported");
        Assert.assertEquals((int)1, (int)rep.getUsers().size(), (String)"Only one client has a service account");
        this.checkServiceAccountRoles((UserRepresentation)rep.getUsers().get(0), true);
        Assert.assertNull((Object)rep.getDefaultGroups(), (String)"Default groups are empty");
        Assert.assertNotNull((Object)rep.getGroups(), (String)"Groups not empty");
        this.checkGroups(rep.getGroups());
        Assert.assertNotNull((Object)rep.getRoles(), (String)"Realm and client roles not empty");
        Assert.assertNotNull((Object)rep.getRoles().getRealm());
        Assert.assertNotNull((Object)rep.getRoles().getRealm());
        this.checkRealmRoles(rep.getRoles().getRealm());
        Assert.assertNotNull((Object)rep.getRoles().getClient(), (String)"Client roles not empty");
        this.checkClientRoles(rep.getRoles().getClient());
        Assert.assertNotNull((Object)rep.getClients(), (String)"Clients not empty");
        this.checkClients(rep.getClients());
        this.checkScopeMappings(rep.getScopeMappings(), false);
        this.checkClientScopeMappings(rep.getClientScopeMappings());
        this.checkSecretsAreMasked(rep);
    }

    private void checkServiceAccountRoles(UserRepresentation serviceAccount, boolean rolesExpected) {
        Assert.assertTrue((boolean)serviceAccount.getUsername().startsWith("service-account-"), (String)"User is a service account");
        Assert.assertNull((Object)serviceAccount.getCredentials(), (String)"Password should be null");
        if (rolesExpected) {
            List realmRoles = serviceAccount.getRealmRoles();
            MatcherAssert.assertThat((String)"Realm roles are OK", (Object)realmRoles, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"uma_authorization", "user", "offline_access"}));
            Map clientRoles = serviceAccount.getClientRoles();
            Assert.assertNotNull((Object)clientRoles, (String)"Client roles are exported");
            MatcherAssert.assertThat((String)"Client roles for test-app-service-account are OK", (Object)((List)clientRoles.get("test-app-service-account")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test-app-service-account", "test-app-service-account-parent"}));
            MatcherAssert.assertThat((String)"Client roles for account are OK", (Object)((List)clientRoles.get("account")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"manage-account", "view-profile"}));
        } else {
            Assert.assertNull((Object)serviceAccount.getRealmRoles(), (String)"Service account should be exported without realm roles");
            Assert.assertNull((Object)serviceAccount.getClientRoles(), (String)"Service account should be exported without client roles");
        }
    }

    private void checkSecretsAreMasked(RealmRepresentation rep) {
        for (ClientRepresentation client : rep.getClients()) {
            if (!Boolean.FALSE.equals(client.isPublicClient()) || !Boolean.FALSE.equals(client.isBearerOnly())) continue;
            Assert.assertEquals((Object)"**********", (Object)client.getSecret(), (String)"Client secret masked");
            String rotatedSecret = Optional.ofNullable(client.getAttributes()).flatMap(attrs -> Optional.ofNullable((String)attrs.get("client.secret.rotated"))).orElse("**********");
            Assert.assertEquals((Object)"**********", (Object)rotatedSecret, (String)"Rotated client secret masked");
        }
        for (IdentityProviderRepresentation idp : rep.getIdentityProviders()) {
            Assert.assertEquals((Object)"**********", idp.getConfig().get("clientSecret"), (String)"IdentityProvider clientSecret masked");
        }
        Assert.assertEquals((Object)"**********", rep.getSmtpServer().get("password"), (String)"SMTP password masked");
        MultivaluedHashMap components = rep.getComponents();
        List keys = (List)components.get((Object)"org.keycloak.keys.KeyProvider");
        Assert.assertNotNull((Object)keys, (String)"Keys not null");
        Assert.assertTrue((keys.size() > 0 ? 1 : 0) != 0, (String)"At least one key returned");
        boolean found = false;
        for (ComponentExportRepresentation component : keys) {
            if (!"rsa".equals(component.getProviderId())) continue;
            Assert.assertEquals((Object)"**********", (Object)component.getConfig().getFirst((Object)"privateKey"), (String)"RSA KeyProvider privateKey masked");
            found = true;
        }
        Assert.assertTrue((boolean)found, (String)"Found rsa private key");
        List userStorage = (List)components.get((Object)"org.keycloak.storage.UserStorageProvider");
        Assert.assertNotNull((Object)userStorage, (String)"UserStorageProvider not null");
        Assert.assertTrue((userStorage.size() > 0 ? 1 : 0) != 0, (String)"At least one UserStorageProvider returned");
        found = false;
        for (ComponentExportRepresentation component : userStorage) {
            if (!"ldap".equals(component.getProviderId())) continue;
            Assert.assertEquals((Object)"**********", (Object)component.getConfig().getFirst((Object)"bindCredential"), (String)"LDAP provider bindCredential masked");
            found = true;
        }
        Assert.assertTrue((boolean)found, (String)"Found ldap bindCredential");
    }

    private void checkClientScopeMappings(Map<String, List<ScopeMappingRepresentation>> mappings) {
        Map<String, Set<String>> map = this.extractScopeMappings(mappings.get("test-app"));
        Set<String> set = map.get("test-app-scope");
        Assert.assertTrue((boolean)set.contains("customer-admin-composite-role"), (String)"Client test-app / test-app-scope contains customer-admin-composite-role");
        set = map.get("third-party");
        Assert.assertTrue((boolean)set.contains("customer-user"), (String)"Client test-app / third-party contains customer-user");
        map = this.extractScopeMappings(mappings.get("test-app-scope"));
        set = map.get("test-app-scope");
        Assert.assertTrue((boolean)set.contains("test-app-allowed-by-scope"), (String)"Client test-app-scope / test-app-scope contains test-app-allowed-by-scope");
    }

    private void checkScopeMappings(List<ScopeMappingRepresentation> scopeMappings, boolean expectOnlyOfflineAccess) {
        ScopeMappingRepresentation offlineAccessScope = scopeMappings.stream().filter(rep -> "offline_access".equals(rep.getClientScope())).findFirst().get();
        Assert.assertTrue((boolean)offlineAccessScope.getRoles().contains("offline_access"));
        if (expectOnlyOfflineAccess) {
            Assert.assertEquals((int)1, (int)scopeMappings.size());
            return;
        }
        Map<String, Set<String>> map = this.extractScopeMappings(scopeMappings);
        Set<String> set = map.get("test-app");
        Assert.assertTrue((boolean)set.contains("user"), (String)"Client test-app contains user");
        set = map.get("test-app-scope");
        Assert.assertTrue((boolean)set.contains("user"), (String)"Client test-app contains user");
        Assert.assertTrue((boolean)set.contains("admin"), (String)"Client test-app contains admin");
        set = map.get("third-party");
        Assert.assertTrue((boolean)set.contains("user"), (String)"Client test-app contains third-party");
    }

    private Map<String, Set<String>> extractScopeMappings(List<ScopeMappingRepresentation> scopeMappings) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (ScopeMappingRepresentation r : scopeMappings) {
            map.put(r.getClient(), r.getRoles());
        }
        return map;
    }

    private void checkClientRoles(Map<String, List<RoleRepresentation>> clientRoles) {
        Map<String, RoleRepresentation> roles = this.collectRoles(clientRoles.get("test-app"));
        Assert.assertTrue((boolean)roles.containsKey("customer-admin"), (String)"Client role customer-admin for test-app");
        Assert.assertTrue((boolean)roles.containsKey("sample-client-role"), (String)"Client role sample-client-role for test-app");
        Assert.assertTrue((boolean)roles.containsKey("customer-user"), (String)"Client role customer-user for test-app");
        Assert.assertTrue((boolean)roles.containsKey("customer-admin-composite-role"), (String)"Client role customer-admin-composite-role for test-app");
        RoleRepresentation.Composites cmp = roles.get("customer-admin-composite-role").getComposites();
        Assert.assertTrue((boolean)cmp.getRealm().contains("customer-user-premium"), (String)"customer-admin-composite-role / realm / customer-user-premium");
        Assert.assertTrue((boolean)((List)cmp.getClient().get("test-app")).contains("customer-admin"), (String)"customer-admin-composite-role / client['test-app'] / customer-admin");
        roles = this.collectRoles(clientRoles.get("test-app-scope"));
        Assert.assertTrue((boolean)roles.containsKey("test-app-disallowed-by-scope"), (String)"Client role test-app-disallowed-by-scope for test-app-scope");
        Assert.assertTrue((boolean)roles.containsKey("test-app-allowed-by-scope"), (String)"Client role test-app-allowed-by-scope for test-app-scope");
        roles = this.collectRoles(clientRoles.get("test-app-service-account"));
        MatcherAssert.assertThat((String)"Client roles are OK for test-app-service-account", roles.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"test-app-service-account", "test-app-service-account-parent", "test-app-service-account-child"}));
    }

    private Map<String, RoleRepresentation> collectRoles(List<RoleRepresentation> roles) {
        HashMap<String, RoleRepresentation> map = new HashMap<String, RoleRepresentation>();
        if (roles == null) {
            return map;
        }
        for (RoleRepresentation r : roles) {
            map.put(r.getName(), r);
        }
        return map;
    }

    private void checkClients(List<ClientRepresentation> clients) {
        HashSet<String> set = new HashSet<String>();
        for (ClientRepresentation c : clients) {
            set.add(c.getClientId());
        }
        Assert.assertTrue((boolean)set.contains("test-app"), (String)"Client test-app");
        Assert.assertTrue((boolean)set.contains("test-app-scope"), (String)"Client test-app-scope");
        Assert.assertTrue((boolean)set.contains("third-party"), (String)"Client third-party");
    }

    private void checkRealmRoles(List<RoleRepresentation> realmRoles) {
        HashSet<String> set = new HashSet<String>();
        for (RoleRepresentation r : realmRoles) {
            set.add(r.getName());
        }
        Assert.assertTrue((boolean)set.contains("sample-realm-role"), (String)"Role sample-realm-role");
        Assert.assertTrue((boolean)set.contains("realm-composite-role"), (String)"Role realm-composite-role");
        Assert.assertTrue((boolean)set.contains("customer-user-premium"), (String)"Role customer-user-premium");
        Assert.assertTrue((boolean)set.contains("admin"), (String)"Role admin");
        Assert.assertTrue((boolean)set.contains("user"), (String)"Role user");
    }

    private void checkGroups(List<GroupRepresentation> groups) {
        HashSet<String> set = new HashSet<String>();
        for (GroupRepresentation g : groups) {
            this.compileGroups(set, g);
        }
        Assert.assertTrue((boolean)set.contains("/roleRichGroup"), (String)"Group /roleRichGroup");
        Assert.assertTrue((boolean)set.contains("/roleRichGroup/level2group"), (String)"Group /roleRichGroup/level2group");
        Assert.assertTrue((boolean)set.contains("/topGroup"), (String)"Group /topGroup");
        Assert.assertTrue((boolean)set.contains("/topGroup/level2group"), (String)"Group /topGroup/level2group");
    }

    private void compileGroups(Set<String> found, GroupRepresentation g) {
        found.add(g.getPath());
        if (g.getSubGroups() != null) {
            for (GroupRepresentation s : g.getSubGroups()) {
                this.compileGroups(found, s);
            }
        }
    }

    private void checkDefaultRoles(List<String> defaultRoles) {
        HashSet<String> roles = new HashSet<String>(defaultRoles);
        Assert.assertTrue((boolean)roles.contains("uma_authorization"), (String)"Default role 'uma_authorization'");
        Assert.assertTrue((boolean)roles.contains("offline_access"), (String)"Default role 'offline_access'");
        Assert.assertTrue((boolean)roles.contains("user"), (String)"Default role 'user'");
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

