/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.keycloak.models.UserModel;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.util.JsonSerialization;

public class AbstractPartialImportTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD, config=PartialImportRealmConfig.class)
    ManagedRealm managedRealm;
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm masterRealm;
    @InjectClient(ref="clientRolesClient", config=PartialImportRolesClientConfig.class)
    ManagedClient rolesClient;
    @InjectClient(ref="clientServiceAccount", config=PartialImportServiceClientConfig.class)
    ManagedClient serviceClient;
    @InjectAdminEvents
    AdminEvents adminEvents;
    private static final String CLIENT_ROLES_CLIENT = "clientRolesClient";
    protected static final String CLIENT_SERVICE_ACCOUNT = "clientServiceAccount";
    protected static final String USER_PREFIX = "user";
    private static final String GROUP_PREFIX = "group";
    protected static final String CLIENT_PREFIX = "client";
    protected static final String REALM_ROLE_PREFIX = "realmRole";
    protected static final String CLIENT_ROLE_PREFIX = "clientRole";
    protected static final String[] IDP_ALIASES = new String[]{"twitter", "github", "facebook", "google", "linkedin-openid-connect", "microsoft", "stackoverflow"};
    protected static final int NUM_ENTITIES = IDP_ALIASES.length;
    private static final ResourceServerRepresentation resourceServerSampleSettings;
    protected PartialImportRepresentation piRep;

    @BeforeEach
    public void init() {
        this.piRep = new PartialImportRepresentation();
    }

    protected void setFail() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.FAIL.toString());
    }

    protected void setSkip() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.SKIP.toString());
    }

    protected void setOverwrite() {
        this.piRep.setIfResourceExists(PartialImportRepresentation.Policy.OVERWRITE.toString());
    }

    protected PartialImportResults doImport() {
        try (Response response = this.managedRealm.admin().partialImport(this.piRep);){
            PartialImportResults partialImportResults = (PartialImportResults)response.readEntity(PartialImportResults.class);
            return partialImportResults;
        }
    }

    protected void addUsers() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = UserConfigBuilder.create().username(USER_PREFIX + i).email(USER_PREFIX + i + "@foo.com").name("foo", "bar").build();
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    protected void addUsersWithIds() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = UserConfigBuilder.create().id(UUID.randomUUID().toString()).username(USER_PREFIX + i).email(USER_PREFIX + i + "@foo.com").name("foo", "bar").build();
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    protected void addUsersWithTermsAndConditions() {
        ArrayList<UserRepresentation> users = new ArrayList<UserRepresentation>();
        ArrayList<String> requiredActions = new ArrayList<String>();
        requiredActions.add(UserModel.RequiredAction.TERMS_AND_CONDITIONS.name());
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            UserRepresentation user = UserConfigBuilder.create().username(USER_PREFIX + i).email(USER_PREFIX + i + "@foo.com").name("foo", "bar").build();
            user.setRequiredActions(requiredActions);
            users.add(user);
        }
        this.piRep.setUsers(users);
    }

    protected void addGroups() {
        ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName(GROUP_PREFIX + i);
            group.setPath("/group" + i);
            groups.add(group);
        }
        this.piRep.setGroups(groups);
    }

    protected void addClients(boolean withServiceAccounts) {
        ArrayList<ClientRepresentation> clients = new ArrayList<ClientRepresentation>();
        ArrayList<UserRepresentation> serviceAccounts = new ArrayList<UserRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId(CLIENT_PREFIX + i);
            client.setName(CLIENT_PREFIX + i);
            clients.add(client);
            if (!withServiceAccounts) continue;
            client.setServiceAccountsEnabled(Boolean.valueOf(true));
            client.setBearerOnly(Boolean.valueOf(false));
            client.setPublicClient(Boolean.valueOf(false));
            client.setAuthorizationSettings(resourceServerSampleSettings);
            client.setAuthorizationServicesEnabled(Boolean.valueOf(true));
            UserRepresentation serviceAccount = new UserRepresentation();
            serviceAccount.setUsername("service-account-" + client.getClientId());
            serviceAccount.setEnabled(Boolean.valueOf(true));
            serviceAccount.setEmail(serviceAccount.getUsername() + "@placeholder.org");
            serviceAccount.setServiceAccountClientId(client.getClientId());
            serviceAccounts.add(serviceAccount);
        }
        if (withServiceAccounts) {
            if (this.piRep.getUsers() == null) {
                this.piRep.setUsers(new ArrayList());
            }
            this.piRep.getUsers().addAll(serviceAccounts);
        }
        this.piRep.setClients(clients);
    }

    protected void addProviders() {
        this.addProviders(false);
    }

    private void addProviders(boolean withMappers) {
        ArrayList<IdentityProviderRepresentation> providers = new ArrayList<IdentityProviderRepresentation>();
        ArrayList<IdentityProviderMapperRepresentation> mappers = new ArrayList<IdentityProviderMapperRepresentation>();
        for (String alias : IDP_ALIASES) {
            IdentityProviderRepresentation idpRep = new IdentityProviderRepresentation();
            idpRep.setAlias(alias);
            idpRep.setProviderId(alias);
            idpRep.setEnabled(true);
            idpRep.setAuthenticateByDefault(false);
            idpRep.setFirstBrokerLoginFlowAlias("first broker login");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("clientSecret", "secret");
            config.put("clientId", alias);
            idpRep.setConfig(config);
            providers.add(idpRep);
            if (!withMappers) continue;
            HashMap<String, String> mapConfig = new HashMap<String, String>();
            mapConfig.put("external.role", "IDP.TEST_ROLE");
            mapConfig.put("syncMode", "FORCE");
            mapConfig.put("role", "TEST_ROLE");
            IdentityProviderMapperRepresentation idpMapRep = new IdentityProviderMapperRepresentation();
            idpMapRep.setName(alias + "_mapper");
            idpMapRep.setIdentityProviderAlias(alias);
            idpMapRep.setIdentityProviderMapper("keycloak-oidc-role-to-role-idp-mapper");
            idpMapRep.setConfig(mapConfig);
            mappers.add(idpMapRep);
        }
        this.piRep.setIdentityProviders(providers);
        if (withMappers) {
            this.piRep.setIdentityProviderMappers(mappers);
        }
    }

    protected void addProviderMappers() {
        this.addProviders(true);
    }

    private List<RoleRepresentation> makeRoles(String prefix) {
        ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            RoleRepresentation role = new RoleRepresentation();
            role.setName(prefix + i);
            roles.add(role);
        }
        return roles;
    }

    protected void addRealmRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        roles.setRealm(this.makeRoles(REALM_ROLE_PREFIX));
        this.piRep.setRoles(roles);
    }

    protected void addClientRoles() {
        RolesRepresentation roles = this.piRep.getRoles();
        if (roles == null) {
            roles = new RolesRepresentation();
        }
        HashMap<String, List<RoleRepresentation>> clientRolesMap = new HashMap<String, List<RoleRepresentation>>();
        clientRolesMap.put(CLIENT_ROLES_CLIENT, this.makeRoles(CLIENT_ROLE_PREFIX));
        roles.setClient(clientRolesMap);
        this.piRep.setRoles(roles);
    }

    protected void testFail() {
        this.setFail();
        PartialImportResults results = this.doImport();
        Assertions.assertNull((Object)results.getErrorMessage());
        results = this.doImport();
        Assertions.assertNotNull((Object)results.getErrorMessage());
    }

    protected void testSkip() {
        this.testSkip(NUM_ENTITIES);
    }

    protected void testSkip(int numberEntities) {
        this.setSkip();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)numberEntities, (int)results.getAdded());
        results = this.doImport();
        Assertions.assertEquals((int)numberEntities, (int)results.getSkipped());
    }

    protected void testOverwrite() {
        this.testOverwrite(NUM_ENTITIES);
    }

    protected void testOverwrite(int numberEntities) {
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)numberEntities, (int)results.getAdded());
        results = this.doImport();
        Assertions.assertEquals((int)numberEntities, (int)results.getOverwritten());
    }

    static {
        try {
            resourceServerSampleSettings = (ResourceServerRepresentation)JsonSerialization.readValue((InputStream)AbstractPartialImportTest.class.getResourceAsStream("sample-authz-partial-import.json"), ResourceServerRepresentation.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load sample resource server configuration", e);
        }
    }

    public static class PartialImportServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            return builder.dependency("org.keycloak.tests", "keycloak-tests-custom-scripts");
        }
    }

    private static class PartialImportServiceClientConfig
    implements ClientConfig {
        private PartialImportServiceClientConfig() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder builder) {
            builder.clientId(AbstractPartialImportTest.CLIENT_SERVICE_ACCOUNT);
            builder.name(AbstractPartialImportTest.CLIENT_SERVICE_ACCOUNT);
            builder.secret("secret");
            builder.protocol("openid-connect");
            builder.rootUrl("http://localhost/foo");
            builder.publicClient(false);
            builder.serviceAccountsEnabled(true);
            return builder;
        }
    }

    private static class PartialImportRolesClientConfig
    implements ClientConfig {
        private PartialImportRolesClientConfig() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder builder) {
            builder.clientId(AbstractPartialImportTest.CLIENT_ROLES_CLIENT);
            builder.name(AbstractPartialImportTest.CLIENT_ROLES_CLIENT);
            builder.protocol("openid-connect");
            return builder;
        }
    }

    private static class PartialImportRealmConfig
    implements RealmConfig {
        private PartialImportRealmConfig() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder builder) {
            builder.duplicateEmailsAllowed(false);
            return builder;
        }
    }
}

