/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.partialimport.AbstractPartialImportTest;
import org.keycloak.tests.utils.Assert;

@KeycloakIntegrationTest(config=AbstractPartialImportTest.PartialImportServerConfig.class)
public class PartialImportClientTest
extends AbstractPartialImportTest {
    @Test
    public void testAddClients() {
        this.setFail();
        this.addClients(false);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            ClientResource clientRsc = this.managedRealm.admin().clients().get(id);
            ClientRepresentation client = clientRsc.toRepresentation();
            Assertions.assertTrue((boolean)client.getName().startsWith("client"));
        }
    }

    @Test
    public void testAddClientsWithServiceAccountsAndAuthorization() {
        this.setFail();
        this.addClients(true);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            if (result.getResourceType().equals((Object)ResourceType.CLIENT)) {
                String id = result.getId();
                ClientResource clientRsc = this.managedRealm.admin().clients().get(id);
                ClientRepresentation client = clientRsc.toRepresentation();
                Assertions.assertTrue((boolean)client.getName().startsWith("client"));
                Assertions.assertTrue((boolean)client.isServiceAccountsEnabled());
                Assertions.assertTrue((boolean)client.getAuthorizationServicesEnabled());
                AuthorizationResource authRsc = clientRsc.authorization();
                ResourceServerRepresentation authRep = authRsc.exportSettings();
                Assertions.assertNotNull((Object)authRep);
                Assertions.assertEquals((int)2, (int)authRep.getResources().size());
                Assertions.assertEquals((int)3, (int)authRep.getPolicies().size());
                continue;
            }
            UserResource userRsc = this.managedRealm.admin().users().get(result.getId());
            Assert.assertTrue((boolean)userRsc.toRepresentation().getUsername().startsWith("service-account-client"));
        }
    }

    @Test
    public void testAddClientsFail() {
        this.addClients(false);
        this.testFail();
    }

    @Test
    public void testAddClientsSkip() {
        this.addClients(false);
        this.testSkip();
    }

    @Test
    public void testAddClientsSkipWithServiceAccountsAndAuthorization() {
        this.addClients(true);
        this.setSkip();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getAdded());
        results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getSkipped());
    }

    @Test
    public void testAddClientsOverwrite() {
        this.addClients(false);
        this.testOverwrite();
    }

    @Test
    public void testAddClientsOverwriteWithServiceAccountsAndAuthorization() {
        this.addClients(true);
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getAdded());
        results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getOverwritten());
    }

    @Test
    public void testAddClientsOverwriteServiceAccountsWithNoServiceAccounts() {
        List l;
        int i;
        this.addClients(true);
        this.setOverwrite();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 2), (int)results.getAdded());
        for (i = 0; i < NUM_ENTITIES; ++i) {
            l = this.managedRealm.admin().users().search("service-account-client" + i);
            Assertions.assertEquals((int)1, (int)l.size());
        }
        this.piRep = new PartialImportRepresentation();
        this.addClients(false);
        this.setOverwrite();
        results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getOverwritten());
        for (i = 0; i < NUM_ENTITIES; ++i) {
            l = this.managedRealm.admin().users().search("service-account-client" + i);
            Assertions.assertEquals((int)0, (int)l.size());
        }
    }

    @Test
    public void testOverwriteExistingClientWithRoles() {
        this.setOverwrite();
        ClientRepresentation client = (ClientRepresentation)this.masterRealm.admin().clients().findByClientId("broker").get(0);
        List clientRoles = this.masterRealm.admin().clients().get(client.getId()).roles().list();
        HashMap<String, List> clients = new HashMap<String, List>();
        clients.put(client.getClientId(), clientRoles);
        RolesRepresentation roles = new RolesRepresentation();
        roles.setClient(clients);
        this.piRep.setClients(List.of(client));
        this.piRep.setRoles(roles);
        this.doImport();
    }

    @Test
    public void testOverwriteExistingInternalClient() {
        this.setOverwrite();
        ClientRepresentation client = (ClientRepresentation)this.masterRealm.admin().clients().findByClientId("security-admin-console").get(0);
        ClientRepresentation client2 = (ClientRepresentation)this.masterRealm.admin().clients().findByClientId("master-realm").get(0);
        this.piRep.setClients(Arrays.asList(client, client2));
        PartialImportResults result = this.doImport();
        Assertions.assertEquals((int)0, (int)result.getOverwritten());
    }

    @Test
    public void testOverwriteExistingClientWithServiceAccount() {
        this.setOverwrite();
        this.piRep.setClients(Collections.singletonList(this.serviceClient.admin().toRepresentation()));
        Assertions.assertEquals((int)1, (int)this.doImport().getOverwritten());
        ClientRepresentation client = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("clientServiceAccount").get(0);
        Assertions.assertDoesNotThrow(() -> this.managedRealm.admin().clients().get(client.getId()).getServiceAccountUser());
    }
}

