/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import java.util.Arrays;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.partialimport.AbstractPartialImportTest;

@KeycloakIntegrationTest(config=AbstractPartialImportTest.PartialImportServerConfig.class)
public class PartialImportProvidersTest
extends AbstractPartialImportTest {
    @Test
    public void testAddProviders() {
        this.setFail();
        this.addProviders();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)IDP_ALIASES.length, (int)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            IdentityProviderResource idpRsc = this.managedRealm.admin().identityProviders().get(id);
            IdentityProviderRepresentation idp = idpRsc.toRepresentation();
            Map config = idp.getConfig();
            Assertions.assertTrue((boolean)Arrays.asList(IDP_ALIASES).contains(config.get("clientId")));
        }
    }

    @Test
    public void testAddProviderMappers() {
        this.setFail();
        this.addProviderMappers();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(IDP_ALIASES.length * 2), (int)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            if (!ResourceType.IDP.equals((Object)result.getResourceType())) continue;
            String id = result.getId();
            IdentityProviderResource idpRsc = this.managedRealm.admin().identityProviders().get(id);
            IdentityProviderMapperRepresentation idpMap = (IdentityProviderMapperRepresentation)idpRsc.getMappers().get(0);
            String alias = idpMap.getIdentityProviderAlias();
            Assertions.assertTrue((boolean)Arrays.asList(IDP_ALIASES).contains(alias));
            Assertions.assertEquals((Object)(alias + "_mapper"), (Object)idpMap.getName());
            Assertions.assertEquals((Object)"keycloak-oidc-role-to-role-idp-mapper", (Object)idpMap.getIdentityProviderMapper());
            Assertions.assertEquals((Object)"IDP.TEST_ROLE", idpMap.getConfig().get("external.role"));
            Assertions.assertEquals((Object)"FORCE", idpMap.getConfig().get("syncMode"));
            Assertions.assertEquals((Object)"TEST_ROLE", idpMap.getConfig().get("role"));
        }
    }

    @Test
    public void testAddProvidersFail() {
        this.addProviders();
        this.testFail();
    }

    @Test
    public void testAddProviderMappersFail() {
        this.addProviderMappers();
        this.testFail();
    }

    @Test
    public void testAddProvidersSkip() {
        this.addProviders();
        this.testSkip();
    }

    @Test
    public void testAddProviderMappersSkip() {
        this.addProviderMappers();
        this.testSkip(NUM_ENTITIES * 2);
    }

    @Test
    public void testAddProvidersOverwrite() {
        this.addProviders();
        this.testOverwrite();
    }

    @Test
    public void testAddProviderMappersOverwrite() {
        this.addProviderMappers();
        this.testOverwrite(NUM_ENTITIES * 2);
    }
}

