/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.partialimport.AbstractPartialImportTest;

@KeycloakIntegrationTest(config=AbstractPartialImportTest.PartialImportServerConfig.class)
public class PartialImportRealmTest
extends AbstractPartialImportTest {
    private static final int NUM_RESOURCE_TYPES = 6;

    @Test
    public void testEverythingFail() {
        this.setFail();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        Assertions.assertNotNull((Object)results.getErrorMessage());
    }

    @Test
    public void testEverythingSkip() {
        this.setSkip();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 6), (int)results.getSkipped());
    }

    @Test
    public void testEverythingSkipWithServiceAccounts() {
        this.setSkip();
        this.importEverything(true);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 7), (int)results.getSkipped());
    }

    @Test
    public void testEverythingOverwrite() {
        this.setOverwrite();
        this.importEverything(false);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 6), (int)results.getOverwritten());
    }

    @Test
    public void testEverythingOverwriteWithServiceAccounts() {
        this.setOverwrite();
        this.importEverything(true);
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)(NUM_ENTITIES * 7), (int)results.getOverwritten());
    }

    private void importEverything(boolean withServiceAccounts) {
        this.addUsers();
        this.addGroups();
        this.addClients(withServiceAccounts);
        this.addProviders();
        this.addRealmRoles();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        Assertions.assertNull((Object)results.getErrorMessage());
        if (withServiceAccounts) {
            Assertions.assertEquals((int)(NUM_ENTITIES * 7), (int)results.getAdded());
        } else {
            Assertions.assertEquals((int)(NUM_ENTITIES * 6), (int)results.getAdded());
        }
    }
}

