/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.partialimport.AbstractPartialImportTest;

@KeycloakIntegrationTest(config=AbstractPartialImportTest.PartialImportServerConfig.class)
public class PartialImportRolesTest
extends AbstractPartialImportTest {
    @Test
    public void testAddRealmRoles() {
        this.setFail();
        this.addRealmRoles();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        for (PartialImportResult result : results.getResults()) {
            String name = result.getResourceName();
            RoleResource roleRsc = this.managedRealm.admin().roles().get(name);
            RoleRepresentation role = roleRsc.toRepresentation();
            Assertions.assertTrue((boolean)role.getName().startsWith("realmRole"));
        }
    }

    @Test
    public void testAddClientRoles() {
        this.setFail();
        this.addClientRoles();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        List clientRoles = this.rolesClient.admin().roles().list();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)clientRoles.size());
        for (RoleRepresentation roleRep : clientRoles) {
            Assertions.assertTrue((boolean)roleRep.getName().startsWith("clientRole"));
        }
    }

    @Test
    public void testAddRealmRolesFail() {
        this.addRealmRoles();
        this.testFail();
    }

    @Test
    public void testAddClientRolesFail() {
        this.addClientRoles();
        this.testFail();
    }

    @Test
    public void testAddRealmRolesSkip() {
        this.addRealmRoles();
        this.testSkip();
    }

    @Test
    public void testAddClientRolesSkip() {
        this.addClientRoles();
        this.testSkip();
    }

    @Test
    public void testAddRealmRolesOverwrite() {
        this.addRealmRoles();
        this.testOverwrite();
    }

    @Test
    public void testAddClientRolesOverwrite() {
        this.addClientRoles();
        this.testOverwrite();
    }

    @Test
    public void testOverwriteDefaultRole() {
        this.setOverwrite();
        RolesRepresentation roles = new RolesRepresentation();
        RoleRepresentation oldDefaultRole = this.managedRealm.admin().toRepresentation().getDefaultRole();
        roles.setRealm(Collections.singletonList(oldDefaultRole));
        this.piRep.setRoles(roles);
        Assertions.assertEquals((int)1, (int)this.doImport().getOverwritten(), (String)"default role should have been overwritten");
    }
}

