/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.partialimport;

import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.authentication.requiredactions.TermsAndConditions;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.partialimport.PartialImportResult;
import org.keycloak.partialimport.PartialImportResults;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.partialimport.AbstractPartialImportTest;

@KeycloakIntegrationTest(config=AbstractPartialImportTest.PartialImportServerConfig.class)
public class PartialImportUserTest
extends AbstractPartialImportTest {
    @Test
    public void testAddUsers() {
        this.adminEvents.clear();
        this.setFail();
        this.addUsers();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = (AdminEventRepresentation)this.adminEvents.poll();
            Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)adminEvent.getRealmId());
            Assertions.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assertions.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            MatcherAssert.assertThat((Object)adminEvent.getResourceType(), (Matcher)Matchers.equalTo((Object)ResourceType.REALM.name()));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
        }
        Assertions.assertNull((Object)this.adminEvents.poll());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.managedRealm.admin().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            MatcherAssert.assertThat((Object)user.getUsername(), (Matcher)CoreMatchers.startsWith((String)"user"));
            MatcherAssert.assertThat(userIds, (Matcher)CoreMatchers.hasItem((Object)id));
        }
    }

    @Test
    public void testAddUsersWithIds() {
        this.adminEvents.clear();
        this.setFail();
        this.addUsersWithIds();
        HashSet<String> userRepIds = new HashSet<String>();
        for (UserRepresentation userRep : this.piRep.getUsers()) {
            userRepIds.add(userRep.getId());
        }
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = (AdminEventRepresentation)this.adminEvents.poll();
            Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)adminEvent.getRealmId());
            Assertions.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assertions.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            MatcherAssert.assertThat((Object)adminEvent.getResourceType(), (Matcher)Matchers.equalTo((Object)ResourceType.REALM.name()));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
            MatcherAssert.assertThat(userRepIds, (Matcher)CoreMatchers.hasItem((Object)userId));
        }
        Assertions.assertNull((Object)this.adminEvents.poll());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.managedRealm.admin().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            MatcherAssert.assertThat((Object)user.getUsername(), (Matcher)CoreMatchers.startsWith((String)"user"));
            MatcherAssert.assertThat(userIds, (Matcher)CoreMatchers.hasItem((Object)id));
            MatcherAssert.assertThat(userRepIds, (Matcher)CoreMatchers.hasItem((Object)id));
        }
    }

    @Test
    public void testAddUsersWithDuplicateEmailsForbidden() {
        this.adminEvents.clear();
        this.setFail();
        this.addUsers();
        UserRepresentation user = UserConfigBuilder.create().username("user999").email("user1@foo.com").name("foo", "bar").build();
        this.piRep.getUsers().add(user);
        try (Response response = this.managedRealm.admin().partialImport(this.piRep);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
        }
    }

    @Test
    public void testAddUsersWithDuplicateEmailsAllowed() {
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        realmRep.setDuplicateEmailsAllowed(Boolean.valueOf(true));
        this.managedRealm.admin().update(realmRep);
        this.adminEvents.clear();
        this.setFail();
        this.addUsers();
        this.doImport();
        UserRepresentation user = UserConfigBuilder.create().username("user999").email("user1@foo.com").name("foo", "bar").build();
        this.piRep.setUsers(List.of(user));
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)1, (int)results.getAdded());
    }

    @Test
    public void testAddUsersWithTermsAndConditions() {
        this.adminEvents.clear();
        this.setFail();
        this.addUsersWithTermsAndConditions();
        PartialImportResults results = this.doImport();
        Assertions.assertEquals((int)NUM_ENTITIES, (int)results.getAdded());
        HashSet<String> userIds = new HashSet<String>();
        for (int i = 0; i < NUM_ENTITIES; ++i) {
            AdminEventRepresentation adminEvent = (AdminEventRepresentation)this.adminEvents.poll();
            Assertions.assertEquals((Object)this.managedRealm.getId(), (Object)adminEvent.getRealmId());
            Assertions.assertEquals((Object)OperationType.CREATE.name(), (Object)adminEvent.getOperationType());
            Assertions.assertTrue((boolean)adminEvent.getResourcePath().startsWith("users/"));
            String userId = adminEvent.getResourcePath().substring(6);
            userIds.add(userId);
        }
        Assertions.assertNull((Object)this.adminEvents.poll());
        for (PartialImportResult result : results.getResults()) {
            String id = result.getId();
            UserResource userRsc = this.managedRealm.admin().users().get(id);
            UserRepresentation user = userRsc.toRepresentation();
            Assertions.assertTrue((boolean)user.getUsername().startsWith("user"));
            Assertions.assertTrue((boolean)userIds.contains(id));
            MatcherAssert.assertThat((Object)user.getRequiredActions(), (Matcher)Matchers.contains((Object[])new String[]{TermsAndConditions.PROVIDER_ID}));
        }
    }

    @Test
    public void testAddUsersFail() {
        this.addUsers();
        this.testFail();
    }

    @Test
    public void testAddUsersSkip() {
        this.addUsers();
        this.testSkip();
    }

    @Test
    public void testAddUsersOverwrite() {
        this.addUsers();
        this.testOverwrite();
    }
}

