/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import java.util.List;
import java.util.Map;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;

public class AbstractRealmRolesTest {
    @InjectRealm(config=RealmRolesRealmConf.class)
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;

    private static class RealmRolesRealmConf
    implements RealmConfig {
        private RealmRolesRealmConf() {
        }

        public RealmConfigBuilder configure(RealmConfigBuilder builder) {
            builder.addGroup("test-role-group").path("/test-role-group");
            builder.addUser("test-role-member").name("Test", "Role User").email("test-role-member@test-role-member.com").roles(new String[]{"default-roles-default"}).emailVerified(true).requiredActions(new String[0]);
            builder.addClient("client-a").id("client-a").description("Client A");
            builder.addClient("client-c").id("client-c").description("Client C");
            builder.addRole("role-a").description("Role A").attributes(Map.of("role-a-attr-key1", List.of("role-a-attr-val1")));
            builder.addRole("role-b").description("Role B");
            builder.addClientRole("client-a", "role-c").description("Role C");
            builder.addRole("role-with-users").description("Role with users");
            builder.addRole("role-without-users").description("role-without-users");
            return builder;
        }
    }
}

