/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.cache.CacheRealmProvider;
import org.keycloak.models.cache.infinispan.RealmAdapter;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.tests.admin.realm.AbstractRealmTest;

@KeycloakIntegrationTest
public class RealmAttributesTest
extends AbstractRealmTest {
    @Test
    public void excludesFieldsFromAttributes() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("attributes");
        this.adminClient.realms().create(rep);
        RealmRepresentation rep2 = this.adminClient.realm("attributes").toRepresentation();
        if (rep2.getAttributes() != null) {
            Stream.of("cibaBackchannelTokenDeliveryMode", "cibaExpiresIn", "cibaInterval", "cibaAuthRequestedUserHint").forEach(i -> rep2.getAttributes().remove(i));
        }
        Set attributesKeys = rep2.getAttributes().keySet();
        int expectedAttributesCount = 3;
        HashSet expectedAttributes = Sets.newHashSet((Object[])new String[]{OAuth2DeviceConfig.OAUTH2_DEVICE_CODE_LIFESPAN, OAuth2DeviceConfig.OAUTH2_DEVICE_POLLING_INTERVAL, "parRequestUriLifespan"});
        expectedAttributes.add("realmReusableOtpCode");
        MatcherAssert.assertThat((Object)attributesKeys.size(), (Matcher)CoreMatchers.is((Object)(++expectedAttributesCount)));
        MatcherAssert.assertThat(attributesKeys, (Matcher)CoreMatchers.is((Object)expectedAttributes));
        this.adminClient.realms().realm("attributes").remove();
    }

    @Test
    public void testFieldNotErased() {
        Long dummyLong = 999L;
        Integer dummyInt = 999;
        HashMap<String, String> browserSecurityHeaders = new HashMap<String, String>(Arrays.stream(BrowserSecurityHeaders.values()).collect(Collectors.toMap(BrowserSecurityHeaders::getKey, headerValue -> headerValue.getDefaultValue().isBlank() ? "non-null-to-test" : headerValue.getDefaultValue())));
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("attributes");
        rep.setDisplayName("DISPLAY_NAME");
        rep.setDisplayNameHtml("DISPLAY_NAME_HTML");
        rep.setDefaultSignatureAlgorithm("RS256");
        rep.setBruteForceProtected(Boolean.valueOf(true));
        rep.setPermanentLockout(Boolean.valueOf(true));
        rep.setMaxFailureWaitSeconds(dummyInt);
        rep.setWaitIncrementSeconds(dummyInt);
        rep.setQuickLoginCheckMilliSeconds(dummyLong);
        rep.setMinimumQuickLoginWaitSeconds(dummyInt);
        rep.setMaxDeltaTimeSeconds(dummyInt);
        rep.setFailureFactor(dummyInt);
        rep.setActionTokenGeneratedByAdminLifespan(dummyInt);
        rep.setActionTokenGeneratedByUserLifespan(dummyInt);
        rep.setOfflineSessionMaxLifespanEnabled(Boolean.valueOf(true));
        rep.setOfflineSessionMaxLifespan(dummyInt);
        rep.setBrowserSecurityHeaders(browserSecurityHeaders);
        rep.setWebAuthnPolicyRpEntityName("RP_ENTITY_NAME");
        rep.setWebAuthnPolicySignatureAlgorithms(Collections.singletonList("RS256"));
        rep.setWebAuthnPolicyRpId("localhost");
        rep.setWebAuthnPolicyAttestationConveyancePreference("Direct");
        rep.setWebAuthnPolicyAuthenticatorAttachment("Platform");
        rep.setWebAuthnPolicyRequireResidentKey("Yes");
        rep.setWebAuthnPolicyUserVerificationRequirement("Required");
        rep.setWebAuthnPolicyCreateTimeout(dummyInt);
        rep.setWebAuthnPolicyAvoidSameAuthenticatorRegister(Boolean.valueOf(true));
        rep.setWebAuthnPolicyAcceptableAaguids(Collections.singletonList("00000000-0000-0000-0000-000000000000"));
        rep.setWebAuthnPolicyPasswordlessRpEntityName("RP_ENTITY_NAME");
        rep.setWebAuthnPolicyPasswordlessSignatureAlgorithms(Collections.singletonList("RS256"));
        rep.setWebAuthnPolicyPasswordlessRpId("localhost");
        rep.setWebAuthnPolicyPasswordlessAttestationConveyancePreference("Direct");
        rep.setWebAuthnPolicyPasswordlessAuthenticatorAttachment("Platform");
        rep.setWebAuthnPolicyPasswordlessRequireResidentKey("Yes");
        rep.setWebAuthnPolicyPasswordlessUserVerificationRequirement("Required");
        rep.setWebAuthnPolicyPasswordlessCreateTimeout(dummyInt);
        rep.setWebAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister(Boolean.valueOf(true));
        rep.setWebAuthnPolicyPasswordlessAcceptableAaguids(Collections.singletonList("00000000-0000-0000-0000-000000000000"));
        this.adminClient.realms().create(rep);
        RealmRepresentation rep2 = new RealmRepresentation();
        rep2.setAttributes(Collections.singletonMap("frontendUrl", "http://localhost/frontEnd"));
        this.adminClient.realm("attributes").update(rep2);
        rep = this.adminClient.realm("attributes").toRepresentation();
        Assertions.assertEquals((Object)"DISPLAY_NAME", (Object)rep.getDisplayName());
        Assertions.assertEquals((Object)"DISPLAY_NAME_HTML", (Object)rep.getDisplayNameHtml());
        Assertions.assertEquals((Object)"RS256", (Object)rep.getDefaultSignatureAlgorithm());
        Assertions.assertTrue((boolean)rep.isBruteForceProtected());
        Assertions.assertTrue((boolean)rep.isPermanentLockout());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getMaxFailureWaitSeconds());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getWaitIncrementSeconds());
        Assertions.assertEquals((Long)dummyLong, (Long)rep.getQuickLoginCheckMilliSeconds());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getMinimumQuickLoginWaitSeconds());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getMaxDeltaTimeSeconds());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getFailureFactor());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getActionTokenGeneratedByAdminLifespan());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getActionTokenGeneratedByUserLifespan());
        Assertions.assertTrue((boolean)rep.getOfflineSessionMaxLifespanEnabled());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getOfflineSessionMaxLifespan());
        Assertions.assertEquals((Object)"RP_ENTITY_NAME", (Object)rep.getWebAuthnPolicyRpEntityName());
        Assertions.assertEquals(Collections.singletonList("RS256"), (Object)rep.getWebAuthnPolicySignatureAlgorithms());
        Assertions.assertEquals((Object)"localhost", (Object)rep.getWebAuthnPolicyRpId());
        Assertions.assertEquals((Object)"Direct", (Object)rep.getWebAuthnPolicyAttestationConveyancePreference());
        Assertions.assertEquals((Object)"Platform", (Object)rep.getWebAuthnPolicyAuthenticatorAttachment());
        Assertions.assertEquals((Object)"Yes", (Object)rep.getWebAuthnPolicyRequireResidentKey());
        Assertions.assertEquals((Object)"Required", (Object)rep.getWebAuthnPolicyUserVerificationRequirement());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getWebAuthnPolicyCreateTimeout());
        Assertions.assertTrue((boolean)rep.isWebAuthnPolicyAvoidSameAuthenticatorRegister());
        Assertions.assertEquals(Collections.singletonList("00000000-0000-0000-0000-000000000000"), (Object)rep.getWebAuthnPolicyAcceptableAaguids());
        Assertions.assertEquals((Object)"RP_ENTITY_NAME", (Object)rep.getWebAuthnPolicyPasswordlessRpEntityName());
        Assertions.assertEquals(Collections.singletonList("RS256"), (Object)rep.getWebAuthnPolicyPasswordlessSignatureAlgorithms());
        Assertions.assertEquals((Object)"localhost", (Object)rep.getWebAuthnPolicyPasswordlessRpId());
        Assertions.assertEquals((Object)"Direct", (Object)rep.getWebAuthnPolicyPasswordlessAttestationConveyancePreference());
        Assertions.assertEquals((Object)"Platform", (Object)rep.getWebAuthnPolicyPasswordlessAuthenticatorAttachment());
        Assertions.assertEquals((Object)"Yes", (Object)rep.getWebAuthnPolicyPasswordlessRequireResidentKey());
        Assertions.assertEquals((Object)"Required", (Object)rep.getWebAuthnPolicyPasswordlessUserVerificationRequirement());
        Assertions.assertEquals((Integer)dummyInt, (Integer)rep.getWebAuthnPolicyPasswordlessCreateTimeout());
        Assertions.assertTrue((boolean)rep.isWebAuthnPolicyPasswordlessAvoidSameAuthenticatorRegister());
        Assertions.assertEquals(Collections.singletonList("00000000-0000-0000-0000-000000000000"), (Object)rep.getWebAuthnPolicyPasswordlessAcceptableAaguids());
        Assertions.assertEquals(browserSecurityHeaders, (Object)rep.getBrowserSecurityHeaders());
        this.adminClient.realms().realm("attributes").remove();
    }

    @Test
    public void updateRealmAttributes() {
        RealmRepresentation rep = new RealmRepresentation();
        ArrayList<String> webAuthnPolicyAcceptableAaguids = new ArrayList<String>();
        webAuthnPolicyAcceptableAaguids.add("aaguid1");
        webAuthnPolicyAcceptableAaguids.add("aaguid2");
        rep.setAttributes(new HashMap());
        rep.getAttributes().put("foo1", "bar1");
        rep.getAttributes().put("foo2", "bar2");
        rep.setWebAuthnPolicyRpEntityName("keycloak");
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        rep.setBruteForceProtected(Boolean.valueOf(true));
        rep.setDisplayName("dn1");
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)"bar1", rep.getAttributes().get("foo1"));
        Assertions.assertEquals((Object)"bar2", rep.getAttributes().get("foo2"));
        Assertions.assertTrue((boolean)rep.isBruteForceProtected());
        Assertions.assertEquals((Object)"dn1", (Object)rep.getDisplayName());
        Assertions.assertEquals(webAuthnPolicyAcceptableAaguids, (Object)rep.getWebAuthnPolicyAcceptableAaguids());
        webAuthnPolicyAcceptableAaguids.clear();
        rep.setBruteForceProtected(Boolean.valueOf(false));
        rep.setDisplayName("dn2");
        rep.getAttributes().put("foo1", "bar11");
        rep.getAttributes().remove("foo2");
        rep.setWebAuthnPolicyAcceptableAaguids(webAuthnPolicyAcceptableAaguids);
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertFalse((boolean)rep.isBruteForceProtected());
        Assertions.assertEquals((Object)"dn2", (Object)rep.getDisplayName());
        Assertions.assertEquals((Object)"bar11", rep.getAttributes().get("foo1"));
        Assertions.assertFalse((boolean)rep.getAttributes().containsKey("foo2"));
        Assertions.assertTrue((boolean)rep.getWebAuthnPolicyAcceptableAaguids().isEmpty());
    }

    @Test
    public void testSetEmptyAttributeValues() {
        String realmName = "testSetEmptyAttributeValues";
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(realmName);
        rep.setAttributes(new HashMap());
        rep.getAttributes().put("myboolean", "");
        rep.getAttributes().put("mylong", "");
        rep.getAttributes().put("myint", "");
        rep.getAttributes().put("actionTokenGeneratedByUserLifespan.something", "");
        this.adminClient.realms().create(rep);
        try {
            this.adminClient.realm(realmName);
            this.runOnServer.run((RunOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName(realmName);
                Assertions.assertInstanceOf(RealmAdapter.class, (Object)realm);
                Assertions.assertNull(realm.getUserActionTokenLifespans().get("something"));
                Assertions.assertEquals((Object)true, (Object)realm.getAttribute("myboolean", Boolean.valueOf(true)));
                Assertions.assertEquals((Long)realm.getAttribute("mylong", Long.valueOf(123L)), (Long)123L);
                Assertions.assertEquals((Integer)realm.getAttribute("myint", Integer.valueOf(1234)), (Integer)1234);
                RealmProvider delegate = ((CacheRealmProvider)session.getProvider(CacheRealmProvider.class)).getRealmDelegate();
                RealmModel realm2 = delegate.getRealm(realm.getId());
                Assertions.assertInstanceOf(org.keycloak.models.jpa.RealmAdapter.class, (Object)realm2);
                Assertions.assertNull(realm2.getUserActionTokenLifespans().get("something"));
                Assertions.assertEquals((Object)true, (Object)realm2.getAttribute("myboolean", Boolean.valueOf(true)));
                Assertions.assertEquals((Long)realm2.getAttribute("mylong", Long.valueOf(123L)), (Long)123L);
                Assertions.assertEquals((Integer)realm2.getAttribute("myint", Integer.valueOf(1234)), (Integer)1234);
            });
        }
        finally {
            this.adminClient.realm(realmName).remove();
        }
    }
}

