/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import org.infinispan.Cache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.providers.runonserver.FetchOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class RealmCacheTest
extends AbstractRealmTest {
    @InjectRealm(ref="master", attachTo="master")
    ManagedRealm masterRealm;
    @InjectRunOnServer(ref="master", realmRef="master")
    RunOnServerClient masterRunOnServer;

    @Test
    public void clearRealmCache() {
        String realmId = this.managedRealm.getId();
        Assertions.assertTrue((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)s -> {
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)s.getProvider(InfinispanConnectionProvider.class);
            Cache cache = provider.getCache("realms");
            return cache.containsKey((Object)realmId);
        }, Boolean.class)));
        this.managedRealm.admin().clearRealmCache();
        Assertions.assertFalse((boolean)((Boolean)this.masterRunOnServer.fetch((FetchOnServer & Serializable)s -> {
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)s.getProvider(InfinispanConnectionProvider.class);
            Cache cache = provider.getCache("realms");
            return cache.containsKey((Object)realmId);
        }, Boolean.class)));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)"clear-realm-cache", (ResourceType)ResourceType.REALM);
    }

    @Test
    public void clearUserCache() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("clearcacheuser");
        Response response = this.managedRealm.admin().users().create(user);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userId), (Object)user, (ResourceType)ResourceType.USER);
        this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertTrue((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)s -> {
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)s.getProvider(InfinispanConnectionProvider.class);
            Cache cache = provider.getCache("users");
            return cache.containsKey((Object)userId);
        }, Boolean.class)));
        this.managedRealm.admin().clearUserCache();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)"clear-user-cache", (ResourceType)ResourceType.REALM);
        Assertions.assertFalse((boolean)((Boolean)this.runOnServer.fetch((FetchOnServer & Serializable)s -> {
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)s.getProvider(InfinispanConnectionProvider.class);
            Cache cache = provider.getCache("users");
            return cache.containsKey((Object)userId);
        }, Boolean.class)));
    }
}

