/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class RealmCreateTest
extends AbstractRealmTest {
    @Test
    public void getRealms() {
        List realms = this.adminClient.realms().findAll();
        Assert.assertNames((List)realms, (String[])new String[]{"master", this.managedRealm.getName()});
    }

    @Test
    public void getRealmRepresentation() {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)this.managedRealm.getName(), (Object)rep.getRealm());
        Assertions.assertTrue((boolean)rep.isEnabled());
    }

    @Test
    public void createRealmEmpty() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        Assert.assertNames((List)this.adminClient.realms().findAll(), (String[])new String[]{"master", this.managedRealm.getName(), "new-realm"});
        List clients = this.adminClient.realms().realm("new-realm").clients().findAll().stream().map(ClientRepresentation::getClientId).collect(Collectors.toList());
        MatcherAssert.assertThat(clients, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"account", "account-console", "admin-cli", "broker", "realm-management", "security-admin-console"}));
        this.adminClient.realms().realm("new-realm").remove();
        Assert.assertNames((List)this.adminClient.realms().findAll(), (String[])new String[]{"master", this.managedRealm.getName()});
    }

    @Test
    public void createRealmWithValidConsoleUris() throws Exception {
        String realmNameWithSpaces = "new realm";
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(realmNameWithSpaces);
        rep.setEnabled(Boolean.TRUE);
        rep.setUsers(Collections.singletonList(UserConfigBuilder.create().username("new-realm-admin").name("new-realm-admin", "new-realm-admin").email("new-realm-admin@keycloak.org").emailVerified(true).password("password").clientRoles("realm-management", new String[]{"realm-admin"}).build()));
        this.adminClient.realms().create(rep);
        Assert.assertNames((List)this.adminClient.realms().findAll(), (String[])new String[]{"master", this.managedRealm.getName(), realmNameWithSpaces});
        ImmutableSet urlPlaceHolders = ImmutableSet.of((Object)"${authBaseUrl}", (Object)"${authAdminUrl}");
        RealmResource newRealm = this.adminClient.realms().realm(realmNameWithSpaces);
        List clientUris = newRealm.clients().findAll().stream().flatMap(client -> Stream.concat(Stream.concat(Stream.concat(client.getRedirectUris().stream(), Stream.of(client.getBaseUrl())), Stream.of(client.getRootUrl())), Stream.of(client.getAdminUrl()))).filter(Objects::nonNull).filter(uri -> !urlPlaceHolders.contains(uri)).collect(Collectors.toList());
        MatcherAssert.assertThat(clientUris, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(clientUris, (Matcher)Matchers.everyItem((Matcher)Matchers.containsString((String)"/new%20realm/")));
        try (Keycloak client2 = this.adminClientFactory.create().realm(realmNameWithSpaces).username("new-realm-admin").password("password").clientId("admin-cli").build();){
            Assertions.assertNotNull((Object)client2.serverInfo().getInfo());
        }
        this.adminClient.realms().realm(realmNameWithSpaces).remove();
        Assert.assertNames((List)this.adminClient.realms().findAll(), (String[])new String[]{"master", this.managedRealm.getName()});
    }

    @Test
    public void createRealmRejectReservedCharOrEmptyName() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-re;alm");
        Assertions.assertThrows(BadRequestException.class, () -> this.adminClient.realms().create(rep));
        rep.setRealm("");
        Assertions.assertThrows(BadRequestException.class, () -> this.adminClient.realms().create(rep));
        rep.setRealm("new-realm");
        rep.setId("invalid;id");
        Assertions.assertThrows(BadRequestException.class, () -> this.adminClient.realms().create(rep));
    }

    @Test
    public void createRealmCheckDefaultPasswordPolicy() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        Assertions.assertNull((Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
        rep.setPasswordPolicy("length(8)");
        this.adminClient.realms().create(rep);
        Assertions.assertEquals((Object)"length(8)", (Object)this.adminClient.realm("new-realm").toRepresentation().getPasswordPolicy());
        this.adminClient.realms().realm("new-realm").remove();
    }

    @Test
    public void createRealmFromJson() throws IOException {
        RealmRepresentation rep = (RealmRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("testrealm.json"), RealmRepresentation.class);
        this.adminClient.realms().create(rep);
        RealmRepresentation created = this.adminClient.realms().realm("admin-test-1").toRepresentation();
        this.assertRealm(rep, created);
        this.adminClient.realms().realm("admin-test-1").remove();
    }

    @Test
    public void createRealmWithPasswordPolicyFromJsonWithInvalidPasswords() throws IOException {
        RealmRepresentation rep = (RealmRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("testrealm-keycloak-6146-error.json"), RealmRepresentation.class);
        try {
            this.adminClient.realms().create(rep);
        }
        catch (BadRequestException ex) {
            Assertions.assertThrows(NotFoundException.class, () -> this.adminClient.realms().realm("secure-app").toRepresentation());
        }
    }

    @Test
    public void createRealmWithPasswordPolicyFromJsonWithValidPasswords() throws IOException {
        RealmRepresentation rep = (RealmRepresentation)JsonSerialization.readValue((InputStream)RealmCreateTest.class.getResourceAsStream("testrealm-keycloak-6146.json"), RealmRepresentation.class);
        this.adminClient.realms().create(rep);
        this.assertRealm(rep, this.adminClient.realm(rep.getRealm()).toRepresentation());
        this.adminClient.realms().realm(rep.getRealm()).remove();
    }

    private void assertRealm(RealmRepresentation realm, RealmRepresentation storedRealm) {
        if (realm.getRealm() != null) {
            Assertions.assertEquals((Object)realm.getRealm(), (Object)storedRealm.getRealm());
        }
        if (realm.isEnabled() != null) {
            Assertions.assertEquals((Object)realm.isEnabled(), (Object)storedRealm.isEnabled());
        }
        if (realm.isBruteForceProtected() != null) {
            Assertions.assertEquals((Object)realm.isBruteForceProtected(), (Object)storedRealm.isBruteForceProtected());
        }
        if (realm.getMaxFailureWaitSeconds() != null) {
            Assertions.assertEquals((Integer)realm.getMaxFailureWaitSeconds(), (Integer)storedRealm.getMaxFailureWaitSeconds());
        }
        if (realm.getMinimumQuickLoginWaitSeconds() != null) {
            Assertions.assertEquals((Integer)realm.getMinimumQuickLoginWaitSeconds(), (Integer)storedRealm.getMinimumQuickLoginWaitSeconds());
        }
        if (realm.getWaitIncrementSeconds() != null) {
            Assertions.assertEquals((Integer)realm.getWaitIncrementSeconds(), (Integer)storedRealm.getWaitIncrementSeconds());
        }
        if (realm.getQuickLoginCheckMilliSeconds() != null) {
            Assertions.assertEquals((Long)realm.getQuickLoginCheckMilliSeconds(), (Long)storedRealm.getQuickLoginCheckMilliSeconds());
        }
        if (realm.getMaxDeltaTimeSeconds() != null) {
            Assertions.assertEquals((Integer)realm.getMaxDeltaTimeSeconds(), (Integer)storedRealm.getMaxDeltaTimeSeconds());
        }
        if (realm.getFailureFactor() != null) {
            Assertions.assertEquals((Integer)realm.getFailureFactor(), (Integer)storedRealm.getFailureFactor());
        }
        if (realm.isRegistrationAllowed() != null) {
            Assertions.assertEquals((Object)realm.isRegistrationAllowed(), (Object)storedRealm.isRegistrationAllowed());
        }
        if (realm.isRegistrationEmailAsUsername() != null) {
            Assertions.assertEquals((Object)realm.isRegistrationEmailAsUsername(), (Object)storedRealm.isRegistrationEmailAsUsername());
        }
        if (realm.isRememberMe() != null) {
            Assertions.assertEquals((Object)realm.isRememberMe(), (Object)storedRealm.isRememberMe());
        }
        if (realm.isVerifyEmail() != null) {
            Assertions.assertEquals((Object)realm.isVerifyEmail(), (Object)storedRealm.isVerifyEmail());
        }
        if (realm.isLoginWithEmailAllowed() != null) {
            Assertions.assertEquals((Object)realm.isLoginWithEmailAllowed(), (Object)storedRealm.isLoginWithEmailAllowed());
        }
        if (realm.isDuplicateEmailsAllowed() != null) {
            Assertions.assertEquals((Object)realm.isDuplicateEmailsAllowed(), (Object)storedRealm.isDuplicateEmailsAllowed());
        }
        if (realm.isResetPasswordAllowed() != null) {
            Assertions.assertEquals((Object)realm.isResetPasswordAllowed(), (Object)storedRealm.isResetPasswordAllowed());
        }
        if (realm.isEditUsernameAllowed() != null) {
            Assertions.assertEquals((Object)realm.isEditUsernameAllowed(), (Object)storedRealm.isEditUsernameAllowed());
        }
        if (realm.getSslRequired() != null) {
            Assertions.assertEquals((Object)realm.getSslRequired(), (Object)storedRealm.getSslRequired());
        }
        if (realm.getAccessCodeLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getAccessCodeLifespan(), (Integer)storedRealm.getAccessCodeLifespan());
        }
        if (realm.getAccessCodeLifespanUserAction() != null) {
            Assertions.assertEquals((Integer)realm.getAccessCodeLifespanUserAction(), (Integer)storedRealm.getAccessCodeLifespanUserAction());
        }
        if (realm.getActionTokenGeneratedByAdminLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getActionTokenGeneratedByAdminLifespan(), (Integer)storedRealm.getActionTokenGeneratedByAdminLifespan());
        }
        if (realm.getActionTokenGeneratedByUserLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getActionTokenGeneratedByUserLifespan(), (Integer)storedRealm.getActionTokenGeneratedByUserLifespan());
        } else {
            Assertions.assertEquals((Integer)realm.getAccessCodeLifespanUserAction(), (Integer)storedRealm.getActionTokenGeneratedByUserLifespan());
        }
        if (realm.getNotBefore() != null) {
            Assertions.assertEquals((Integer)realm.getNotBefore(), (Integer)storedRealm.getNotBefore());
        }
        if (realm.getAccessTokenLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getAccessTokenLifespan(), (Integer)storedRealm.getAccessTokenLifespan());
        }
        if (realm.getAccessTokenLifespanForImplicitFlow() != null) {
            Assertions.assertEquals((Integer)realm.getAccessTokenLifespanForImplicitFlow(), (Integer)storedRealm.getAccessTokenLifespanForImplicitFlow());
        }
        if (realm.getSsoSessionIdleTimeout() != null) {
            Assertions.assertEquals((Integer)realm.getSsoSessionIdleTimeout(), (Integer)storedRealm.getSsoSessionIdleTimeout());
        }
        if (realm.getSsoSessionMaxLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getSsoSessionMaxLifespan(), (Integer)storedRealm.getSsoSessionMaxLifespan());
        }
        if (realm.getSsoSessionIdleTimeoutRememberMe() != null) {
            Assert.assertEquals((Integer)realm.getSsoSessionIdleTimeoutRememberMe(), (Integer)storedRealm.getSsoSessionIdleTimeoutRememberMe());
        }
        if (realm.getSsoSessionMaxLifespanRememberMe() != null) {
            Assert.assertEquals((Integer)realm.getSsoSessionMaxLifespanRememberMe(), (Integer)storedRealm.getSsoSessionMaxLifespanRememberMe());
        }
        if (realm.getClientSessionIdleTimeout() != null) {
            Assertions.assertEquals((Integer)realm.getClientSessionIdleTimeout(), (Integer)storedRealm.getClientSessionIdleTimeout());
        }
        if (realm.getClientSessionMaxLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getClientSessionMaxLifespan(), (Integer)storedRealm.getClientSessionMaxLifespan());
        }
        if (realm.getClientOfflineSessionIdleTimeout() != null) {
            Assertions.assertEquals((Integer)realm.getClientOfflineSessionIdleTimeout(), (Integer)storedRealm.getClientOfflineSessionIdleTimeout());
        }
        if (realm.getClientOfflineSessionMaxLifespan() != null) {
            Assertions.assertEquals((Integer)realm.getClientOfflineSessionMaxLifespan(), (Integer)storedRealm.getClientOfflineSessionMaxLifespan());
        }
        if (realm.getRequiredCredentials() != null) {
            Assertions.assertNotNull((Object)storedRealm.getRequiredCredentials());
            for (String cred : realm.getRequiredCredentials()) {
                Assertions.assertTrue((boolean)storedRealm.getRequiredCredentials().contains(cred));
            }
        }
        if (realm.getLoginTheme() != null) {
            Assertions.assertEquals((Object)realm.getLoginTheme(), (Object)storedRealm.getLoginTheme());
        }
        if (realm.getAccountTheme() != null) {
            Assertions.assertEquals((Object)realm.getAccountTheme(), (Object)storedRealm.getAccountTheme());
        }
        if (realm.getAdminTheme() != null) {
            Assertions.assertEquals((Object)realm.getAdminTheme(), (Object)storedRealm.getAdminTheme());
        }
        if (realm.getEmailTheme() != null) {
            Assertions.assertEquals((Object)realm.getEmailTheme(), (Object)storedRealm.getEmailTheme());
        }
        if (realm.getPasswordPolicy() != null) {
            Assertions.assertEquals((Object)realm.getPasswordPolicy(), (Object)storedRealm.getPasswordPolicy());
        }
        if (realm.getSmtpServer() != null) {
            Assertions.assertEquals((Object)realm.getSmtpServer(), (Object)storedRealm.getSmtpServer());
        }
        if (realm.getBrowserSecurityHeaders() != null) {
            Assertions.assertEquals((Object)realm.getBrowserSecurityHeaders(), (Object)storedRealm.getBrowserSecurityHeaders());
        }
        if (realm.getAttributes() != null) {
            HashMap attributes = new HashMap();
            attributes.putAll(storedRealm.getAttributes());
            attributes.entrySet().retainAll(realm.getAttributes().entrySet());
            Assertions.assertEquals((Object)realm.getAttributes(), attributes);
        }
        if (realm.isUserManagedAccessAllowed() != null) {
            Assertions.assertEquals((Object)realm.isUserManagedAccessAllowed(), (Object)storedRealm.isUserManagedAccessAllowed());
        }
    }
}

