/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.Strings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.runonserver.RunHelpers;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class RealmDefaultConfigTest
extends AbstractRealmTest {
    @InjectRealm(ref="realm-with-smtp")
    ManagedRealm smtpRealm;
    @InjectRunOnServer(ref="smtp", realmRef="realm-with-smtp")
    RunOnServerClient smtpRealmRunOnServer;
    @InjectAdminEvents(ref="smtpEvents", realmRef="realm-with-smtp")
    AdminEvents smtpRealmAdminEvents;

    @Test
    public void smtpPasswordSecret() {
        this.smtpRealm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.smtp("localhost", 3025, "smtp_realm@local")});
        RealmRepresentation rep = this.smtpRealm.admin().toRepresentation();
        rep.getSmtpServer().put("auth", "true");
        rep.getSmtpServer().put("user", "user");
        rep.getSmtpServer().put("password", "secret");
        this.smtpRealm.admin().update(rep);
        this.smtpRealmAdminEvents.clear();
        RealmRepresentation returned = this.smtpRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)"**********", returned.getSmtpServer().get("password"));
        RealmRepresentation internalRep = (RealmRepresentation)this.smtpRealmRunOnServer.fetch(RunHelpers.internalRealm());
        Assertions.assertEquals((Object)"secret", internalRep.getSmtpServer().get("password"));
        this.smtpRealm.admin().update(rep);
        AdminEventRepresentation event = (AdminEventRepresentation)this.smtpRealmAdminEvents.poll();
        Assertions.assertFalse((boolean)event.getRepresentation().contains("some secret value!!"));
        Assertions.assertTrue((boolean)event.getRepresentation().contains("**********"));
        internalRep = (RealmRepresentation)this.smtpRealmRunOnServer.fetch(RunHelpers.internalRealm());
        Assertions.assertEquals((Object)"secret", internalRep.getSmtpServer().get("password"));
        RealmRepresentation realm = this.adminClient.realms().findAll().stream().filter(r -> r.getRealm().equals("realm-with-smtp")).findFirst().get();
        Assertions.assertEquals((Object)"**********", realm.getSmtpServer().get("password"));
        rep.getSmtpServer().put("password", "**********");
        this.smtpRealm.admin().update(rep);
        event = (AdminEventRepresentation)this.smtpRealmAdminEvents.poll();
        Assertions.assertTrue((boolean)event.getRepresentation().contains("**********"));
        internalRep = (RealmRepresentation)this.smtpRealmRunOnServer.fetch(RunHelpers.internalRealm());
        Assertions.assertEquals((Object)"secret", internalRep.getSmtpServer().get("password"));
        realm = this.smtpRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)"**********", realm.getSmtpServer().get("password"));
    }

    @Test
    public void deleteDefaultRole() {
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.managedRealm.admin().roles().create(role);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)"test"), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        role = this.managedRealm.admin().roles().get("test").toRepresentation();
        Assertions.assertNotNull((Object)role);
        this.managedRealm.admin().roles().get("default-roles-" + Strings.toLowerCase((String)this.managedRealm.getName())).addComposites(Collections.singletonList(role));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourceCompositesPath((String)("default-roles-" + Strings.toLowerCase((String)this.managedRealm.getName()))), Collections.singletonList(role), (ResourceType)ResourceType.REALM_ROLE);
        this.managedRealm.admin().roles().deleteRole("test");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleResourcePath((String)"test"), (ResourceType)ResourceType.REALM_ROLE);
        try {
            this.managedRealm.admin().roles().get("testsadfsadf").toRepresentation();
            Assertions.fail((String)"Expected NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void convertKeycloakClientDescription() throws IOException {
        ClientRepresentation description = new ClientRepresentation();
        description.setClientId("client-id");
        description.setRedirectUris(Collections.singletonList("http://localhost"));
        ClientRepresentation converted = this.managedRealm.admin().convertClientDescription(JsonSerialization.writeValueAsString((Object)description));
        Assertions.assertEquals((Object)"client-id", (Object)converted.getClientId());
        Assertions.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertOIDCClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)RealmDefaultConfigTest.class.getResourceAsStream("client-oidc.json"), (Charset)Charset.defaultCharset());
        ClientRepresentation converted = this.managedRealm.admin().convertClientDescription(description);
        Assertions.assertEquals((int)1, (int)converted.getRedirectUris().size());
        Assertions.assertEquals((Object)"http://localhost", converted.getRedirectUris().get(0));
    }

    @Test
    public void convertSAMLClientDescription() throws IOException {
        String description = IOUtils.toString((InputStream)RealmDefaultConfigTest.class.getResourceAsStream("saml-entity-descriptor.xml"), (Charset)Charset.defaultCharset());
        ClientRepresentation converted = this.managedRealm.admin().convertClientDescription(description);
        Assertions.assertEquals((Object)"loadbalancer-9.siroe.com", (Object)converted.getClientId());
        Assertions.assertEquals((int)2, (int)converted.getRedirectUris().size());
        Assertions.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", converted.getRedirectUris().get(0));
        Assertions.assertEquals((Object)"https://LoadBalancer-9.siroe.com:3443/federation/Consumer/metaAlias/sp", converted.getRedirectUris().get(1));
    }

    @Test
    public void testDefaultSignatureAlgorithm() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        Assertions.assertEquals((Object)"RS256", (Object)this.adminClient.realm("master").toRepresentation().getDefaultSignatureAlgorithm());
        Assertions.assertEquals((Object)"RS256", (Object)this.adminClient.realm("new-realm").toRepresentation().getDefaultSignatureAlgorithm());
        this.adminClient.realms().realm("new-realm").remove();
    }

    @Test
    public void testSupportedOTPApplications() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm("new-realm");
        this.adminClient.realms().create(rep);
        RealmResource realm = this.adminClient.realms().realm("new-realm");
        rep = realm.toRepresentation();
        List supportedApplications = rep.getOtpSupportedApplications();
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"totpAppGoogleName", "totpAppFreeOTPName", "totpAppMicrosoftAuthenticatorName"}));
        rep.setOtpPolicyDigits(Integer.valueOf(8));
        realm.update(rep);
        rep = realm.toRepresentation();
        supportedApplications = rep.getOtpSupportedApplications();
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"totpAppFreeOTPName", "totpAppGoogleName"}));
        rep.setOtpPolicyType("hotp");
        realm.update(rep);
        rep = realm.toRepresentation();
        supportedApplications = rep.getOtpSupportedApplications();
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)supportedApplications, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"totpAppFreeOTPName", "totpAppGoogleName"}));
        this.adminClient.realms().realm("new-realm").remove();
    }
}

