/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectEvents;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.Events;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.TestApp;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectTestApp;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

@KeycloakIntegrationTest
public class RealmOAuthActionsTest
extends AbstractRealmTest {
    @InjectOAuthClient(ref="managedOAuth", realmRef="managedRealm")
    OAuthClient oauth;
    @InjectTestApp
    TestApp testApp;
    @InjectEvents(ref="managedEvents", realmRef="managedRealm")
    Events events;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;

    @Test
    public void pushNotBefore() throws InterruptedException {
        this.setupTestAppAndUser();
        int time = Time.currentTime() - 60;
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        rep.setNotBefore(Integer.valueOf(time));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
        GlobalRequestResult globalRequestResult = this.managedRealm.admin().pushRevocation();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)"push-revocation", (Object)globalRequestResult, (ResourceType)ResourceType.REALM);
        MatcherAssert.assertThat((Object)globalRequestResult.getSuccessRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.testApp.getAdminUri()}));
        Assertions.assertNull((Object)globalRequestResult.getFailedRequests());
        PushNotBeforeAction adminPushNotBefore = this.testApp.kcAdmin().getAdminPushNotBefore();
        Assertions.assertEquals((int)time, (int)adminPushNotBefore.getNotBefore());
        this.managedRealm.admin().clients().get("test-app-new").remove();
        this.managedRealm.admin().users().get(ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)"testuser").getId()).remove();
    }

    @Test
    public void pushNotBeforeWithSamlApp() throws InterruptedException {
        this.setupTestAppAndUser();
        this.setupTestSamlApp();
        int time = Time.currentTime() - 60;
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        rep.setNotBefore(Integer.valueOf(time));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
        GlobalRequestResult globalRequestResult = this.managedRealm.admin().pushRevocation();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)"push-revocation", (Object)globalRequestResult, (ResourceType)ResourceType.REALM);
        MatcherAssert.assertThat((Object)globalRequestResult.getSuccessRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.testApp.getAdminUri()}));
        MatcherAssert.assertThat((Object)globalRequestResult.getFailedRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{this.keycloakUrls.getBase() + "/realms/" + this.managedRealm.getName() + "/saml-app/saml"}));
        PushNotBeforeAction adminPushNotBefore = this.testApp.kcAdmin().getAdminPushNotBefore();
        Assertions.assertEquals((int)time, (int)adminPushNotBefore.getNotBefore());
        this.managedRealm.admin().clients().get("test-saml-app").remove();
        this.managedRealm.admin().clients().get("test-app-new").remove();
        this.managedRealm.admin().users().get(ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)"testuser").getId()).remove();
    }

    @Test
    public void logoutAll() throws InterruptedException {
        this.setupTestAppAndUser();
        Response response = this.managedRealm.admin().users().create(UserConfigBuilder.create().username("user").name("User", "Name").email("user@name").emailVerified(true).build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userId), (ResourceType)ResourceType.USER);
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        this.managedRealm.admin().users().get(userId).resetPassword(credential);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)AdminEventPaths.userResetPasswordPath((String)userId), (ResourceType)ResourceType.USER);
        this.oauth.doPasswordGrantRequest("user", "password");
        GlobalRequestResult globalRequestResult = this.managedRealm.admin().logoutAll();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)"logout-all", (Object)globalRequestResult, (ResourceType)ResourceType.REALM);
        Assertions.assertEquals((int)1, (int)globalRequestResult.getSuccessRequests().size());
        Assertions.assertEquals((Object)this.testApp.getAdminUri(), globalRequestResult.getSuccessRequests().get(0));
        Assertions.assertNull((Object)globalRequestResult.getFailedRequests());
        Assertions.assertNotNull((Object)this.testApp.kcAdmin().getAdminLogoutAction());
        this.managedRealm.admin().clients().get("test-app-new").remove();
        this.managedRealm.admin().users().get(ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)"testuser").getId()).remove();
    }

    @Test
    public void deleteSession() {
        this.setupTestAppAndUser();
        this.oauth.doLogin("testuser", "password");
        AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(this.oauth.parseLoginResponse().getCode());
        Assertions.assertEquals((int)200, (int)tokenResponse.getStatusCode());
        EventRepresentation event = (EventRepresentation)this.events.poll();
        Assertions.assertNotNull((Object)event);
        this.managedRealm.admin().deleteSession(event.getSessionId(), false);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.deleteSessionPath((String)event.getSessionId()), (ResourceType)ResourceType.USER_SESSION);
        try {
            this.managedRealm.admin().deleteSession(event.getSessionId(), false);
            Assertions.fail((String)"Expected 404");
        }
        catch (NotFoundException e) {
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        tokenResponse = this.oauth.doRefreshTokenRequest(tokenResponse.getRefreshToken());
        Assertions.assertEquals((int)400, (int)tokenResponse.getStatusCode());
        Assertions.assertEquals((Object)"Session not active", (Object)tokenResponse.getErrorDescription());
        this.managedRealm.admin().clients().get("test-app-new").remove();
        this.managedRealm.admin().users().get(ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)"testuser").getId()).remove();
    }

    @Test
    public void clientSessionStats() {
        this.setupTestAppAndUser();
        List sessionStats = this.managedRealm.admin().getClientSessionStats();
        Assertions.assertTrue((boolean)sessionStats.isEmpty());
        this.oauth.doLogin("testuser", "password");
        AccessTokenResponse tokenResponse = this.oauth.doAccessTokenRequest(this.oauth.parseLoginResponse().getCode());
        Assertions.assertEquals((int)200, (int)tokenResponse.getStatusCode());
        sessionStats = this.managedRealm.admin().getClientSessionStats();
        Assertions.assertEquals((int)1, (int)sessionStats.size());
        Assertions.assertEquals((Object)"test-app-new", ((Map)sessionStats.get(0)).get("clientId"));
        Assertions.assertEquals((Object)"1", ((Map)sessionStats.get(0)).get("active"));
        String clientUuid = (String)((Map)sessionStats.get(0)).get("id");
        this.managedRealm.admin().clients().get(clientUuid).remove();
        sessionStats = this.managedRealm.admin().getClientSessionStats();
        Assertions.assertEquals((int)0, (int)sessionStats.size());
        this.managedRealm.admin().users().get(ApiUtil.findUserByUsername((RealmResource)this.managedRealm.admin(), (String)"testuser").getId()).remove();
    }

    private void setupTestAppAndUser() {
        this.testApp.kcAdmin().clear();
        ClientRepresentation client = ClientConfigBuilder.create().id("test-app-new").clientId("test-app-new").protocol("openid-connect").adminUrl(this.testApp.getAdminUri()).redirectUris(new String[]{this.testApp.getRedirectionUri()}).secret("secret").build();
        Response resp = this.managedRealm.admin().clients().create(client);
        String clientDbId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        client.setSecret("**********");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)clientDbId), (Object)client, (ResourceType)ResourceType.CLIENT);
        this.oauth.client("test-app-new", "secret");
        UserRepresentation userRep = UserConfigBuilder.create().username("testuser").name("Test", "User").email("test@user").emailVerified(true).build();
        Response response = this.managedRealm.admin().users().create(userRep);
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)userId), (Object)userRep, (ResourceType)ResourceType.USER);
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        this.managedRealm.admin().users().get(userId).resetPassword(credential);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)AdminEventPaths.userResetPasswordPath((String)userId), (ResourceType)ResourceType.USER);
        this.testApp.kcAdmin().clear();
    }

    private void setupTestSamlApp() {
        ClientRepresentation client = ClientConfigBuilder.create().id("test-saml-app").clientId("test-saml-app").protocol("saml").adminUrl(this.keycloakUrls.getBase() + "/realms/" + this.managedRealm.getName() + "/saml-app/saml").redirectUris(new String[]{this.oauth.getRedirectUri()}).secret("secret").build();
        Response resp = this.managedRealm.admin().clients().create(client);
        String clientDbId = ApiUtil.getCreatedId((Response)resp);
        resp.close();
        client.setSecret("**********");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)clientDbId), (Object)client, (ResourceType)ResourceType.CLIENT);
    }
}

