/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.BadRequestException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.tests.utils.Assert;

@KeycloakIntegrationTest
public class RealmRemoveTest
extends AbstractRealmTest {
    @Test
    public void removeRealm() {
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        this.adminClient.realm(this.managedRealm.getName()).remove();
        Assert.assertNames((List)this.adminClient.realms().findAll(), (String[])new String[]{"master"});
        this.adminClient.realms().create(realmRep);
    }

    @Test
    public void removeMasterRealm() {
        try {
            this.adminClient.realm("master").remove();
            Assertions.fail((String)"It should not be possible to remove the master realm");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
    }

    @Test
    public void loginAfterRemoveRealm() {
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        this.adminClient.realm(this.managedRealm.getName()).remove();
        try (Keycloak client = this.adminClientFactory.create().realm("master").username("admin").password("admin").clientId("admin-cli").build();){
            client.serverInfo().getInfo();
        }
        this.adminClient.realms().create(realmRep);
    }
}

