/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.tests.admin.realm.AbstractRealmRolesTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class RealmRolesCRUDTest
extends AbstractRealmRolesTest {
    @InjectClient(ref="client-a", attachTo="client-a")
    ManagedClient clientA;

    @Test
    public void getRole() {
        RoleRepresentation role = this.managedRealm.admin().roles().get("role-a").toRepresentation();
        Assertions.assertNotNull((Object)role);
        Assertions.assertEquals((Object)"role-a", (Object)role.getName());
        Assertions.assertEquals((Object)"Role A", (Object)role.getDescription());
        Assertions.assertEquals(Map.of("role-a-attr-key1", List.of("role-a-attr-val1")), (Object)role.getAttributes());
        Assertions.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void createRoleWithSameName() {
        Assertions.assertThrows(ClientErrorException.class, () -> this.managedRealm.admin().roles().create(RoleConfigBuilder.create().name("role-a").build()));
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.managedRealm.admin().roles().get("role-a").toRepresentation();
        role.setName("role-a-new");
        role.setDescription("Role A New");
        Map<String, List<String>> newAttributes = Collections.singletonMap("attrKeyNew", Collections.singletonList("attrValueNew"));
        role.setAttributes(newAttributes);
        this.managedRealm.admin().roles().get("role-a").update(role);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.roleResourcePath((String)"role-a"), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        role = this.managedRealm.admin().roles().get("role-a-new").toRepresentation();
        Assertions.assertNotNull((Object)role);
        Assertions.assertEquals((Object)"role-a-new", (Object)role.getName());
        Assertions.assertEquals((Object)"Role A New", (Object)role.getDescription());
        Assertions.assertEquals(newAttributes, (Object)role.getAttributes());
        Assertions.assertFalse((boolean)role.isComposite());
        this.managedRealm.cleanup().add(r -> r.roles().create(RoleConfigBuilder.create().name("role-a").description("Role A").attributes(Map.of("role-a-attr-key1", List.of("role-a-attr-val1"))).build()));
        this.managedRealm.cleanup().add(r -> r.roles().get("role-a-new").remove());
    }

    @Test
    public void deleteRole() {
        Assertions.assertNotNull((Object)this.managedRealm.admin().roles().get("role-a"));
        this.managedRealm.admin().roles().deleteRole("role-a");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleResourcePath((String)"role-a"), (ResourceType)ResourceType.REALM_ROLE);
        try {
            this.managedRealm.admin().roles().get("role-a").toRepresentation();
            Assertions.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        Assertions.assertFalse((boolean)this.managedRealm.admin().roles().get("role-a").toRepresentation().isComposite());
        Assertions.assertEquals((int)0, (int)this.managedRealm.admin().roles().get("role-a").getRoleComposites().size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleConfigBuilder.create().id(this.managedRealm.admin().roles().get("role-b").toRepresentation().getId()).build());
        l.add(RoleConfigBuilder.create().id(this.managedRealm.admin().clients().get(this.clientA.getId()).roles().get("role-c").toRepresentation().getId()).build());
        this.managedRealm.admin().roles().get("role-a").addComposites(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourceCompositesPath((String)"role-a"), l, (ResourceType)ResourceType.REALM_ROLE);
        Set composites = this.managedRealm.admin().roles().get("role-a").getRoleComposites();
        Assertions.assertTrue((boolean)this.managedRealm.admin().roles().get("role-a").toRepresentation().isComposite());
        Assert.assertNames((Set)composites, (String[])new String[]{"role-b", "role-c"});
        Set realmComposites = this.managedRealm.admin().roles().get("role-a").getRealmRoleComposites();
        Assert.assertNames((Set)realmComposites, (String[])new String[]{"role-b"});
        Set clientComposites = this.managedRealm.admin().roles().get("role-a").getClientRoleComposites(this.clientA.getId());
        Assert.assertNames((Set)clientComposites, (String[])new String[]{"role-c"});
        this.managedRealm.admin().roles().get("role-a").deleteComposites(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.roleResourceCompositesPath((String)"role-a"), l, (ResourceType)ResourceType.REALM_ROLE);
        Assertions.assertFalse((boolean)this.managedRealm.admin().roles().get("role-a").toRepresentation().isComposite());
        Assertions.assertEquals((int)0, (int)this.managedRealm.admin().roles().get("role-a").getRoleComposites().size());
    }

    @Test
    public void testDefaultRoles() {
        RoleResource defaultRole = this.managedRealm.admin().roles().get("default-roles-" + this.managedRealm.getName());
        UserRepresentation user = (UserRepresentation)this.managedRealm.admin().users().search("test-role-member").get(0);
        UserResource userResource = this.managedRealm.admin().users().get(user.getId());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listAll()), (Matcher)Matchers.hasItem((Object)("default-roles-" + this.managedRealm.getName())));
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listEffective()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)("default-roles-" + this.managedRealm.getName())), (Matcher)Matchers.hasItem((Object)"offline_access"), (Matcher)Matchers.hasItem((Object)"uma_authorization")));
        defaultRole.addComposites(Collections.singletonList(this.managedRealm.admin().roles().get("role-a").toRepresentation()));
        userResource = this.managedRealm.admin().users().get(user.getId());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listAll()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)("default-roles-" + this.managedRealm.getName())), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"role-a"))));
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().realmLevel().listEffective()), (Matcher)Matchers.allOf((Matcher)Matchers.hasItem((Object)("default-roles-" + this.managedRealm.getName())), (Matcher)Matchers.hasItem((Object)"offline_access"), (Matcher)Matchers.hasItem((Object)"uma_authorization"), (Matcher)Matchers.hasItem((Object)"role-a")));
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientA.getId()).listAll(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientA.getId()).listEffective(), (Matcher)Matchers.empty());
        defaultRole.addComposites(Collections.singletonList(this.managedRealm.admin().clients().get(this.clientA.getId()).roles().get("role-c").toRepresentation()));
        userResource = this.managedRealm.admin().users().get(user.getId());
        MatcherAssert.assertThat((Object)userResource.roles().clientLevel(this.clientA.getId()).listAll(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(this.convertRolesToNames(userResource.roles().clientLevel(this.clientA.getId()).listEffective()), (Matcher)Matchers.hasItem((Object)"role-c"));
    }

    @Test
    public void testDeleteDefaultRole() {
        Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().roles().deleteRole("default-roles-" + this.managedRealm.getName()));
    }

    private List<String> convertRolesToNames(List<RoleRepresentation> roles) {
        return roles.stream().map(RoleRepresentation::getName).collect(Collectors.toList());
    }
}

