/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.realm.AbstractRealmRolesTest;

@KeycloakIntegrationTest
public class RealmRolesGroupTest
extends AbstractRealmRolesTest {
    @Test
    public void testGroupsInRole() {
        RoleResource role = this.managedRealm.admin().roles().get("role-with-users");
        List groups = this.managedRealm.admin().groups().groups();
        GroupRepresentation groupRep = groups.stream().filter(g -> g.getPath().equals("/test-role-group")).findFirst().get();
        RoleResource roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.managedRealm.admin().groups().group(groupRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        Set groupsInRole = roleResource.getRoleGroupMembers();
        Assertions.assertTrue((boolean)groupsInRole.stream().anyMatch(g -> g.getPath().equals("/test-role-group")));
    }

    @Test
    public void testGroupsNotInRole() {
        RoleResource role = this.managedRealm.admin().roles().get("role-without-users");
        role = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        Set groupsInRole = role.getRoleGroupMembers();
        Assertions.assertTrue((boolean)groupsInRole.isEmpty());
    }
}

