/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.realm.AbstractRealmRolesTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class RealmRolesSearchTest
extends AbstractRealmRolesTest {
    @Test
    public void testSearchForRealmRoles() {
        this.managedRealm.admin().roles().list("role-", true).forEach(role -> MatcherAssert.assertThat((String)("There is client role '" + role.getName() + "' among realm roles."), (Object)role.getClientRole(), (Matcher)Matchers.is((Object)false)));
    }

    @Test
    public void testSearchForRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "testrole" + i;
            RoleRepresentation role = RealmRolesSearchTest.makeRole(roleName);
            this.managedRealm.admin().roles().create(role);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        }
        String roleNameA = "abcdefg";
        RoleRepresentation roleA = RealmRolesSearchTest.makeRole(roleNameA);
        this.managedRealm.admin().roles().create(roleA);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleNameA), (Object)roleA, (ResourceType)ResourceType.REALM_ROLE);
        String roleNameB = "defghij";
        RoleRepresentation roleB = RealmRolesSearchTest.makeRole(roleNameB);
        this.managedRealm.admin().roles().create(roleB);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleNameB), (Object)roleB, (ResourceType)ResourceType.REALM_ROLE);
        List resultSearch = this.managedRealm.admin().roles().list("defg", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)2, (int)resultSearch.size());
        List resultSearch2 = this.managedRealm.admin().roles().list("testrole", Integer.valueOf(-1), Integer.valueOf(-1));
        Assertions.assertEquals((int)15, (int)resultSearch2.size());
        List resultSearchPagination = this.managedRealm.admin().roles().list("testrole", Integer.valueOf(1), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination.size());
    }

    @Test
    public void testPaginationRoles() {
        for (int i = 0; i < 15; ++i) {
            String roleName = "role" + i;
            RoleRepresentation role = RealmRolesSearchTest.makeRole(roleName);
            this.managedRealm.admin().roles().create(role);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        }
        List resultSearchPagination = this.managedRealm.admin().roles().list(Integer.valueOf(1), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination.size());
        List resultSearchPagination2 = this.managedRealm.admin().roles().list(Integer.valueOf(5), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination2.size());
        List resultSearchPagination3 = this.managedRealm.admin().roles().list(Integer.valueOf(1), Integer.valueOf(5));
        Assertions.assertEquals((int)5, (int)resultSearchPagination3.size());
        List resultSearchPaginationIncoherentParams = this.managedRealm.admin().roles().list(Integer.valueOf(1), null);
        Assertions.assertTrue((resultSearchPaginationIncoherentParams.size() > 15 ? 1 : 0) != 0);
    }

    @Test
    public void testPaginationRolesCache() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "paginaterole" + i;
            RoleRepresentation role = RealmRolesSearchTest.makeRole(roleName);
            this.managedRealm.admin().roles().create(role);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        }
        List resultBeforeAddingRoleToTestCache = this.managedRealm.admin().roles().list(Integer.valueOf(1), Integer.valueOf(1000));
        RoleRepresentation role = RealmRolesSearchTest.makeRole("anewrole");
        this.managedRealm.admin().roles().create(role);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)"anewrole"), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        List resultafterAddingRoleToTestCache = this.managedRealm.admin().roles().list(Integer.valueOf(1), Integer.valueOf(1000));
        Assertions.assertEquals((int)(resultBeforeAddingRoleToTestCache.size() + 1), (int)resultafterAddingRoleToTestCache.size());
    }

    @Test
    public void getRolesWithFullRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrole" + i;
            RoleRepresentation role = RealmRolesSearchTest.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.managedRealm.admin().roles().create(role);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        }
        List roles = this.managedRealm.admin().roles().list("attributesrole", false);
        Assertions.assertTrue((boolean)((RoleRepresentation)roles.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void getRolesWithBriefRepresentation() {
        for (int i = 0; i < 5; ++i) {
            String roleName = "attributesrolebrief" + i;
            RoleRepresentation role = RealmRolesSearchTest.makeRole(roleName);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("attribute1", Arrays.asList("value1", "value2"));
            role.setAttributes(attributes);
            this.managedRealm.admin().roles().create(role);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.roleResourcePath((String)roleName), (Object)role, (ResourceType)ResourceType.REALM_ROLE);
        }
        List roles = this.managedRealm.admin().roles().list("attributesrolebrief", true);
        Assertions.assertNull((Object)((RoleRepresentation)roles.get(0)).getAttributes());
    }

    private static RoleRepresentation makeRole(String name) {
        RoleRepresentation role = new RoleRepresentation();
        role.setName(name);
        return role;
    }
}

