/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.realm.AbstractRealmRolesTest;

@KeycloakIntegrationTest
public class RealmRolesUserTest
extends AbstractRealmRolesTest {
    @Test
    public void testUsersInRole() {
        RoleResource role = this.managedRealm.admin().roles().get("role-with-users");
        List users = this.managedRealm.admin().users().search("test-role-member");
        Assertions.assertEquals((int)1, (int)users.size());
        UserResource user = this.managedRealm.admin().users().get(((UserRepresentation)users.get(0)).getId());
        UserRepresentation userRep = user.toRepresentation();
        RoleResource roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.managedRealm.admin().users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        Assertions.assertEquals(Collections.singletonList("test-role-member"), RealmRolesUserTest.extractUsernames(roleResource.getUserMembers()));
    }

    @Test
    public void testUsersNotInRole() {
        RoleResource role = this.managedRealm.admin().roles().get("role-without-users");
        role = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        MatcherAssert.assertThat((Object)role.getUserMembers(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void roleMembershipAfterUserRemoval() {
        RoleResource role = this.managedRealm.admin().roles().get("role-with-users");
        List users = this.managedRealm.admin().users().search("test-role-member", null, null, null, null, null);
        Assertions.assertEquals((int)1, (int)users.size());
        UserResource user = this.managedRealm.admin().users().get(((UserRepresentation)users.get(0)).getId());
        UserRepresentation userRep = user.toRepresentation();
        RoleResource roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
        rolesToAdd.add(roleResource.toRepresentation());
        this.managedRealm.admin().users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        Assertions.assertEquals(Collections.singletonList("test-role-member"), RealmRolesUserTest.extractUsernames(roleResource.getUserMembers()));
        this.managedRealm.admin().users().delete(userRep.getId());
        MatcherAssert.assertThat((Object)roleResource.getUserMembers(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        this.managedRealm.cleanup().add(r -> r.users().create(UserConfigBuilder.create().username("test-role-member").name("Test", "Role User").email("test-role-member@test-role-member.com").roles(new String[]{"default-roles-default"}).emailVerified(true).requiredActions(new String[0]).build()));
    }

    @Test
    public void testRoleMembershipWithPagination() {
        RoleResource role = this.managedRealm.admin().roles().get("role-with-users");
        UserRepresentation userRep2 = new UserRepresentation();
        userRep2.setUsername("test-role-member2");
        userRep2.setEmail("test-role-member2@test-role-member.com");
        userRep2.setRequiredActions(Collections.emptyList());
        userRep2.setEnabled(Boolean.valueOf(true));
        this.managedRealm.admin().users().create(userRep2);
        List users = this.managedRealm.admin().users().search("test-role-member", null, null, null, null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)IsCollectionWithSize.hasSize((int)2));
        for (UserRepresentation userRepFromList : users) {
            UserResource user = this.managedRealm.admin().users().get(userRepFromList.getId());
            UserRepresentation userRep = user.toRepresentation();
            RoleResource roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
            LinkedList<RoleRepresentation> rolesToAdd = new LinkedList<RoleRepresentation>();
            rolesToAdd.add(roleResource.toRepresentation());
            this.managedRealm.admin().users().get(userRep.getId()).roles().realmLevel().add(rolesToAdd);
        }
        RoleResource roleResource = this.managedRealm.admin().roles().get(role.toRepresentation().getName());
        List roleUserMembers = roleResource.getUserMembers(Integer.valueOf(0), Integer.valueOf(1));
        Assertions.assertEquals(Collections.singletonList("test-role-member"), RealmRolesUserTest.extractUsernames(roleUserMembers));
        Assertions.assertNotNull((Object)((UserRepresentation)roleUserMembers.get(0)).getNotBefore(), (String)"Not in full representation");
        roleUserMembers = roleResource.getUserMembers(Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)roleUserMembers, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assertions.assertEquals(Collections.singletonList("test-role-member2"), RealmRolesUserTest.extractUsernames(roleUserMembers));
        Assertions.assertNull((Object)((UserRepresentation)roleUserMembers.get(0)).getNotBefore(), (String)"Not in brief representation");
        roleUserMembers = roleResource.getUserMembers(Boolean.valueOf(true), Integer.valueOf(2), Integer.valueOf(1));
        MatcherAssert.assertThat((Object)roleUserMembers, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private static List<String> extractUsernames(Collection<UserRepresentation> users) {
        return users.stream().map(AbstractUserRepresentation::getUsername).collect(Collectors.toList());
    }
}

