/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.realm;

import jakarta.ws.rs.BadRequestException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.realm.AbstractRealmTest;
import org.keycloak.userprofile.UserProfileProvider;

@KeycloakIntegrationTest
public class RealmUpdateTest
extends AbstractRealmTest {
    @Test
    public void renameRealmTest() {
        RealmRepresentation realm1 = new RealmRepresentation();
        realm1.setRealm("test-immutable");
        this.adminClient.realms().create(realm1);
        realm1 = this.adminClient.realms().realm("test-immutable").toRepresentation();
        realm1.setRealm("test-immutable-old");
        this.adminClient.realms().realm("test-immutable").update(realm1);
        MatcherAssert.assertThat((Object)this.adminClient.realms().realm("test-immutable-old").toRepresentation(), (Matcher)Matchers.notNullValue());
        RealmRepresentation realm2 = new RealmRepresentation();
        realm2.setRealm("test-immutable");
        this.adminClient.realms().create(realm2);
        MatcherAssert.assertThat((Object)this.adminClient.realms().realm("test-immutable").toRepresentation(), (Matcher)Matchers.notNullValue());
        this.adminClient.realms().realm("test-immutable").remove();
        this.adminClient.realms().realm("test-immutable-old").remove();
    }

    @Test
    public void renameRealm() {
        String OLD = "old";
        String NEW = "new";
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(OLD);
        rep.setRealm(OLD);
        this.adminClient.realms().create(rep);
        HashMap<String, String> newBaseUrls = new HashMap<String, String>();
        HashMap<String, List> newRedirectUris = new HashMap<String, List>();
        this.adminClient.realm(OLD).clients().findAll().forEach(client -> {
            if (client.getBaseUrl() != null && client.getBaseUrl().contains("/" + OLD + "/")) {
                newBaseUrls.put(client.getClientId(), client.getBaseUrl().replace("/" + OLD + "/", "/" + NEW + "/"));
            }
            if (client.getRedirectUris() != null) {
                newRedirectUris.put(client.getClientId(), client.getRedirectUris().stream().map(redirectUri -> redirectUri.replace("/" + OLD + "/", "/" + NEW + "/")).collect(Collectors.toList()));
            }
        });
        MatcherAssert.assertThat(newBaseUrls.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"security-admin-console", "account", "account-console"}));
        MatcherAssert.assertThat(newRedirectUris.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{"security-admin-console", "account", "account-console"}));
        rep.setRealm(NEW);
        this.adminClient.realm(OLD).update(rep);
        Assertions.assertEquals((int)0, (int)this.adminClient.realm("master").clients().findByClientId("old-realm").size());
        Assertions.assertEquals((int)1, (int)this.adminClient.realm("master").clients().findByClientId("new-realm").size());
        ClientRepresentation adminConsoleClient = (ClientRepresentation)this.adminClient.realm(NEW).clients().findByClientId("security-admin-console").get(0);
        Assertions.assertEquals((Object)"${authAdminUrl}", (Object)adminConsoleClient.getRootUrl());
        ClientRepresentation accountClient = (ClientRepresentation)this.adminClient.realm(NEW).clients().findByClientId("account").get(0);
        Assertions.assertEquals((Object)"${authBaseUrl}", (Object)accountClient.getRootUrl());
        ClientRepresentation accountConsoleClient = (ClientRepresentation)this.adminClient.realm(NEW).clients().findByClientId("account-console").get(0);
        Assertions.assertEquals((Object)"${authBaseUrl}", (Object)accountConsoleClient.getRootUrl());
        newBaseUrls.forEach((clientId, baseUrl) -> Assertions.assertEquals((Object)baseUrl, (Object)((ClientRepresentation)this.adminClient.realm(NEW).clients().findByClientId(clientId).get(0)).getBaseUrl()));
        newRedirectUris.forEach((clientId, redirectUris) -> Assertions.assertEquals((Object)redirectUris, (Object)((ClientRepresentation)this.adminClient.realm(NEW).clients().findByClientId(clientId).get(0)).getRedirectUris()));
        this.adminClient.realms().realm(NEW).remove();
    }

    @Test
    public void updateRealmEventsConfig() {
        RealmEventsConfigRepresentation rep = this.managedRealm.admin().getRealmEventsConfig();
        RealmEventsConfigRepresentation repOrig = this.copyRealmEventsConfigRepresentation(rep);
        Assertions.assertTrue((boolean)rep.getEventsListeners().contains("jboss-logging"), (String)"jboss-logging should be enabled initially");
        rep.setEnabledEventTypes(List.of(EventType.LOGIN.name(), EventType.LOGIN_ERROR.name()));
        rep.setEventsListeners(List.of("jboss-logging"));
        rep.setEventsExpiration(Long.valueOf(36000L));
        rep.setEventsEnabled(false);
        rep.setAdminEventsEnabled(Boolean.valueOf(false));
        rep.setAdminEventsDetailsEnabled(Boolean.valueOf(true));
        this.managedRealm.admin().updateRealmEventsConfig(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)"events/config", (Object)rep, (ResourceType)ResourceType.REALM);
        RealmEventsConfigRepresentation actual = this.managedRealm.admin().getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(rep, actual);
        rep.setEnabledEventTypes(Arrays.asList(EventType.LOGIN.name(), EventType.LOGIN_ERROR.name(), EventType.CLIENT_LOGIN.name()));
        this.managedRealm.admin().updateRealmEventsConfig(rep);
        Assertions.assertNull((Object)this.adminEvents.poll());
        actual = this.managedRealm.admin().getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(rep, actual);
        this.managedRealm.admin().updateRealmEventsConfig(repOrig);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)"events/config", (Object)repOrig, (ResourceType)ResourceType.REALM);
        actual = this.managedRealm.admin().getRealmEventsConfig();
        this.checkRealmEventsConfigRepresentation(repOrig, actual);
    }

    @Test
    public void updateRealmWithReservedCharInNameOrEmptyName() {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        rep.setRealm("fo#o");
        Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().update(rep));
        rep.setRealm("");
        Assertions.assertThrows(BadRequestException.class, () -> this.managedRealm.admin().update(rep));
    }

    @Test
    public void updateRealm() {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        rep.setSsoSessionIdleTimeout(Integer.valueOf(123));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(12));
        rep.setSsoSessionIdleTimeoutRememberMe(Integer.valueOf(33));
        rep.setSsoSessionMaxLifespanRememberMe(Integer.valueOf(34));
        rep.setAccessCodeLifespanLogin(Integer.valueOf(1234));
        rep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(2345));
        rep.setActionTokenGeneratedByUserLifespan(Integer.valueOf(3456));
        rep.setRegistrationAllowed(Boolean.valueOf(true));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(true));
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        rep.setUserManagedAccessAllowed(Boolean.valueOf(true));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((int)123, (int)rep.getSsoSessionIdleTimeout());
        Assertions.assertEquals((int)12, (int)rep.getSsoSessionMaxLifespan());
        Assertions.assertEquals((int)33, (int)rep.getSsoSessionIdleTimeoutRememberMe());
        Assertions.assertEquals((int)34, (int)rep.getSsoSessionMaxLifespanRememberMe());
        Assertions.assertEquals((int)1234, (int)rep.getAccessCodeLifespanLogin());
        Assertions.assertEquals((int)2345, (int)rep.getActionTokenGeneratedByAdminLifespan());
        Assertions.assertEquals((int)3456, (int)rep.getActionTokenGeneratedByUserLifespan());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationAllowed());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rep.isRegistrationEmailAsUsername());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rep.isUserManagedAccessAllowed());
        rep.setRegistrationAllowed(Boolean.valueOf(false));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(false));
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        rep.setUserManagedAccessAllowed(Boolean.valueOf(false));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationAllowed());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rep.isRegistrationEmailAsUsername());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rep.isUserManagedAccessAllowed());
        rep.setAccessCodeLifespanLogin(Integer.valueOf(0));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(0));
        try {
            this.managedRealm.admin().update(rep);
            Assertions.fail((String)"Not expected to successfully update the realm");
        }
        catch (Exception expected) {
            Assertions.assertEquals((Object)"HTTP 400 Bad Request", (Object)expected.getMessage());
        }
    }

    @Test
    public void updateRealmWithNewRepresentation() {
        RealmRepresentation rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(true));
        rep.setSupportedLocales(new HashSet<String>(Arrays.asList("en", "de")));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rep.isEditUsernameAllowed());
        Assertions.assertEquals((int)2, (int)rep.getSupportedLocales().size());
        rep = new RealmRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(false));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).resourceType(ResourceType.REALM);
        rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rep.isEditUsernameAllowed());
        Assertions.assertEquals((int)2, (int)rep.getSupportedLocales().size());
    }

    @Test
    public void testNoUserProfileProviderComponentUponRealmChange() {
        String realmName = "new-realm";
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(realmName);
        this.adminClient.realms().create(rep);
        MatcherAssert.assertThat((Object)this.adminClient.realm(realmName).components().query(null, UserProfileProvider.class.getName()), (Matcher)Matchers.empty());
        rep.setDisplayName("displayName");
        this.adminClient.realm(realmName).update(rep);
        MatcherAssert.assertThat((Object)this.adminClient.realm(realmName).components().query(null, UserProfileProvider.class.getName()), (Matcher)Matchers.empty());
        this.adminClient.realms().realm(realmName).remove();
    }

    private RealmEventsConfigRepresentation copyRealmEventsConfigRepresentation(RealmEventsConfigRepresentation rep) {
        RealmEventsConfigRepresentation recr = new RealmEventsConfigRepresentation();
        recr.setEnabledEventTypes(rep.getEnabledEventTypes());
        recr.setEventsListeners(rep.getEventsListeners());
        recr.setEventsExpiration(rep.getEventsExpiration());
        recr.setEventsEnabled(rep.isEventsEnabled());
        recr.setAdminEventsEnabled(rep.isAdminEventsEnabled());
        recr.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled());
        return recr;
    }

    private void checkRealmEventsConfigRepresentation(RealmEventsConfigRepresentation expected, RealmEventsConfigRepresentation actual) {
        Assertions.assertEquals((int)expected.getEnabledEventTypes().size(), (int)actual.getEnabledEventTypes().size());
        Assertions.assertTrue((boolean)actual.getEnabledEventTypes().containsAll(expected.getEnabledEventTypes()));
        Assertions.assertEquals((int)expected.getEventsListeners().size(), (int)actual.getEventsListeners().size());
        Assertions.assertTrue((boolean)actual.getEventsListeners().containsAll(expected.getEventsListeners()));
        Assertions.assertEquals((Long)expected.getEventsExpiration(), (Long)actual.getEventsExpiration());
        Assertions.assertEquals((Object)expected.isEventsEnabled(), (Object)actual.isEventsEnabled());
        Assertions.assertEquals((Object)expected.isAdminEventsEnabled(), (Object)actual.isAdminEventsEnabled());
        Assertions.assertEquals((Object)expected.isAdminEventsDetailsEnabled(), (Object)actual.isAdminEventsDetailsEnabled());
    }
}

