/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.tracing;

import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.keycloak.Config;
import org.keycloak.connections.httpclient.DefaultHttpClientFactory;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.quarkus.runtime.tracing.OTelHttpClientFactory;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;

@KeycloakIntegrationTest(config=ServerConfigWithTracing.class)
public class TracingTest {
    @InjectRunOnServer
    RunOnServerClient runOnServer;

    @Test
    public void defaultSettingsIsUsed() {
        this.runOnServer.run((RunOnServer & Serializable)session -> {
            ProviderFactory defaultFactory = session.getKeycloakSessionFactory().getProviderFactory(HttpClientProvider.class, "default");
            MatcherAssert.assertThat((Object)defaultFactory, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)(defaultFactory instanceof OTelHttpClientFactory), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)(defaultFactory instanceof DefaultHttpClientFactory), (Matcher)CoreMatchers.is((Object)true));
            Config.Scope defaultConfig = ((DefaultHttpClientFactory)defaultFactory).getConfig();
            MatcherAssert.assertThat((Object)defaultConfig, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)defaultConfig.get("connection-ttl-millis"), (Matcher)CoreMatchers.is((Object)"1"));
            MatcherAssert.assertThat((Object)defaultConfig.get("socket-timeout-millis"), (Matcher)CoreMatchers.is((Object)"2222"));
            ProviderFactory otelFactory = session.getKeycloakSessionFactory().getProviderFactory(HttpClientProvider.class);
            MatcherAssert.assertThat((Object)otelFactory, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)(otelFactory instanceof OTelHttpClientFactory), (Matcher)CoreMatchers.is((Object)true));
            Config.Scope otelConfig = ((OTelHttpClientFactory)otelFactory).getConfig();
            MatcherAssert.assertThat((Object)otelConfig.get("connection-ttl-millis"), (Matcher)CoreMatchers.is((Object)"1"));
            MatcherAssert.assertThat((Object)otelConfig.get("socket-timeout-millis"), (Matcher)CoreMatchers.is((Object)"2222"));
        });
    }

    public static class ServerConfigWithTracing
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("tracing-enabled", "true").option("spi-connections-http-client-default-connection-ttl-millis", "1").option("spi-connections-http-client-default-socket-timeout-millis", "2222").option("spi-connections-http-client-opentelemetry-connection-ttl-millis", "2").option("spi-connections-http-client-opentelemetry-socket-timeout-millis", "3333");
        }
    }
}

