/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.credential.CredentialModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.testframework.annotations.InjectAdminClient;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.tests.utils.runonserver.RunHelpers;
import org.keycloak.testsuite.util.userprofile.UserProfileUtil;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.WebDriver;

public class AbstractUserTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminClient
    Keycloak adminClient;
    @InjectAdminEvents
    AdminEvents adminEvents;
    @InjectWebDriver
    WebDriver driver;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectPage
    LoginPage loginPage;
    protected Set<String> managedAttributes = new HashSet<String>();

    public AbstractUserTest() {
        this.managedAttributes.add("test");
        this.managedAttributes.add("attr");
        this.managedAttributes.add("attr1");
        this.managedAttributes.add("attr2");
        this.managedAttributes.add("attr3");
        this.managedAttributes.add("foo");
        this.managedAttributes.add("bar");
        this.managedAttributes.add("phoneNumber");
        this.managedAttributes.add("usercertificate");
        this.managedAttributes.add("saml.persistent.name.id.for.foo");
        this.managedAttributes.add("LDAP_ID");
        this.managedAttributes.add("LDap_Id");
        this.managedAttributes.add("deniedSomeAdmin");
        for (int i = 1; i < 10; ++i) {
            this.managedAttributes.add("test" + i);
        }
    }

    @BeforeEach
    public void beforeUserTest() throws IOException {
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), null);
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        for (String name : this.managedAttributes) {
            upConfig.addOrReplaceAttribute(this.createAttributeMetadata(name));
        }
        UserProfileUtil.setUserProfileConfiguration((RealmResource)this.managedRealm.admin(), (String)JsonSerialization.writeValueAsString((Object)upConfig));
        this.adminEvents.clear();
    }

    @AfterEach
    public void after() {
        this.managedRealm.admin().identityProviders().findAll().forEach(ip -> this.managedRealm.admin().identityProviders().get(ip.getAlias()).remove());
        this.managedRealm.admin().groups().groups().forEach(g -> this.managedRealm.admin().groups().group(g.getId()).remove());
    }

    protected String createUser() {
        return this.createUser("user1", "user1@localhost");
    }

    protected String createUser(String username, String email) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(email);
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        return this.createUser(user);
    }

    protected String createUser(UserRepresentation userRep) {
        return this.createUser(userRep, true);
    }

    protected String createUser(UserRepresentation userRep, boolean assertAdminEvent) {
        String createdId;
        try (Response response = this.managedRealm.admin().users().create(userRep);){
            createdId = ApiUtil.getCreatedId((Response)response);
        }
        this.managedRealm.cleanup().add(r -> r.users().get(createdId).remove());
        StripSecretsUtils.stripSecrets(null, (Object)userRep);
        if (assertAdminEvent) {
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userResourcePath((String)createdId), (Object)userRep, (ResourceType)ResourceType.USER);
        }
        return createdId;
    }

    protected void updateUser(UserResource user, UserRepresentation userRep) {
        user.update(userRep);
        List credentials = userRep.getCredentials();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.userResourcePath((String)userRep.getId()), (Object)StripSecretsUtils.stripSecrets(null, (Object)userRep), (ResourceType)ResourceType.USER);
        userRep.setCredentials(credentials);
    }

    protected UPAttribute createAttributeMetadata(String name) {
        UPAttribute attribute = new UPAttribute();
        attribute.setName(name);
        attribute.setMultivalued(true);
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(Set.of("user", "admin"));
        attribute.setPermissions(permissions);
        this.managedAttributes.add(name);
        return attribute;
    }

    protected CredentialModel fetchCredentials(String username) {
        return (CredentialModel)this.runOnServer.fetch(RunHelpers.fetchCredentials((String)username));
    }

    protected List<String> createUsers() {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 1; i < 10; ++i) {
            UserRepresentation user = new UserRepresentation();
            user.setUsername("username" + i);
            user.setEmail("user" + i + "@localhost");
            user.setFirstName("First" + i);
            user.setLastName("Last" + i);
            this.addAttribute(user, "test", Collections.singletonList("test" + i));
            this.addAttribute(user, "test" + i, Collections.singletonList("test" + i));
            this.addAttribute(user, "attr", Arrays.asList("common", "common2"));
            ids.add(this.createUser(user));
        }
        return ids;
    }

    private void addAttribute(UserRepresentation user, String name, List<String> values) {
        Map attributes = Optional.ofNullable(user.getAttributes()).orElse(new HashMap());
        attributes.put(name, values);
        this.managedAttributes.add(name);
        user.setAttributes(attributes);
    }

    protected void deleteUser(String id) {
        try (Response response = this.managedRealm.admin().users().delete(id);){
            Assertions.assertEquals((int)204, (int)response.getStatus());
        }
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.userResourcePath((String)id), (ResourceType)ResourceType.USER);
    }

    protected void addFederatedIdentity(String keycloakUserId, String identityProviderAlias1, FederatedIdentityRepresentation link) {
        Response response1 = this.managedRealm.admin().users().get(keycloakUserId).addFederatedIdentity(identityProviderAlias1, link);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userFederatedIdentityLink((String)keycloakUserId, (String)identityProviderAlias1), (Object)link, (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)204, (int)response1.getStatus());
    }

    protected void addSampleIdentityProvider() {
        this.addSampleIdentityProvider("social-provider-id", 0);
    }

    protected void addSampleIdentityProvider(String alias, int expectedInitialIdpCount) {
        List providers = this.managedRealm.admin().identityProviders().findAll();
        Assertions.assertEquals((int)expectedInitialIdpCount, (int)providers.size());
        IdentityProviderRepresentation rep = new IdentityProviderRepresentation();
        rep.setAlias(alias);
        rep.setProviderId("oidc");
        this.managedRealm.admin().identityProviders().create(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.identityProviderPath((String)rep.getAlias()), (Object)rep, (ResourceType)ResourceType.IDENTITY_PROVIDER);
    }

    protected String mapToSearchQuery(Map<String, String> search) {
        return search.entrySet().stream().map(e -> String.format("%s:%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
    }

    protected void switchEditUsernameAllowedOn(boolean enable) {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        this.managedRealm.cleanup().add(r -> r.update(rep));
        rep.setEditUsernameAllowed(Boolean.valueOf(enable));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
    }

    protected void switchRegistrationEmailAsUsername(boolean enable) {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        this.managedRealm.cleanup().add(r -> r.update(rep));
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(enable));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
    }

    protected static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

