/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;

@KeycloakIntegrationTest(config=UserAttributesServerConfig.class)
public class UserAttributesTest
extends AbstractUserTest {
    @Test
    public void countByAttribute() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("test1", "test2");
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, null, null, null, null, this.mapToSearchQuery(attributes)), (Matcher)Matchers.is((Object)0));
        attributes = new HashMap();
        attributes.put("test", "test1");
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, null, null, null, null, this.mapToSearchQuery(attributes)), (Matcher)Matchers.is((Object)1));
        attributes = new HashMap();
        attributes.put("test", "test2");
        attributes.put("attr", "common");
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, null, null, null, null, this.mapToSearchQuery(attributes)), (Matcher)Matchers.is((Object)1));
        attributes = new HashMap();
        attributes.put("attr", "common");
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, null, null, null, null, this.mapToSearchQuery(attributes)), (Matcher)Matchers.is((Object)9));
        attributes = new HashMap();
        attributes.put("attr", "common");
        attributes.put("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString());
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, null, null, null, null, this.mapToSearchQuery(attributes)), (Matcher)Matchers.is((Object)9));
    }

    @Test
    public void attributes() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUser(user1);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("user2");
        user2.singleAttribute("attr1", "value1user2");
        List vals = new ArrayList<String>();
        vals.add("value2user2");
        vals.add("value2user2_2");
        user2.getAttributes().put("attr2", vals);
        String user2Id = this.createUser(user2);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((int)2, (int)user1.getAttributes().size());
        this.assertAttributeValue("value1user1", (List)user1.getAttributes().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        user2 = this.managedRealm.admin().users().get(user2Id).toRepresentation();
        Assertions.assertEquals((int)2, (int)user2.getAttributes().size());
        this.assertAttributeValue("value1user2", (List)user2.getAttributes().get("attr1"));
        vals = (List)user2.getAttributes().get("attr2");
        Assertions.assertEquals((int)2, (int)vals.size());
        Assertions.assertTrue((vals.contains("value2user2") && vals.contains("value2user2_2") ? 1 : 0) != 0);
        user1.singleAttribute("attr1", "value3user1");
        user1.singleAttribute("attr3", "value4user1");
        this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((int)3, (int)user1.getAttributes().size());
        this.assertAttributeValue("value3user1", (List)user1.getAttributes().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributes().get("attr3"));
        user1.getAttributes().remove("attr1");
        this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((int)2, (int)user1.getAttributes().size());
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributes().get("attr3"));
        user1.setAttributes(null);
        this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertNotNull((Object)user1.getAttributes());
        Assertions.assertEquals((int)2, (int)user1.getAttributes().size());
        user1.setAttributes(Collections.emptyMap());
        this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertNull((Object)user1.getAttributes());
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("foo", List.of("foo"));
        attributes.put("bar", List.of("bar"));
        user1.setAttributes(attributes);
        this.managedRealm.admin().users().get(user1Id).update(user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((int)2, (int)user1.getAttributes().size());
        user1.getAttributes().remove("foo");
        this.managedRealm.admin().users().get(user1Id).update(user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((int)1, (int)user1.getAttributes().size());
    }

    @Test
    public void updateUserWithReadOnlyAttributes() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("usercertificate", "foo1");
        String user1Id = this.createUser(user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        try {
            user1.singleAttribute("usercertificate", "foo");
            user1.singleAttribute("saml.persistent.name.id.for.foo", "bar");
            user1.singleAttribute("LDAP_ID", "baz");
            this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
            Assertions.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException expected) {
            Assertions.assertNull((Object)this.adminEvents.poll());
            ErrorRepresentation error = (ErrorRepresentation)expected.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"updateReadOnlyAttributesRejectedMessage", (Object)error.getErrorMessage());
        }
        try {
            user1.getAttributes().remove("LDAP_ID");
            user1.singleAttribute("LDap_Id", "baz");
            this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
            Assertions.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException bre) {
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        try {
            user1.getAttributes().remove("LDap_Id");
            user1.singleAttribute("deniedSomeAdmin", "baz");
            this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
            Assertions.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException bre) {
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        user1.getAttributes().remove("deniedSomeAdmin");
        this.updateUser(this.managedRealm.admin().users().get(user1Id), user1);
        user1 = this.managedRealm.admin().users().get(user1Id).toRepresentation();
        Assertions.assertEquals((Object)"foo", ((List)user1.getAttributes().get("usercertificate")).get(0));
        Assertions.assertEquals((Object)"bar", ((List)user1.getAttributes().get("saml.persistent.name.id.for.foo")).get(0));
        Assertions.assertFalse((boolean)user1.getAttributes().containsKey("LDAP_ID"));
    }

    @Test
    public void testImportUserWithNullAttribute() {
        RealmRepresentation rep = UserAttributesTest.loadJson(UserAttributesTest.class.getResourceAsStream("testrealm-user-null-attr.json"), RealmRepresentation.class);
        this.adminClient.realms().create(rep);
        List users = this.adminClient.realms().realm("test-user-null-attr").users().list();
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((UserRepresentation)users.get(0)).getAttributes().size(), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    public void testKeepRootAttributeWhenOtherAttributesAreSet() {
        String random = UUID.randomUUID().toString();
        String userName = String.format("username-%s", random);
        String email = String.format("my@mail-%s.com", random);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(userName);
        user.setEmail(email);
        String userId = this.createUser(user);
        UserRepresentation created = this.managedRealm.admin().users().get(userId).toRepresentation();
        MatcherAssert.assertThat((Object)created.getEmail(), (Matcher)Matchers.equalTo((Object)email));
        MatcherAssert.assertThat((Object)created.getUsername(), (Matcher)Matchers.equalTo((Object)userName));
        MatcherAssert.assertThat((Object)created.getAttributes(), (Matcher)Matchers.nullValue());
        UserRepresentation update = new UserRepresentation();
        update.setId(userId);
        update.setEmail(email);
        update.setAttributes(Map.of("phoneNumber", List.of("123")));
        this.updateUser(this.managedRealm.admin().users().get(userId), update);
        UserRepresentation updated = this.managedRealm.admin().users().get(userId).toRepresentation();
        MatcherAssert.assertThat((Object)updated.getUsername(), (Matcher)Matchers.equalTo((Object)userName));
        MatcherAssert.assertThat((Object)((List)updated.getAttributes().get("phoneNumber")), (Matcher)Matchers.equalTo(List.of("123")));
        MatcherAssert.assertThat((Object)updated.getEmail(), (Matcher)Matchers.equalTo((Object)email));
    }

    private void assertAttributeValue(String expectedValue, List<String> attrValues) {
        Assertions.assertEquals((int)1, (int)attrValues.size());
        Assertions.assertEquals((Object)expectedValue, (Object)attrValues.get(0));
    }

    public static class UserAttributesServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            builder.option("spi-user-profile-declarative-user-profile-admin-read-only-attributes", "deniedSomeAdmin");
            return builder;
        }
    }
}

