/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.CreatedResponseUtil;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialModel;
import org.keycloak.crypto.hash.Argon2Parameters;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testframework.admin.AdminClientFactory;
import org.keycloak.testframework.annotations.InjectAdminClientFactory;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest(config=UserCreateServerConf.class)
public class UserCreateTest
extends AbstractUserTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectAdminClientFactory
    AdminClientFactory clientFactory;

    @Test
    public void verifyCreateUser() {
        this.createUser();
    }

    @Test
    public void createUserWithTemporaryPasswordWithAdditionalPasswordUpdateShouldRemoveUpdatePasswordRequiredAction() {
        String userId = this.createUser();
        CredentialRepresentation credTmp = new CredentialRepresentation();
        credTmp.setType("password");
        credTmp.setValue("temp");
        credTmp.setTemporary(Boolean.TRUE);
        this.managedRealm.admin().users().get(userId).resetPassword(credTmp);
        CredentialRepresentation credPerm = new CredentialRepresentation();
        credPerm.setType("password");
        credPerm.setValue("perm");
        credPerm.setTemporary(null);
        this.managedRealm.admin().users().get(userId).resetPassword(credPerm);
        UserRepresentation userRep = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertFalse((boolean)userRep.getRequiredActions().contains(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
    }

    @Test
    public void createDuplicatedUser1() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User exists with same username", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void createDuplicatedUser2() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
            try {
                CreatedResponseUtil.getCreatedId((Response)response);
                Assertions.fail((String)"Not expected getCreatedId to success");
            }
            catch (WebApplicationException wae) {
                MatcherAssert.assertThat((Object)wae.getMessage(), (Matcher)Matchers.endsWith((String)"ErrorMessage: User exists with same email"));
            }
        }
    }

    @Test
    public void createDuplicatedUsernameWithEmail() {
        this.createUser("user1@local.com", "user1@local.org");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1@local.org");
        user.setEmail("user2@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User exists with same username", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void createDuplicatedEmailWithUsername() {
        this.createUser("user1@local.com", "user1@local.org");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@local.com");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User exists with same email", (Object)error.getErrorMessage());
        }
    }

    @Test
    public void createDuplicateEmailWithExistingDuplicates() {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(true));
        this.managedRealm.admin().update(rep);
        UserRepresentation user = new UserRepresentation();
        user.setEmail("user1@localhost");
        user.setUsername("user1");
        this.createUser(user, false);
        user.setUsername("user2");
        this.createUser(user, false);
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(false));
        this.managedRealm.admin().update(rep);
        user.setUsername("user3");
        this.adminEvents.clear();
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User exists with same username or email", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createUserWithHashedCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_creds");
        user.setEmail("email@localhost");
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
        CredentialRepresentation hashedPassword = ModelToRepresentation.toRepresentation((CredentialModel)pcm);
        hashedPassword.setCreatedDate(Long.valueOf(1001L));
        hashedPassword.setUserLabel("deviceX");
        hashedPassword.setType("password");
        user.setCredentials(Arrays.asList(hashedPassword));
        this.createUser(user);
        CredentialModel credentialHashed = this.fetchCredentials("user_creds");
        PasswordCredentialModel pcmh = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credentialHashed);
        Assertions.assertNotNull((Object)credentialHashed, (String)"Expecting credential");
        Assertions.assertEquals((Object)"my-algorithm", (Object)pcmh.getPasswordCredentialData().getAlgorithm());
        Assertions.assertEquals((Long)1001L, (Long)credentialHashed.getCreatedDate());
        Assertions.assertEquals((Object)"deviceX", (Object)credentialHashed.getUserLabel());
        Assertions.assertEquals((int)22, (int)pcmh.getPasswordCredentialData().getHashIterations());
        Assertions.assertEquals((Object)"ABC", (Object)pcmh.getPasswordSecretData().getValue());
        Assertions.assertEquals((Object)"theSalt", (Object)new String(pcmh.getPasswordSecretData().getSalt()));
        Assertions.assertEquals((Object)"password", (Object)credentialHashed.getType());
    }

    @Test
    public void createUserWithDeprecatedCredentialsFormat() throws IOException {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_creds");
        user.setEmail("email@localhost");
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
        String deprecatedCredential = "{\n      \"type\" : \"password\",\n      \"hashedSaltedValue\" : \"" + pcm.getPasswordSecretData().getValue() + "\",\n      \"salt\" : \"" + Base64.encodeBytes((byte[])pcm.getPasswordSecretData().getSalt()) + "\",\n      \"hashIterations\" : " + pcm.getPasswordCredentialData().getHashIterations() + ",\n      \"algorithm\" : \"" + pcm.getPasswordCredentialData().getAlgorithm() + "\"\n    }";
        CredentialRepresentation deprecatedHashedPassword = (CredentialRepresentation)JsonSerialization.readValue((String)deprecatedCredential, CredentialRepresentation.class);
        Assertions.assertNotNull((Object)deprecatedHashedPassword.getHashedSaltedValue());
        Assertions.assertNull((Object)deprecatedHashedPassword.getCredentialData());
        deprecatedHashedPassword.setCreatedDate(Long.valueOf(1001L));
        deprecatedHashedPassword.setUserLabel("deviceX");
        deprecatedHashedPassword.setType("password");
        user.setCredentials(Arrays.asList(deprecatedHashedPassword));
        this.createUser(user, false);
        CredentialModel credentialHashed = this.fetchCredentials("user_creds");
        PasswordCredentialModel pcmh = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credentialHashed);
        Assertions.assertNotNull((Object)credentialHashed, (String)"Expecting credential");
        Assertions.assertEquals((Object)"my-algorithm", (Object)pcmh.getPasswordCredentialData().getAlgorithm());
        Assertions.assertEquals((Long)1001L, (Long)credentialHashed.getCreatedDate());
        Assertions.assertEquals((Object)"deviceX", (Object)credentialHashed.getUserLabel());
        Assertions.assertEquals((int)22, (int)pcmh.getPasswordCredentialData().getHashIterations());
        Assertions.assertEquals((Object)"ABC", (Object)pcmh.getPasswordSecretData().getValue());
        Assertions.assertEquals((Object)"theSalt", (Object)new String(pcmh.getPasswordSecretData().getSalt()));
        Assertions.assertEquals((Object)"password", (Object)credentialHashed.getType());
    }

    @Test
    public void createUserWithTemporaryCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_temppw");
        user.setEmail("email.temppw@localhost");
        CredentialRepresentation password = new CredentialRepresentation();
        password.setValue("password");
        password.setType("password");
        password.setTemporary(Boolean.valueOf(true));
        user.setCredentials(Arrays.asList(password));
        String userId = this.createUser(user);
        UserRepresentation userRep = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertEquals((int)1, (int)userRep.getRequiredActions().size());
        Assertions.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), userRep.getRequiredActions().get(0));
    }

    @Test
    public void createUserWithRawCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_rawpw");
        user.setEmail("email.raw@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Arrays.asList(rawPassword));
        this.createUser(user);
        CredentialModel credential = this.fetchCredentials("user_rawpw");
        Assertions.assertNotNull((Object)credential, (String)"Expecting credential");
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credential);
        Assertions.assertEquals((Object)"argon2", (Object)pcm.getPasswordCredentialData().getAlgorithm());
        Assertions.assertEquals((int)Argon2Parameters.DEFAULT_ITERATIONS, (int)pcm.getPasswordCredentialData().getHashIterations());
        Assertions.assertNotEquals((Object)"ABCD", (Object)pcm.getPasswordSecretData().getValue());
        Assertions.assertEquals((Object)"password", (Object)credential.getType());
    }

    @Test
    public void createDuplicatedUser3() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("User1");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createDuplicatedUser4() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("USER1");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createDuplicatedUser5() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("User1@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createDuplicatedUser6() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@LOCALHOST");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createDuplicatedUser7() {
        this.createUser("user1", "USer1@Localhost");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)409, (int)response.getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createTwoUsersWithEmptyStringEmails() {
        this.createUser("user1", "");
        this.createUser("user2", "");
    }

    @Test
    public void createUserWithFederationLink() {
        ComponentRepresentation dummyFederationProvider = new ComponentRepresentation();
        String componentId = KeycloakModelUtils.generateId();
        dummyFederationProvider.setId(componentId);
        dummyFederationProvider.setName("dummy");
        dummyFederationProvider.setProviderId("dummy");
        dummyFederationProvider.setProviderType(UserStorageProvider.class.getName());
        this.managedRealm.admin().components().add(dummyFederationProvider);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.componentPath((String)componentId), (Object)dummyFederationProvider, (ResourceType)ResourceType.COMPONENT);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setEmail("user1@localhost");
        user.setFederationLink(componentId);
        String userId = this.createUser(user);
        UserRepresentation createdUser = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertNotNull((Object)createdUser);
        Assertions.assertEquals((Object)user.getFederationLink(), (Object)createdUser.getFederationLink());
    }

    @Test
    public void createUserWithoutUsername() {
        UserRepresentation user = new UserRepresentation();
        user.setEmail("user1@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)400, (int)response.getStatus());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User name is missing", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createUserWithEmailAsUsername() {
        this.switchRegistrationEmailAsUsername(true);
        this.switchEditUsernameAllowedOn(false);
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getEmail());
        Assertions.assertEquals((Object)userRep.getEmail(), (Object)userRep.getUsername());
        this.deleteUser(id);
        this.switchRegistrationEmailAsUsername(true);
        this.switchEditUsernameAllowedOn(true);
        id = this.createUser();
        user = this.managedRealm.admin().users().get(id);
        userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getEmail());
        Assertions.assertEquals((Object)userRep.getEmail(), (Object)userRep.getUsername());
        this.deleteUser(id);
        this.switchRegistrationEmailAsUsername(false);
        this.switchEditUsernameAllowedOn(true);
        id = this.createUser();
        user = this.managedRealm.admin().users().get(id);
        userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1", (Object)userRep.getUsername());
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getEmail());
        this.deleteUser(id);
        this.switchRegistrationEmailAsUsername(false);
        this.switchEditUsernameAllowedOn(false);
        id = this.createUser();
        user = this.managedRealm.admin().users().get(id);
        userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1", (Object)userRep.getUsername());
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getEmail());
    }

    @Test
    public void createUserWithEmptyUsername() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("");
        user.setEmail("user2@localhost");
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)400, (int)response.getStatus());
            ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User name is missing", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void createUserWithInvalidPolicyPassword() {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        String passwordPolicy = rep.getPasswordPolicy();
        rep.setPasswordPolicy("length(8)");
        this.managedRealm.admin().update(rep);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user4");
        user.setEmail("user4@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Collections.singletonList(rawPassword));
        this.adminEvents.clear();
        try (Response response = this.managedRealm.admin().users().create(user);){
            Assertions.assertEquals((int)400, (int)response.getStatus());
            OAuth2ErrorRepresentation error = (OAuth2ErrorRepresentation)response.readEntity(OAuth2ErrorRepresentation.class);
            Assertions.assertEquals((Object)"invalidPasswordMinLengthMessage", (Object)error.getError());
            Assertions.assertEquals((Object)"Invalid password: minimum length 8.", (Object)error.getErrorDescription());
            rep.setPasswordPolicy(passwordPolicy);
            Assertions.assertNull((Object)this.adminEvents.poll());
            this.managedRealm.admin().update(rep);
        }
    }

    @Test
    public void createUserWithCreateTimestamp() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setEmail("user1@localhost");
        Long createdTimestamp = 1695238476L;
        user.setCreatedTimestamp(createdTimestamp);
        String userId = this.createUser(user);
        UserRepresentation createdUser = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertNotNull((Object)createdUser);
        Assertions.assertEquals((Long)user.getCreatedTimestamp(), (Long)createdUser.getCreatedTimestamp());
    }

    @Test
    public void failCreateUserUsingRegularUser() throws Exception {
        this.managedRealm.admin().users().create(UserConfigBuilder.create().username("regular-user").password("password").email("regular@local").name("Regular", "User").build());
        try (Keycloak localAdminClient = this.clientFactory.create().realm(this.managedRealm.getName()).username("regular-user").password("password").clientId("admin-cli").build();){
            UserRepresentation invalidUser = new UserRepresentation();
            invalidUser.setUsername("do-not-create-me");
            Response response = localAdminClient.realm("default").users().create(invalidUser);
            Assert.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
            invalidUser.setGroups(Collections.emptyList());
            response = localAdminClient.realm("default").users().create(invalidUser);
            Assert.assertEquals((int)Response.Status.FORBIDDEN.getStatusCode(), (int)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUserDoNotGrantRole() {
        this.managedRealm.admin().roles().create(RoleConfigBuilder.create().name("realm-role").build());
        try {
            UserRepresentation userRep = UserConfigBuilder.create().username("alice").password("password").roles(new String[]{"realm-role"}).build();
            String userId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().users().create(userRep));
            UserResource user = this.managedRealm.admin().users().get(userId);
            List realmMappings = user.roles().getAll().getRealmMappings();
            Assertions.assertFalse((boolean)realmMappings.stream().map(RoleRepresentation::getName).anyMatch("realm-role"::equals));
        }
        finally {
            this.managedRealm.admin().roles().get("realm-role").remove();
        }
    }

    @Test
    public void testDefaultCharacterValidationOnUsername() {
        List<String> invalidNames = List.of("1user\\\\", "2user\\\\%", "3user\\\\*", "4user\\\\_");
        for (String invalidName : invalidNames) {
            UserRepresentation invalidUser = UserConfigBuilder.create().username(invalidName).email("test@invalid.org").build();
            Response response = this.managedRealm.admin().users().create(invalidUser);
            Assert.assertEquals((int)400, (int)response.getStatus());
            Assert.assertEquals((Object)"error-username-invalid-character", (Object)((ErrorRepresentation)response.readEntity(ErrorRepresentation.class)).getErrorMessage());
        }
    }

    public static class UserCreateServerConf
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder builder) {
            return builder.dependency("org.keycloak.tests", "keycloak-tests-custom-providers");
        }
    }
}

