/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.AccountHelper;
import org.keycloak.util.JsonSerialization;

@KeycloakIntegrationTest
public class UserCredentialTest
extends AbstractUserTest {
    @InjectOAuthClient
    OAuthClient oauth;
    @InjectUser(ref="user-with-one-configured-otp", config=UserCredentialOtp1UserConf.class)
    ManagedUser userOtp1;
    @InjectUser(ref="user-with-two-configured-otp", config=UserCredentialOtp2UserConf.class)
    ManagedUser userOtp2;
    @InjectUser(ref="john-doh@localhost", config=UserCredentialJohnDohUserConf.class)
    ManagedUser johnDoh;
    @InjectUser(ref="test-user@localhost", config=UserCredentialTestUserConf.class)
    ManagedUser testUser;

    @Test
    public void resetUserPassword() {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@localhost").build();
        String userId = this.createUser(userRep);
        CredentialRepresentation cred = new CredentialRepresentation();
        cred.setType("password");
        cred.setValue("paSSw0rd");
        cred.setTemporary(Boolean.valueOf(false));
        this.managedRealm.admin().users().get(userId).resetPassword(cred);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)AdminEventPaths.userResetPasswordPath((String)userId), (ResourceType)ResourceType.USER);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.fillLogin("user1", "paSSw0rd");
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        AccountHelper.logout((RealmResource)this.managedRealm.admin(), (String)"user1");
    }

    @Test
    public void resetUserInvalidPassword() {
        String userId = this.createUser("user1", "user1@localhost");
        try {
            CredentialRepresentation cred = new CredentialRepresentation();
            cred.setType("password");
            cred.setValue(" ");
            cred.setTemporary(Boolean.valueOf(false));
            this.managedRealm.admin().users().get(userId).resetPassword(cred);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            e.getResponse().close();
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void loginShouldFailAfterPasswordDeleted() {
        String userName = "credential-tester";
        String userPass = "s3cr37";
        UserRepresentation userRep = UserConfigBuilder.create().username(userName).password(userPass).name("credential", "tester").email("credential@tester").build();
        String userId = this.createUser(userRep);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.fillLogin(userName, userPass);
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"), (String)"Test user should be successfully logged in.");
        AccountHelper.logout((RealmResource)this.managedRealm.admin(), (String)userName);
        Optional<CredentialRepresentation> passwordCredential = this.managedRealm.admin().users().get(userId).credentials().stream().filter(c -> "password".equals(c.getType())).findFirst();
        Assertions.assertTrue((boolean)passwordCredential.isPresent(), (String)"Test user should have a password credential set.");
        this.managedRealm.admin().users().get(userId).removeCredential(passwordCredential.get().getId());
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.fillLogin(userName, userPass);
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getCurrentUrl().contains(String.format("/realms/%s/login-actions/authenticate", this.managedRealm.getName())), (String)"Test user should fail to log in after password was deleted.");
    }

    @Test
    public void testUpdateCredentials() {
        UserResource user = this.userOtp1.admin();
        CredentialRepresentation otpCred = user.credentials().stream().filter(cr -> "otp".equals(cr.getType())).findFirst().orElseThrow();
        Assertions.assertNull((Object)otpCred.getUserLabel());
        String newLabel = "the label";
        user.setCredentialUserLabel(otpCred.getId(), newLabel);
        Assertions.assertEquals((Object)newLabel, (Object)user.credentials().stream().filter(cr -> cr.getId().equals(otpCred.getId())).findFirst().orElseThrow().getUserLabel());
    }

    @Test
    public void testShouldFailToSetCredentialUserLabelWhenLabelIsEmpty() {
        UserResource user = this.userOtp1.admin();
        CredentialRepresentation otpCred = (CredentialRepresentation)user.credentials().get(0);
        BadRequestException ex = (BadRequestException)Assertions.assertThrows(BadRequestException.class, () -> user.setCredentialUserLabel(otpCred.getId(), "   "));
        Response response = ex.getResponse();
        String body = (String)response.readEntity(String.class);
        Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        Assertions.assertTrue((boolean)body.contains("missingCredentialLabel"));
        Assertions.assertTrue((boolean)body.contains("Credential label must not be empty"));
    }

    @Test
    public void testShouldFailToSetCredentialUserLabelWhenLabelAlreadyExists() {
        UserResource user = this.userOtp2.admin();
        List<CredentialRepresentation> credentials = user.credentials().stream().filter(c -> c.getType().equals("otp")).toList();
        Assertions.assertEquals((int)2, (int)credentials.size());
        String firstId = credentials.get(0).getId();
        String secondId = credentials.get(1).getId();
        user.setCredentialUserLabel(firstId, "Device");
        user.setCredentialUserLabel(secondId, "Second Device");
        ClientErrorException ex = (ClientErrorException)Assertions.assertThrows(ClientErrorException.class, () -> user.setCredentialUserLabel(secondId, "Device"));
        Response response = ex.getResponse();
        Assertions.assertEquals((int)Response.Status.CONFLICT.getStatusCode(), (int)response.getStatus());
        String body = (String)response.readEntity(String.class);
        Assertions.assertNotNull((Object)body);
        Assertions.assertTrue((boolean)body.contains("Device already exists with the same name"));
    }

    @Test
    public void testDeleteCredentials() {
        UserResource user = this.johnDoh.admin();
        List creds = user.credentials();
        Assertions.assertEquals((int)1, (int)creds.size());
        CredentialRepresentation credPasswd = (CredentialRepresentation)creds.get(0);
        Assertions.assertEquals((Object)"password", (Object)credPasswd.getType());
        user.removeCredential(credPasswd.getId());
        Assertions.assertEquals((int)0, (int)user.credentials().size());
        credPasswd.setValue("password");
        user.resetPassword(credPasswd);
        Assertions.assertEquals((int)1, (int)user.credentials().size());
    }

    @Test
    public void testCRUDCredentialsOfDifferentUser() {
        UserResource user1 = this.userOtp1.admin();
        CredentialRepresentation otpCredential = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        UserResource user2 = ApiUtil.findUserByUsernameId((RealmResource)this.managedRealm.admin(), (String)this.testUser.getUsername());
        try {
            user2.setCredentialUserLabel(otpCredential.getId(), "new-label");
            Assertions.fail((String)"Not expected to successfully update user label");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.moveCredentialToFirst(otpCredential.getId());
            Assertions.fail((String)"Not expected to successfully move credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.removeCredential(otpCredential.getId());
            Assertions.fail((String)"Not expected to successfully remove credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        CredentialRepresentation otpCredentialLoaded = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        Assertions.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getUserLabel(), (Object)otpCredentialLoaded.getUserLabel()));
        Assertions.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getPriority(), (Object)otpCredentialLoaded.getPriority()));
    }

    @Test
    public void testGetAndMoveCredentials() {
        UserResource user = this.userOtp2.admin();
        List creds = user.credentials();
        List<String> expectedCredIds = Arrays.asList(((CredentialRepresentation)creds.get(0)).getId(), ((CredentialRepresentation)creds.get(1)).getId(), ((CredentialRepresentation)creds.get(2)).getId());
        this.assertSameIds(expectedCredIds, user.credentials());
        user.moveCredentialAfter(expectedCredIds.get(0), expectedCredIds.get(1));
        List<String> newOrderCredIds = Arrays.asList(expectedCredIds.get(1), expectedCredIds.get(0), expectedCredIds.get(2));
        this.assertSameIds(newOrderCredIds, user.credentials());
        user.moveCredentialToFirst(expectedCredIds.get(2));
        newOrderCredIds = Arrays.asList(expectedCredIds.get(2), expectedCredIds.get(1), expectedCredIds.get(0));
        this.assertSameIds(newOrderCredIds, user.credentials());
        user.moveCredentialToFirst(expectedCredIds.get(1));
        user.moveCredentialToFirst(expectedCredIds.get(0));
        this.assertSameIds(expectedCredIds, user.credentials());
    }

    @Test
    public void expectNoPasswordShownWhenCreatingUserWithPassword() throws IOException {
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue("password");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("test");
        user.setCredentials(Collections.singletonList(credential));
        user.setEnabled(Boolean.valueOf(true));
        this.createUser(user, false);
        String actualRepresentation = ((AdminEventRepresentation)this.adminEvents.poll()).getRepresentation();
        Assertions.assertEquals((Object)JsonSerialization.writeValueAsString((Object)user), (Object)actualRepresentation);
    }

    private void assertSameIds(List<String> expectedIds, List<CredentialRepresentation> actual) {
        Assertions.assertEquals((int)expectedIds.size(), (int)actual.size());
        for (int i = 0; i < expectedIds.size(); ++i) {
            Assertions.assertEquals((Object)expectedIds.get(i), (Object)actual.get(i).getId());
        }
    }

    private static class UserCredentialOtp2UserConf
    implements UserConfig {
        private UserCredentialOtp2UserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("user-with-two-configured-otp");
            builder.password("password");
            builder.name("Otp", "2");
            builder.email("otp2@redhat.com");
            builder.emailVerified(true);
            builder.totpSecret("DJmQfC73VGFhw7D4QJ8A");
            builder.totpSecret("ABCQfC73VGFhw7D4QJ8A");
            return builder;
        }
    }

    private static class UserCredentialOtp1UserConf
    implements UserConfig {
        private UserCredentialOtp1UserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("user-with-one-configured-otp");
            builder.password("password");
            builder.name("Otp", "1");
            builder.email("otp1@redhat.com");
            builder.emailVerified(true);
            builder.totpSecret("DJmQfC73VGFhw7D4QJ8A");
            return builder;
        }
    }

    private static class UserCredentialTestUserConf
    implements UserConfig {
        private UserCredentialTestUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("test-user@localhost");
            builder.password("password");
            builder.name("Tom", "Brady");
            builder.email("test-user@localhost");
            builder.emailVerified(true);
            return builder;
        }
    }

    private static class UserCredentialJohnDohUserConf
    implements UserConfig {
        private UserCredentialJohnDohUserConf() {
        }

        public UserConfigBuilder configure(UserConfigBuilder builder) {
            builder.username("john-doh@localhost");
            builder.password("password");
            builder.name("John", "Doh");
            builder.email("john-doh@localhost");
            builder.emailVerified(true);
            return builder;
        }
    }
}

