/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class UserDeleteTest
extends AbstractUserTest {
    @Test
    public void delete() {
        String userId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().users().create(UserConfigBuilder.create().username("user1").email("user1@localhost.com").build()));
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()));
        this.deleteUser(userId);
    }

    @Test
    public void deleteNonExistent() {
        try (Response response = this.managedRealm.admin().users().delete("does-not-exist");){
            Assertions.assertEquals((int)404, (int)response.getStatus());
        }
        Assertions.assertNull((Object)this.adminEvents.poll());
    }
}

