/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.mail.internet.MimeMessage;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.VerificationException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectClient;
import org.keycloak.testframework.annotations.InjectKeycloakUrls;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.mail.MailServer;
import org.keycloak.testframework.mail.annotations.InjectMailServer;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.remote.timeoffset.InjectTimeOffSet;
import org.keycloak.testframework.remote.timeoffset.TimeOffSet;
import org.keycloak.testframework.server.KeycloakUrls;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.page.ErrorPage;
import org.keycloak.testframework.ui.page.InfoPage;
import org.keycloak.testframework.ui.page.LoginPasswordUpdatePage;
import org.keycloak.testframework.ui.page.ProceedPage;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.MailUtils;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.openqa.selenium.By;

@KeycloakIntegrationTest
public class UserEmailTest
extends AbstractUserTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectClient(config=UserEmailTestAppClientConf.class)
    ManagedClient client;
    @InjectMailServer
    MailServer mailServer;
    @InjectKeycloakUrls
    KeycloakUrls keycloakUrls;
    @InjectTimeOffSet
    TimeOffSet timeOffSet;
    @InjectPage
    LoginPasswordUpdatePage passwordUpdatePage;
    @InjectPage
    InfoPage infoPage;
    @InjectPage
    ProceedPage proceedPage;
    @InjectPage
    ErrorPage errorPage;

    @Test
    public void sendResetPasswordEmail() {
        ErrorRepresentation error;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user1");
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList actions = new LinkedList();
        try {
            user.executeActionsEmail(actions);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.executeActionsEmail(actions);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.executeActionsEmail(Arrays.asList(UserModel.RequiredAction.UPDATE_PASSWORD.name(), "invalid\"<img src=\"alert(0)\">"));
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Provided invalid required actions", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        try {
            user.executeActionsEmail("invalidClientId", "invalidUri", Collections.singletonList(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Client doesn't exist", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void sendResetPasswordEmailSuccess() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        Assertions.assertTrue((boolean)body.getText().contains("Update Password"));
        Assertions.assertTrue((boolean)body.getText().contains("your Default account"));
        Assertions.assertTrue((boolean)body.getText().contains("This link will expire within 12 hours"));
        String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.containsString((String)"client_id=account"));
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        this.driver.navigate().to(link);
        this.errorPage.assertCurrent();
    }

    @Test
    public void sendResetPasswordEmailSuccessWithAccountClientDisabled() throws IOException {
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.managedRealm.admin().clients().findByClientId("account").get(0);
        clientRepresentation.setEnabled(Boolean.valueOf(false));
        this.managedRealm.admin().clients().get(clientRepresentation.getId()).update(clientRepresentation);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)clientRepresentation.getId()), (Object)clientRepresentation, (ResourceType)ResourceType.CLIENT);
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        MatcherAssert.assertThat((Object)this.driver.getCurrentUrl(), (Matcher)Matchers.containsString((String)"client_id=_system"));
        clientRepresentation.setEnabled(Boolean.valueOf(true));
        this.managedRealm.admin().clients().get(clientRepresentation.getId()).update(clientRepresentation);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.clientResourcePath((String)clientRepresentation.getId()), (Object)clientRepresentation, (ResourceType)ResourceType.CLIENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmailLinkBasedOnRealmFrontEndUrl() throws Exception {
        try {
            this.updateRealmFrontEndUrl(this.adminClient.realm("master"), this.keycloakUrls.getBase());
            String expectedFrontEndUrl = "https://mytestrealm";
            this.updateRealmFrontEndUrl(this.adminClient.realm(this.managedRealm.getName()), expectedFrontEndUrl);
            UserRepresentation userRep = new UserRepresentation();
            userRep.setEnabled(Boolean.valueOf(true));
            userRep.setUsername("user1");
            userRep.setEmail("user1@test.com");
            String id = this.createUser(userRep, false);
            UserResource user = this.managedRealm.admin().users().get(id);
            LinkedList<String> actions = new LinkedList<String>();
            actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
            user.executeActionsEmail(actions);
            Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
            MimeMessage message = this.mailServer.getReceivedMessages()[0];
            MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
            String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
            Assertions.assertTrue((boolean)link.contains(expectedFrontEndUrl));
        }
        finally {
            this.updateRealmFrontEndUrl(this.adminClient.realm("master"), null);
            this.updateRealmFrontEndUrl(this.adminClient.realm(this.managedRealm.getName()), null);
        }
    }

    @Test
    public void sendResetPasswordEmailWithCustomLifespan() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        int lifespan = (int)TimeUnit.HOURS.toSeconds(5L);
        user.executeActionsEmail(actions, Integer.valueOf(lifespan));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        Assertions.assertTrue((boolean)body.getText().contains("Update Password"));
        Assertions.assertTrue((boolean)body.getText().contains("your Default account"));
        Assertions.assertTrue((boolean)body.getText().contains("This link will expire within 5 hours"));
        String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
        String token = link.substring(link.indexOf("key=") + "key=".length());
        try {
            AccessToken accessToken = (AccessToken)TokenVerifier.create((String)token, AccessToken.class).getToken();
            MatcherAssert.assertThat((Object)(accessToken.getExp() - accessToken.getIat()), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf((long)lifespan - 1L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf((long)lifespan + 1L))));
            Assertions.assertEquals((Object)"account", (Object)accessToken.getIssuedFor());
        }
        catch (VerificationException e) {
            throw new IOException(e);
        }
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        this.driver.navigate().to(link);
        this.errorPage.assertCurrent();
    }

    @Test
    public void sendResetPasswordEmailSuccessTwoLinks() throws IOException {
        String link;
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)2, (int)this.mailServer.getReceivedMessages().length);
        int i = 1;
        for (MimeMessage message : this.mailServer.getReceivedMessages()) {
            link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.proceedPage.assertCurrent();
            MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
            this.proceedPage.clickProceedLink();
            this.passwordUpdatePage.assertCurrent();
            this.passwordUpdatePage.changePassword("new-pass" + i, "new-pass" + i);
            ++i;
            Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        }
        for (MimeMessage message : this.mailServer.getReceivedMessages()) {
            link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
        }
    }

    @Test
    public void sendResetPasswordEmailSuccessTwoLinksReverse() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)2, (int)this.mailServer.getReceivedMessages().length);
        int i = 1;
        for (int j = this.mailServer.getReceivedMessages().length - 1; j >= 0; --j) {
            MimeMessage message = this.mailServer.getReceivedMessages()[j];
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.proceedPage.assertCurrent();
            MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
            this.proceedPage.clickProceedLink();
            this.passwordUpdatePage.assertCurrent();
            this.passwordUpdatePage.changePassword("new-pass" + i, "new-pass" + i);
            ++i;
            Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        }
        for (MimeMessage message : this.mailServer.getReceivedMessages()) {
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
        }
    }

    @Test
    public void sendResetPasswordEmailSuccessLinkOpenDoesNotExpireWhenOpenedOnly() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.driver.manage().deleteAllCookies();
        this.driver.navigate().to("about:blank");
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendResetPasswordEmailSuccessTokenShortLifespan() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        originalValue.set(realmRep.getActionTokenGeneratedByAdminLifespan());
        realmRep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(60));
        this.managedRealm.admin().update(realmRep);
        try {
            UserResource user = this.managedRealm.admin().users().get(id);
            LinkedList<String> actions = new LinkedList<String>();
            actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
            user.executeActionsEmail(actions);
            Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
            MimeMessage message = this.mailServer.getReceivedMessages()[0];
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.timeOffSet.set(70);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
            Assertions.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
        }
        finally {
            this.timeOffSet.set(0);
            realmRep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(originalValue.get()));
            this.managedRealm.admin().update(realmRep);
        }
    }

    @Test
    public void sendResetPasswordEmailSuccessWithRecycledAuthSession() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient2");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient2");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.managedRealm.admin().clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)createdId), (Object)client, (ResourceType)ResourceType.CLIENT);
        user.executeActionsEmail("myclient2", "http://myclient.com/home.html", actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        user.executeActionsEmail(actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)2, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message2 = this.mailServer.getReceivedMessages()[this.mailServer.getReceivedMessages().length - 1];
        String link2 = MailUtils.getPasswordResetEmailLink((MimeMessage)message2);
        this.driver.navigate().to(link2);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        this.driver.navigate().to(link2);
        this.errorPage.assertCurrent();
    }

    @Test
    public void sendResetPasswordEmailWithRedirect() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.managedRealm.admin().clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)createdId), (Object)client, (ResourceType)ResourceType.CLIENT);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        try {
            user.executeActionsEmail("myclient", "http://unregistered-uri.com/", actions);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.executeActionsEmail("myclient", "http://myclient.com/home.html", actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.driver.findElement(By.id((String)"kc-page-title")).getText());
        String pageSource = this.driver.getPageSource();
        Assertions.assertTrue((boolean)pageSource.contains("http://myclient.com/home.html"));
        this.driver.navigate().to(link);
        this.errorPage.assertCurrent();
    }

    @Test
    public void sendResetPasswordEmailWithRedirectAndCustomLifespan() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.managedRealm.admin().clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.clientResourcePath((String)createdId), (Object)client, (ResourceType)ResourceType.CLIENT);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        int lifespan = (int)TimeUnit.DAYS.toSeconds(128L);
        try {
            user.executeActionsEmail("myclient", "http://unregistered-uri.com/", Integer.valueOf(lifespan), actions);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.executeActionsEmail("myclient", "http://myclient.com/home.html", Integer.valueOf(lifespan), actions);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/execute-actions-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        Assertions.assertTrue((boolean)body.getText().contains("This link will expire within 128 days"));
        Assertions.assertTrue((boolean)body.getHtml().contains("This link will expire within 128 days"));
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        String token = link.substring(link.indexOf("key=") + "key=".length());
        try {
            AccessToken accessToken = (AccessToken)TokenVerifier.create((String)token, AccessToken.class).getToken();
            Assertions.assertEquals((long)lifespan, (long)(accessToken.getExp() - accessToken.getIat()));
        }
        catch (VerificationException e) {
            throw new IOException(e);
        }
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.driver.findElement(By.id((String)"kc-page-title")).getText());
        String pageSource = this.driver.getPageSource();
        Assertions.assertTrue((boolean)pageSource.contains("http://myclient.com/home.html"));
        this.driver.navigate().to(link);
        this.errorPage.assertCurrent();
    }

    @Test
    public void sendVerifyEmail() throws IOException {
        ErrorRepresentation error;
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        try {
            user.sendVerifyEmail();
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.sendVerifyEmail();
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.sendVerifyEmail("invalidClientId");
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Client doesn't exist", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        user.sendVerifyEmail();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/send-verify-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)this.mailServer.getReceivedMessages()[0]);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Confirm validity of e-mail address"));
        this.proceedPage.clickProceedLink();
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        this.driver.navigate().to("about:blank");
        this.driver.navigate().to(link);
        this.infoPage.assertCurrent();
        Assertions.assertEquals((Object)"Your email address has been verified already.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void sendVerifyEmailWithRedirect() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        String clientId = this.client.getClientId();
        String redirectUri = this.keycloakUrls.getBase() + "/auth/some-page";
        try {
            user.sendVerifyEmail(clientId, "http://unregistered-uri.com/");
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.sendVerifyEmail(clientId, redirectUri);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/send-verify-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Confirm validity of e-mail address"));
        this.proceedPage.clickProceedLink();
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        String pageSource = this.driver.getPageSource();
        Assertions.assertTrue((boolean)pageSource.contains(redirectUri));
    }

    @Test
    public void sendVerifyEmailWithRedirectAndCustomLifespan() throws IOException {
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").name("User", "One").email("user1@test.com").build();
        String id = this.createUser(userRep);
        UserResource user = this.managedRealm.admin().users().get(id);
        int lifespan = (int)TimeUnit.DAYS.toSeconds(1L);
        String redirectUri = this.keycloakUrls.getBase() + "/auth/some-page";
        try {
            user.sendVerifyEmail(this.client.getClientId(), "http://unregistered-uri.com/", Integer.valueOf(lifespan));
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)400, (int)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.sendVerifyEmail(this.client.getClientId(), redirectUri, Integer.valueOf(lifespan));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.ACTION, (String)(AdminEventPaths.userResourcePath((String)id) + "/send-verify-email"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)1, (int)this.mailServer.getReceivedMessages().length);
        MimeMessage message = this.mailServer.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        MatcherAssert.assertThat((Object)body.getText(), (Matcher)Matchers.containsString((String)"This link will expire within 1 day"));
        MatcherAssert.assertThat((Object)body.getHtml(), (Matcher)Matchers.containsString((String)"This link will expire within 1 day"));
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        String token = link.substring(link.indexOf("key=") + "key=".length());
        try {
            AccessToken accessToken = (AccessToken)TokenVerifier.create((String)token, AccessToken.class).getToken();
            Assertions.assertEquals((long)lifespan, (long)(accessToken.getExp() - accessToken.getIat()));
        }
        catch (VerificationException e) {
            throw new IOException(e);
        }
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        MatcherAssert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Confirm validity of e-mail address"));
        this.proceedPage.clickProceedLink();
        Assertions.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        String pageSource = this.driver.getPageSource();
        Assertions.assertTrue((boolean)pageSource.contains(redirectUri));
    }

    private void updateRealmFrontEndUrl(RealmResource realm, String url) throws Exception {
        RealmRepresentation master = realm.toRepresentation();
        Map attributes = Optional.ofNullable(master.getAttributes()).orElse(new HashMap());
        if (url == null) {
            attributes.remove("frontendUrl");
        } else {
            attributes.put("frontendUrl", url);
        }
        realm.update(master);
    }

    private static class UserEmailTestAppClientConf
    implements ClientConfig {
        private UserEmailTestAppClientConf() {
        }

        public ClientConfigBuilder configure(ClientConfigBuilder builder) {
            builder.clientId("test-app-email");
            builder.secret("password");
            builder.baseUrl("http://localhost:8080/auth/");
            builder.redirectUris(new String[]{"http://localhost:8080/auth/*"});
            builder.adminUrl("http://localhost:8080/auth/admin");
            return builder;
        }
    }
}

