/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest(config=UserFederationServerConfig.class)
public class UserFedarationTest
extends AbstractUserTest {
    @Test
    public void getFederatedIdentities() {
        this.addSampleIdentityProvider();
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        Assertions.assertEquals((int)0, (int)user.getFederatedIdentity().size());
        FederatedIdentityRepresentation link = new FederatedIdentityRepresentation();
        link.setUserId("social-user-id");
        link.setUserName("social-username");
        this.addFederatedIdentity(id, "social-provider-id", link);
        List federatedIdentities = user.getFederatedIdentity();
        Assertions.assertEquals((int)1, (int)federatedIdentities.size());
        link = (FederatedIdentityRepresentation)federatedIdentities.get(0);
        Assertions.assertEquals((Object)"social-provider-id", (Object)link.getIdentityProvider());
        Assertions.assertEquals((Object)"social-user-id", (Object)link.getUserId());
        Assertions.assertEquals((Object)"social-username", (Object)link.getUserName());
        user.removeFederatedIdentity("social-provider-id");
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.userFederatedIdentityLink((String)id, (String)"social-provider-id"), (ResourceType)ResourceType.USER);
        Assertions.assertEquals((int)0, (int)user.getFederatedIdentity().size());
        this.removeSampleIdentityProvider();
    }

    @Test
    public void testUpdateCredentialLabelForFederatedUser() {
        ComponentRepresentation memProvider = new ComponentRepresentation();
        memProvider.setName("memory");
        memProvider.setProviderId("user-password-map-arq");
        memProvider.setProviderType(UserStorageProvider.class.getName());
        memProvider.setConfig(new MultivaluedHashMap());
        memProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        memProvider.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        String memProviderId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().components().add(memProvider));
        this.managedRealm.cleanup().add(realm -> realm.components().component(memProviderId).remove());
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.componentPath((String)memProviderId), (Object)memProvider, (ResourceType)ResourceType.COMPONENT);
        String username = "fed-user1";
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername(username);
        userRepresentation.setEmail("feduser1@mail.com");
        userRepresentation.setRequiredActions(Collections.emptyList());
        userRepresentation.setEnabled(Boolean.valueOf(true));
        userRepresentation.setFederationLink(memProviderId);
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
        CredentialRepresentation hashedPassword = ModelToRepresentation.toRepresentation((CredentialModel)pcm);
        hashedPassword.setCreatedDate(Long.valueOf(1001L));
        hashedPassword.setUserLabel("label");
        hashedPassword.setType("password");
        userRepresentation.setCredentials(Arrays.asList(hashedPassword));
        String userId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().users().create(userRepresentation));
        Assert.assertFalse((boolean)StorageId.isLocalStorage((String)userId));
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.managedRealm.admin(), (String)username);
        List credentials = user.credentials();
        Assertions.assertNotNull((Object)credentials);
        Assertions.assertEquals((int)1, (int)credentials.size());
        Assertions.assertEquals((Object)"label", (Object)((CredentialRepresentation)credentials.get(0)).getUserLabel());
        user.setCredentialUserLabel(((CredentialRepresentation)credentials.get(0)).getId(), "updatedLabel");
        credentials = user.credentials();
        Assertions.assertNotNull((Object)credentials);
        Assertions.assertEquals((int)1, (int)credentials.size());
        Assertions.assertEquals((Object)"updatedLabel", (Object)((CredentialRepresentation)credentials.get(0)).getUserLabel());
    }

    @Test
    public void createFederatedIdentities() {
        String identityProviderAlias = "social-provider-id";
        String username = "federated-identities";
        String federatedUserId = "federated-user-id";
        this.addSampleIdentityProvider();
        UserRepresentation build = UserConfigBuilder.create().username(username).federatedLink(identityProviderAlias, federatedUserId, username).build();
        String userId = this.createUser(build, false);
        List obtainedFederatedIdentities = this.managedRealm.admin().users().get(userId).getFederatedIdentity();
        Assertions.assertEquals((int)1, (int)obtainedFederatedIdentities.size());
        Assertions.assertEquals((Object)federatedUserId, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getUserId());
        Assertions.assertEquals((Object)username, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getUserName());
        Assertions.assertEquals((Object)identityProviderAlias, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getIdentityProvider());
    }

    private void removeSampleIdentityProvider() {
        IdentityProviderResource resource = this.managedRealm.admin().identityProviders().get("social-provider-id");
        Assertions.assertNotNull((Object)resource);
        resource.remove();
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.identityProviderPath((String)"social-provider-id"), (ResourceType)ResourceType.IDENTITY_PROVIDER);
    }

    public static class UserFederationServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.dependency("org.keycloak.tests", "keycloak-tests-custom-providers");
        }
    }
}

