/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class UserGroupTest
extends AbstractUserTest {
    @Test
    public void testGetGroupsForUserFullRepresentation() {
        String userName = "averagejoe";
        String groupName = "groupWithAttribute";
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("attribute1", Arrays.asList("attribute1", "attribute2"));
        UserRepresentation userRepresentation = UserConfigBuilder.create().username(userName).name("average", "joe").password("password").email("joe@average.com").emailVerified(true).build();
        GroupRepresentation groupRepresentation = GroupConfigBuilder.create().name(groupName).setAttributes(attributes).build();
        String userId = this.createUser(userRepresentation);
        String groupId = this.createGroup(groupRepresentation).getId();
        UserResource user = this.managedRealm.admin().users().get(userId);
        user.joinGroup(groupId);
        List userGroups = user.groups(Integer.valueOf(0), Integer.valueOf(100), false);
        Assertions.assertFalse((boolean)userGroups.isEmpty());
        Assertions.assertTrue((boolean)((GroupRepresentation)userGroups.get(0)).getAttributes().containsKey("attribute1"));
    }

    @Test
    public void testGetSearchedGroupsForUserFullRepresentation() {
        String userName = "averagejoe";
        String groupName1 = "group1WithAttribute";
        String groupName2 = "group2WithAttribute";
        HashMap<String, List<String>> attributes1 = new HashMap<String, List<String>>();
        attributes1.put("attribute1", Arrays.asList("attribute1"));
        HashMap<String, List<String>> attributes2 = new HashMap<String, List<String>>();
        attributes2.put("attribute2", Arrays.asList("attribute2"));
        UserRepresentation userRepresentation = UserConfigBuilder.create().username(userName).name("average", "joe").password("password").email("joe@average.com").emailVerified(true).build();
        GroupRepresentation groupRepresentation = GroupConfigBuilder.create().name(groupName1).setAttributes(attributes1).build();
        GroupRepresentation groupRepresentation2 = GroupConfigBuilder.create().name(groupName2).setAttributes(attributes2).build();
        String userId = this.createUser(userRepresentation);
        String group1Id = this.createGroup(groupRepresentation).getId();
        String group2Id = this.createGroup(groupRepresentation2).getId();
        UserResource user = this.managedRealm.admin().users().get(userId);
        user.joinGroup(group1Id);
        user.joinGroup(group2Id);
        List userGroups = user.groups("group2", false);
        Assertions.assertFalse((boolean)userGroups.isEmpty());
        Assertions.assertTrue((boolean)((GroupRepresentation)userGroups.stream().collect(Collectors.toMap(GroupRepresentation::getName, Function.identity())).get(groupName2)).getAttributes().containsKey("attribute2"));
        userGroups = user.groups("group3", false);
        Assertions.assertTrue((boolean)userGroups.isEmpty());
    }

    @Test
    public void groupMembershipPaginated() {
        String userId = this.createUser(UserConfigBuilder.create().username("user-a").build());
        for (int i = 1; i <= 10; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group-" + i);
            String groupId = this.createGroup(group).getId();
            this.managedRealm.admin().users().get(userId).joinGroup(groupId);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userGroupPath((String)userId, (String)groupId), (Object)group, (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        }
        List groups = this.managedRealm.admin().users().get(userId).groups(Integer.valueOf(5), Integer.valueOf(6));
        Assertions.assertEquals((int)groups.size(), (int)5);
        Assert.assertNames((List)groups, (String[])new String[]{"group-5", "group-6", "group-7", "group-8", "group-9"});
    }

    @Test
    public void groupMembershipSearch() {
        String userId = this.createUser(UserConfigBuilder.create().username("user-b").build());
        for (int i = 1; i <= 10; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group-" + i);
            String groupId = this.createGroup(group).getId();
            this.managedRealm.admin().users().get(userId).joinGroup(groupId);
            AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userGroupPath((String)userId, (String)groupId), (Object)group, (ResourceType)ResourceType.GROUP_MEMBERSHIP);
        }
        List groups = this.managedRealm.admin().users().get(userId).groups("-3", Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)((Long)this.managedRealm.admin().users().get(userId).groupsCount("-3").get("count")), (Matcher)Matchers.is((Object)1L));
        Assertions.assertEquals((int)1, (int)groups.size());
        Assert.assertNames((List)groups, (String[])new String[]{"group-3"});
        List groups2 = this.managedRealm.admin().users().get(userId).groups("1", Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)((Long)this.managedRealm.admin().users().get(userId).groupsCount("1").get("count")), (Matcher)Matchers.is((Object)2L));
        Assertions.assertEquals((int)2, (int)groups2.size());
        Assert.assertNames((List)groups2, (String[])new String[]{"group-1", "group-10"});
        List groups3 = this.managedRealm.admin().users().get(userId).groups("1", Integer.valueOf(2), Integer.valueOf(10));
        Assertions.assertEquals((int)0, (int)groups3.size());
        List groups4 = this.managedRealm.admin().users().get(userId).groups("gr", Integer.valueOf(2), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)((Long)this.managedRealm.admin().users().get(userId).groupsCount("gr").get("count")), (Matcher)Matchers.is((Object)10L));
        Assertions.assertEquals((int)8, (int)groups4.size());
        List groups5 = this.managedRealm.admin().users().get(userId).groups("Gr", Integer.valueOf(2), Integer.valueOf(10));
        Assertions.assertEquals((int)8, (int)groups5.size());
    }

    @Test
    public void createUserWithGroups() {
        String username = "user-with-groups";
        String groupToBeAdded = "test-group";
        this.createGroup(GroupConfigBuilder.create().name(groupToBeAdded).build());
        UserRepresentation build = UserConfigBuilder.create().username(username).groups(new String[]{groupToBeAdded}).build();
        String userId = this.createUser(build);
        List obtainedGroups = this.managedRealm.admin().users().get(userId).groups();
        Assertions.assertEquals((int)1, (int)obtainedGroups.size());
        Assertions.assertEquals((Object)groupToBeAdded, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
    }

    @Test
    public void joinParentGroupAfterSubGroup() {
        String username = "user-with-sub-and-parent-group";
        String parentGroupName = "parent-group";
        String subGroupName = "sub-group";
        UserRepresentation userRepresentation = UserConfigBuilder.create().username(username).build();
        GroupRepresentation subGroupRep = GroupConfigBuilder.create().name(subGroupName).build();
        GroupRepresentation parentGroupRep = GroupConfigBuilder.create().name(parentGroupName).subGroups(new GroupRepresentation[]{subGroupRep}).build();
        String userId = this.createUser(userRepresentation);
        String subGroupId = this.createGroup(subGroupRep).getId();
        String parentGroupId = this.createGroup(parentGroupRep).getId();
        UserResource user = this.managedRealm.admin().users().get(userId);
        user.joinGroup(subGroupId);
        List obtainedGroups = this.managedRealm.admin().users().get(userId).groups();
        Assertions.assertEquals((int)1, (int)obtainedGroups.size());
        Assertions.assertEquals((Object)subGroupName, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
        user.joinGroup(parentGroupId);
        obtainedGroups = this.managedRealm.admin().users().get(userId).groups();
        Assertions.assertEquals((int)2, (int)obtainedGroups.size());
        Assertions.assertEquals((Object)parentGroupName, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
        Assertions.assertEquals((Object)subGroupName, (Object)((GroupRepresentation)obtainedGroups.get(1)).getName());
    }

    @Test
    public void joinSubGroupAfterParentGroup() {
        String username = "user-with-sub-and-parent-group";
        String parentGroupName = "parent-group";
        String subGroupName = "sub-group";
        UserRepresentation userRepresentation = UserConfigBuilder.create().username(username).build();
        GroupRepresentation subGroupRep = GroupConfigBuilder.create().name(subGroupName).build();
        GroupRepresentation parentGroupRep = GroupConfigBuilder.create().name(parentGroupName).subGroups(new GroupRepresentation[]{subGroupRep}).build();
        String userId = this.createUser(userRepresentation);
        String subGroupId = this.createGroup(subGroupRep).getId();
        String parentGroupId = this.createGroup(parentGroupRep).getId();
        UserResource user = this.managedRealm.admin().users().get(userId);
        user.joinGroup(parentGroupId);
        List obtainedGroups = this.managedRealm.admin().users().get(userId).groups();
        Assertions.assertEquals((int)1, (int)obtainedGroups.size());
        Assertions.assertEquals((Object)parentGroupName, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
        user.joinGroup(subGroupId);
        obtainedGroups = this.managedRealm.admin().users().get(userId).groups();
        Assertions.assertEquals((int)2, (int)obtainedGroups.size());
        Assertions.assertEquals((Object)parentGroupName, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
        Assertions.assertEquals((Object)subGroupName, (Object)((GroupRepresentation)obtainedGroups.get(1)).getName());
    }

    private GroupRepresentation createGroup(GroupRepresentation group) {
        String groupId;
        try (Response response = this.managedRealm.admin().groups().add(group);){
            groupId = ApiUtil.getCreatedId((Response)response);
        }
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.groupPath((String)groupId), (Object)group, (ResourceType)ResourceType.GROUP);
        group.setId(groupId);
        return group;
    }
}

