/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserProfileAttributeMetadata;
import org.keycloak.representations.idm.UserProfileMetadata;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;

@KeycloakIntegrationTest
public class UserProfileTest
extends AbstractUserTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void testUsernameReadOnlyIfEmailAsUsernameEnabled() {
        this.switchRegistrationEmailAsUsername(true);
        String userId = this.createUser("user-metadata", "user-metadata@keycloak.org");
        UserRepresentation user = this.managedRealm.admin().users().get(userId).toRepresentation(true);
        UserProfileMetadata metadata = user.getUserProfileMetadata();
        Assertions.assertNotNull((Object)metadata);
        UserProfileAttributeMetadata username = metadata.getAttributeMetadata("username");
        Assertions.assertNotNull((Object)username);
        Assertions.assertTrue((boolean)username.isReadOnly());
        UserProfileAttributeMetadata email = metadata.getAttributeMetadata("email");
        Assertions.assertNotNull((Object)email);
        Assertions.assertFalse((boolean)email.isReadOnly());
    }

    @Test
    public void testEmailNotReadOnlyIfEmailAsUsernameEnabledAndEditUsernameDisabled() {
        this.switchRegistrationEmailAsUsername(true);
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertFalse((boolean)rep.isEditUsernameAllowed());
        String userId = this.createUser("user-metadata", "user-metadata@keycloak.org");
        UserRepresentation user = this.managedRealm.admin().users().get(userId).toRepresentation(true);
        UserProfileMetadata metadata = user.getUserProfileMetadata();
        Assertions.assertNotNull((Object)metadata);
        UserProfileAttributeMetadata username = metadata.getAttributeMetadata("username");
        Assertions.assertNotNull((Object)username);
        Assertions.assertTrue((boolean)username.isReadOnly());
        UserProfileAttributeMetadata email = metadata.getAttributeMetadata("email");
        Assertions.assertNotNull((Object)email);
        Assertions.assertFalse((boolean)email.isReadOnly());
    }

    @Test
    public void testUserProfileMetadata() {
        String userId = this.createUser("user-metadata", "user-metadata@keycloak.org");
        UserRepresentation user = this.managedRealm.admin().users().get(userId).toRepresentation(true);
        UserProfileMetadata metadata = user.getUserProfileMetadata();
        Assertions.assertNotNull((Object)metadata);
        for (String name : this.managedAttributes) {
            Assertions.assertNotNull((Object)metadata.getAttributeMetadata(name));
        }
    }

    @Test
    public void testSearchBasedOnUserProfileSettings() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("test_username");
        user.setFirstName("test_first_name");
        user.setLastName("test_last_name");
        user.setEmail("test_email@test.com");
        user.setEnabled(Boolean.valueOf(true));
        user.setEmailVerified(Boolean.valueOf(true));
        this.createUser(user);
        UPConfig upConfig = this.managedRealm.admin().users().userProfile().getConfiguration();
        upConfig.getAttribute("firstName").setPermissions(new UPAttributePermissions());
        this.managedRealm.admin().users().userProfile().update(upConfig);
        List users = this.managedRealm.admin().users().list();
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        user = (UserRepresentation)users.get(0);
        MatcherAssert.assertThat((Object)user.getFirstName(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultMaxResults() {
        UserProfileResource upResource = this.managedRealm.admin().users().userProfile();
        UPConfig upConfig = upResource.getConfiguration();
        upConfig.addOrReplaceAttribute(this.createAttributeMetadata("aName"));
        upConfig.getAttribute("aName").setPermissions(new UPAttributePermissions(Set.of("user", "admin"), Set.of("user", "admin")));
        upResource.update(upConfig);
        try {
            UsersResource users = this.managedRealm.admin().users();
            for (int i = 0; i < 110; ++i) {
                users.create(UserConfigBuilder.create().username("test2-" + i).attribute("aName", new String[]{"aValue"}).build()).close();
            }
            List result = users.search("test2", null, null);
            Assertions.assertEquals((int)100, (int)result.size());
            for (UserRepresentation user : result) {
                MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.notNullValue());
                MatcherAssert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.hasSize((int)1));
                MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"aName"), (Matcher)Matchers.contains((Object[])new String[]{"aValue"})));
            }
            Assertions.assertEquals((int)105, (int)users.search("test2", Integer.valueOf(0), Integer.valueOf(105)).size());
            Assertions.assertEquals((int)110, (int)users.search("test2", Integer.valueOf(0), Integer.valueOf(1000)).size());
        }
        finally {
            upConfig.removeAttribute("aName");
            upResource.update(upConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultMaxResultsBrief() {
        UserProfileResource upResource = this.managedRealm.admin().users().userProfile();
        UPConfig upConfig = upResource.getConfiguration();
        upConfig.addOrReplaceAttribute(this.createAttributeMetadata("aName"));
        upConfig.getAttribute("aName").setPermissions(new UPAttributePermissions());
        upResource.update(upConfig);
        try {
            UsersResource users = this.managedRealm.admin().users();
            for (int i = 0; i < 110; ++i) {
                users.create(UserConfigBuilder.create().username("test-" + i).attribute("aName", new String[]{"aValue"}).build()).close();
            }
            List result = users.search("test", null, null, Boolean.valueOf(true));
            Assertions.assertEquals((int)100, (int)result.size());
            for (UserRepresentation user : result) {
                MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.nullValue());
            }
        }
        finally {
            upConfig.removeAttribute("aName");
            upResource.update(upConfig);
        }
    }
}

