/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class UserRequiredActionsTest
extends AbstractUserTest {
    @Test
    public void addRequiredAction() {
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        Assertions.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        this.updateUser(user, userRep);
        Assertions.assertEquals((int)1, (int)user.toRepresentation().getRequiredActions().size());
        Assertions.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), user.toRepresentation().getRequiredActions().get(0));
    }

    @Test
    public void removeRequiredAction() {
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        Assertions.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        this.updateUser(user, userRep);
        user = this.managedRealm.admin().users().get(id);
        userRep = user.toRepresentation();
        userRep.getRequiredActions().clear();
        this.updateUser(user, userRep);
        Assertions.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
    }

    @Test
    public void testDefaultRequiredActionAdded() {
        RequiredActionProviderRepresentation updatePasswordReqAction = this.managedRealm.admin().flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(true);
        this.managedRealm.admin().flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionPath((String)UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, (ResourceType)ResourceType.REQUIRED_ACTION);
        String userId = this.createUser("user1", "user1@localhost");
        UserRepresentation userRep = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertEquals((int)1, (int)userRep.getRequiredActions().size());
        Assertions.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), userRep.getRequiredActions().get(0));
        updatePasswordReqAction = this.managedRealm.admin().flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(false);
        this.managedRealm.admin().flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authRequiredActionPath((String)UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, (ResourceType)ResourceType.REQUIRED_ACTION);
    }
}

