/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.GroupConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RoleConfigBuilder;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.Assert;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class UserRoleTest
extends AbstractUserTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;

    @Test
    public void roleMappings() {
        String userId;
        String clientUuid;
        RealmResource realm = this.managedRealm.admin();
        RoleRepresentation realmCompositeRole = RoleConfigBuilder.create().name("realm-composite").singleAttribute("attribute1", "value1").build();
        realm.roles().create(RoleConfigBuilder.create().name("realm-role").build());
        realm.roles().create(realmCompositeRole);
        realm.roles().create(RoleConfigBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        try (Response response = realm.clients().create(ClientConfigBuilder.create().clientId("myclient").build());){
            clientUuid = ApiUtil.getCreatedId((Response)response);
        }
        RoleRepresentation clientCompositeRole = RoleConfigBuilder.create().name("client-composite").singleAttribute("attribute1", "value1").build();
        realm.clients().get(clientUuid).roles().create(RoleConfigBuilder.create().name("client-role").build());
        realm.clients().get(clientUuid).roles().create(RoleConfigBuilder.create().name("client-role2").build());
        realm.clients().get(clientUuid).roles().create(clientCompositeRole);
        realm.clients().get(clientUuid).roles().create(RoleConfigBuilder.create().name("client-child").build());
        realm.clients().get(clientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        try (Response response = realm.users().create(UserConfigBuilder.create().username("myuser").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        this.adminEvents.clear();
        RoleMappingResource roles = realm.users().get(userId).roles();
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)roles.realmLevel().listEffective(), (String[])new String[]{"offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(realm.roles().get("realm-role").toRepresentation());
        l.add(realm.roles().get("realm-composite").toRepresentation());
        roles.realmLevel().add(l);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userRealmRoleMappingsPath((String)userId), l, (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        List<RoleRepresentation> list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userClientRoleMappingsPath((String)userId, (String)clientUuid), list, (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-composite").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.CREATE, (String)AdminEventPaths.userClientRoleMappingsPath((String)userId, (String)clientUuid), (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-role", "realm-composite", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)roles.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "offline_access", "uma_authorization"});
        Assert.assertNames((List)roles.realmLevel().listEffective(), (String[])new String[]{"realm-role", "realm-composite", "realm-child", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        List realmRolesFullRepresentations = roles.realmLevel().listEffective(false);
        RoleRepresentation realmCompositeRoleFromList = this.getRoleByName("realm-composite", realmRolesFullRepresentations);
        Assertions.assertNotNull((Object)realmCompositeRoleFromList);
        Assertions.assertTrue((boolean)realmCompositeRoleFromList.getAttributes().containsKey("attribute1"));
        Assert.assertNames((List)roles.clientLevel(clientUuid).listAll(), (String[])new String[]{"client-role", "client-composite"});
        Assert.assertNames((List)roles.clientLevel(clientUuid).listAvailable(), (String[])new String[]{"client-role2", "client-child"});
        Assert.assertNames((List)roles.clientLevel(clientUuid).listEffective(), (String[])new String[]{"client-role", "client-composite", "client-child"});
        List rolesFullRepresentations = roles.clientLevel(clientUuid).listEffective(false);
        RoleRepresentation clientCompositeRoleFromList = this.getRoleByName("client-composite", rolesFullRepresentations);
        Assertions.assertNotNull((Object)clientCompositeRoleFromList);
        Assertions.assertTrue((boolean)clientCompositeRoleFromList.getAttributes().containsKey("attribute1"));
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames((List)all.getRealmMappings(), (String[])new String[]{"realm-role", "realm-composite", "default-roles-" + this.managedRealm.getName()});
        Assertions.assertEquals((int)1, (int)all.getClientMappings().size());
        Assert.assertNames((List)((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), (String[])new String[]{"client-role", "client-composite"});
        RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
        roles.realmLevel().remove(Collections.singletonList(realmRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.userRealmRoleMappingsPath((String)userId), Collections.singletonList(realmRoleRep), (ResourceType)ResourceType.REALM_ROLE_MAPPING);
        Assert.assertNames((List)roles.realmLevel().listAll(), (String[])new String[]{"realm-composite", "default-roles-" + this.managedRealm.getName()});
        RoleRepresentation clientRoleRep = realm.clients().get(clientUuid).roles().get("client-role").toRepresentation();
        roles.clientLevel(clientUuid).remove(Collections.singletonList(clientRoleRep));
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.DELETE, (String)AdminEventPaths.userClientRoleMappingsPath((String)userId, (String)clientUuid), Collections.singletonList(clientRoleRep), (ResourceType)ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames((List)roles.clientLevel(clientUuid).listAll(), (String[])new String[]{"client-composite"});
    }

    @Test
    public void rolesCanBeAssignedEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.managedRealm.admin();
        RoleRepresentation realmCompositeRole = RoleConfigBuilder.create().name("realm-composite").build();
        realm.roles().create(realmCompositeRole);
        realm.roles().create(RoleConfigBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        realm.roles().create(RoleConfigBuilder.create().name("realm-role-in-group").build());
        Response response = realm.clients().create(ClientConfigBuilder.create().clientId("myclient").build());
        String clientUuid = ApiUtil.getCreatedId((Response)response);
        response.close();
        RoleRepresentation clientCompositeRole = RoleConfigBuilder.create().name("client-composite").build();
        realm.clients().get(clientUuid).roles().create(clientCompositeRole);
        realm.clients().get(clientUuid).roles().create(RoleConfigBuilder.create().name("client-child").build());
        realm.clients().get(clientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        realm.clients().get(clientUuid).roles().create(RoleConfigBuilder.create().name("client-role-in-group").build());
        GroupRepresentation group = GroupConfigBuilder.create().name("mygroup").build();
        response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        response.close();
        response = realm.users().create(UserConfigBuilder.create().username("myuser").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        realm.groups().group(groupId).roles().realmLevel().add(Collections.singletonList(realm.roles().get("realm-role-in-group").toRepresentation()));
        realm.groups().group(groupId).roles().clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role-in-group").toRepresentation()));
        realm.users().get(userId).joinGroup(groupId);
        RoleMappingResource userRoles = realm.users().get(userId).roles();
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-composite").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-composite").toRepresentation()));
        Assert.assertNames((List)userRoles.realmLevel().listAll(), (String[])new String[]{"realm-composite", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)userRoles.realmLevel().listAvailable(), (String[])new String[]{"realm-child", "realm-role-in-group", "offline_access", "uma_authorization"});
        Assert.assertNames((List)userRoles.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child", "realm-role-in-group", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listAll(), (String[])new String[]{"client-composite"});
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listAvailable(), (String[])new String[]{"client-child", "client-role-in-group"});
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child", "client-role-in-group"});
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-role-in-group").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role-in-group").toRepresentation()));
        Assert.assertNames((List)userRoles.realmLevel().listAll(), (String[])new String[]{"realm-composite", "realm-child", "realm-role-in-group", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)userRoles.realmLevel().listAvailable(), (String[])new String[]{"offline_access", "uma_authorization"});
        Assert.assertNames((List)userRoles.realmLevel().listEffective(), (String[])new String[]{"realm-composite", "realm-child", "realm-role-in-group", "offline_access", "uma_authorization", "default-roles-" + this.managedRealm.getName()});
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listAll(), (String[])new String[]{"client-composite", "client-child", "client-role-in-group"});
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listAvailable(), (String[])new String[0]);
        Assert.assertNames((List)userRoles.clientLevel(clientUuid).listEffective(), (String[])new String[]{"client-composite", "client-child", "client-role-in-group"});
        MappingsRepresentation all = userRoles.getAll();
        Assert.assertNames((List)all.getRealmMappings(), (String[])new String[]{"realm-composite", "realm-child", "realm-role-in-group", "default-roles-" + this.managedRealm.getName()});
        Assertions.assertEquals((int)1, (int)all.getClientMappings().size());
        Assert.assertNames((List)((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), (String[])new String[]{"client-composite", "client-child", "client-role-in-group"});
    }

    private RoleRepresentation getRoleByName(String name, List<RoleRepresentation> roles) {
        for (RoleRepresentation role : roles) {
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }
}

