/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.admin.ApiUtil;

@KeycloakIntegrationTest
public class UserSearchTest
extends AbstractUserTest {
    @Test
    public void countUsersByEnabledFilter() {
        UserRepresentation enabledUser1 = new UserRepresentation();
        enabledUser1.setUsername("enabled1");
        enabledUser1.setEmail("enabled1@enabledfilter.com");
        enabledUser1.setEnabled(Boolean.valueOf(true));
        this.createUser(enabledUser1);
        UserRepresentation enabledUser2 = new UserRepresentation();
        enabledUser2.setUsername("enabled2");
        enabledUser2.setEmail("enabled2@enabledfilter.com");
        enabledUser2.setEnabled(Boolean.valueOf(true));
        this.createUser(enabledUser2);
        UserRepresentation disabledUser1 = new UserRepresentation();
        disabledUser1.setUsername("disabled1");
        disabledUser1.setEmail("disabled1@enabledfilter.com");
        disabledUser1.setEnabled(Boolean.valueOf(false));
        this.createUser(disabledUser1);
        Boolean enabled = true;
        Boolean disabled = false;
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, "@enabledfilter.com", null, null, null, null), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, "@enabledfilter.com", null, "enabled1", enabled, null), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, "@enabledfilter.com", null, null, disabled, null), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.managedRealm.admin().users().count(null, null, null, "@enabledfilter.com", null, null, enabled, null), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void searchByEmail() {
        this.createUsers();
        List users = this.managedRealm.admin().users().search(null, null, null, "user1@localhost", null, null);
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search(null, null, null, "@localhost", null, null);
        Assertions.assertEquals((int)9, (int)users.size());
    }

    @Test
    public void searchByEmailExactMatch() {
        this.createUsers();
        List users = this.managedRealm.admin().users().searchByEmail("user1@localhost", Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search("@localhost", Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
    }

    @Test
    public void searchByUsername() {
        this.createUsers();
        List users = this.managedRealm.admin().users().search("username1", null, null, null, null, null);
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search("user", null, null, null, null, null);
        Assertions.assertEquals((int)9, (int)users.size());
    }

    @Test
    public void searchByAttribute() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("test", "test1");
        List users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(attributes));
        Assertions.assertEquals((int)1, (int)users.size());
        attributes.clear();
        attributes.put("attr", "common");
        users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(attributes));
        Assertions.assertEquals((int)9, (int)users.size());
        attributes.clear();
        attributes.put("x", "common");
        users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(attributes));
        Assertions.assertEquals((int)0, (int)users.size());
    }

    @Test
    public void searchByMultipleAttributes() {
        this.createUsers();
        List users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("username", "user", "test", "test1", "attr", "common", "test1", "test1")));
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("username", "user", "test", "est", "attr", "mm", "test1", "test1")));
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
        users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("username", "user", "test", "est", "attr", "mm", "test1", "test1")), Boolean.valueOf(false));
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        users = this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("test", "est", "attr", "mm", "test1", "test1")), Boolean.TRUE);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void searchByAttributesWithPagination() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attr", "Common");
        for (int i = 1; i < 10; ++i) {
            List users = this.managedRealm.admin().users().searchByAttributes(Integer.valueOf(i - 1), Integer.valueOf(1), null, Boolean.valueOf(false), this.mapToSearchQuery(attributes));
            Assertions.assertEquals((int)1, (int)users.size());
            Assertions.assertTrue((boolean)((UserRepresentation)users.get(0)).getAttributes().keySet().stream().anyMatch(attributes::containsKey));
        }
    }

    @Test
    public void storeAndReadUserWithLongAttributeValue() {
        String longValue = RandomStringUtils.random((int)Integer.parseInt("2048"), (boolean)true, (boolean)true);
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).attribute("attr", new String[]{longValue}).build();
        String userId = this.createUser(userRep);
        UserRepresentation user1 = this.managedRealm.admin().users().get(userId).toRepresentation();
        Assertions.assertNotNull((Object)user1);
        MatcherAssert.assertThat((Object)((String)((List)user1.getAttributes().get("attr")).get(0)), (Matcher)Matchers.equalTo((Object)longValue));
        UserRepresentation userRep2 = UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").emailVerified(true).attribute("attr", new String[]{longValue + "a"}).build();
        Response response = this.managedRealm.admin().users().create(userRep2);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)400));
        MatcherAssert.assertThat((Object)((ErrorRepresentation)response.readEntity(ErrorRepresentation.class)).getErrorMessage(), (Matcher)Matchers.equalTo((Object)"error-invalid-length"));
    }

    @Test
    public void searchByLongAttributes() {
        String longValue = RandomStringUtils.random((int)(Integer.parseInt("2048") - 1), (boolean)true, (boolean)true) + "u";
        String longValue2 = RandomStringUtils.random((int)(Integer.parseInt("2048") - 1), (boolean)true, (boolean)true) + "v";
        UserRepresentation userRep = UserConfigBuilder.create().username("user1").password("password").name("user1FirstName", "user1LastName").email("user1@example.com").emailVerified(true).attribute("test1", new String[]{longValue, "v2"}).attribute("test2", new String[]{"v2"}).build();
        UserRepresentation userRep2 = UserConfigBuilder.create().username("user2").password("password").name("user2FirstName", "user2LastName").email("user2@example.com").emailVerified(true).attribute("test1", new String[]{longValue, "v2"}).attribute("test2", new String[]{longValue2}).build();
        UserRepresentation userRep3 = UserConfigBuilder.create().username("user3").password("password").name("user3FirstName", "user3LastName").email("user3@example.com").emailVerified(true).attribute("test2", new String[]{longValue, "v3"}).attribute("test4", new String[]{"v4"}).build();
        this.createUser(userRep);
        this.createUser(userRep2);
        this.createUser(userRep3);
        MatcherAssert.assertThat(this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("test1", longValue))).stream().map(AbstractUserRepresentation::getUsername).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"user1", "user2"}));
        MatcherAssert.assertThat(this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("test1", longValue, "test2", longValue2))).stream().map(AbstractUserRepresentation::getUsername).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"user2"}));
        MatcherAssert.assertThat(this.managedRealm.admin().users().searchByAttributes(this.mapToSearchQuery(Map.of("test1", longValue, "test2", longValue2.toLowerCase(Locale.ENGLISH)))).stream().map(AbstractUserRepresentation::getUsername).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new String[]{"user2"}));
    }

    @Test
    public void searchByUsernameExactMatch() {
        this.createUsers();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("username11");
        this.createUser(user);
        List users = this.managedRealm.admin().users().search("username1", Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().searchByUsername("username1", Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search("user", Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
    }

    @Test
    public void searchByFirstNameExact() {
        this.createUsers();
        List users = this.managedRealm.admin().users().searchByFirstName("First1", Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void searchByLastNameExact() {
        this.createUsers();
        List users = this.managedRealm.admin().users().searchByLastName("Last1", Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void searchByFirstNameNullForLastName() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setFirstName("Erik");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        this.createUser(user);
        List users = this.managedRealm.admin().users().search("Erik", Integer.valueOf(0), Integer.valueOf(50));
        Assertions.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void searchByLastNameNullForFirstName() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setLastName("de Wit");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        this.createUser(user);
        List users = this.managedRealm.admin().users().search("*wit*", null, null);
        Assertions.assertEquals((int)1, (int)users.size());
    }

    @Test
    public void searchByEnabled() {
        String userCommonName = "enabled-disabled-user";
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername(userCommonName + "1");
        user1.setRequiredActions(Collections.emptyList());
        user1.setEnabled(Boolean.valueOf(true));
        this.createUser(user1);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername(userCommonName + "2");
        user2.setRequiredActions(Collections.emptyList());
        user2.setEnabled(Boolean.valueOf(false));
        this.createUser(user2);
        List enabledUsers = this.managedRealm.admin().users().search(null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        Assertions.assertEquals((int)1, (int)enabledUsers.size());
        List enabledUsersWithFilter = this.managedRealm.admin().users().search(userCommonName, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)enabledUsersWithFilter.size());
        Assertions.assertEquals((Object)user1.getUsername(), (Object)((UserRepresentation)enabledUsersWithFilter.get(0)).getUsername());
        List disabledUsers = this.managedRealm.admin().users().search(userCommonName, null, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        Assertions.assertEquals((int)1, (int)disabledUsers.size());
        Assertions.assertEquals((Object)user2.getUsername(), (Object)((UserRepresentation)disabledUsers.get(0)).getUsername());
        List allUsers = this.managedRealm.admin().users().search(userCommonName, null, null, null, Integer.valueOf(0), Integer.valueOf(100), null, Boolean.valueOf(true));
        Assertions.assertEquals((int)2, (int)allUsers.size());
    }

    @Test
    public void searchWithFilters() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setFirstName("First");
        user.setLastName("Last");
        user.setEmail("user2@localhost");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(false));
        this.createUser(user);
        List searchFirstNameAndDisabled = this.managedRealm.admin().users().search(null, "First", null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)searchFirstNameAndDisabled.size());
        Assertions.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchFirstNameAndDisabled.get(0)).getUsername());
        List searchLastNameAndEnabled = this.managedRealm.admin().users().search(null, null, "Last", null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        Assertions.assertEquals((int)0, (int)searchLastNameAndEnabled.size());
        List searchEmailAndDisabled = this.managedRealm.admin().users().search(null, null, null, "user2@localhost", Integer.valueOf(0), Integer.valueOf(50), Boolean.valueOf(false), Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)searchEmailAndDisabled.size());
        Assertions.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchEmailAndDisabled.get(0)).getUsername());
        List searchInvalidSizeAndDisabled = this.managedRealm.admin().users().search(null, null, null, null, Integer.valueOf(10), Integer.valueOf(20), null, Boolean.valueOf(false));
        Assertions.assertEquals((int)0, (int)searchInvalidSizeAndDisabled.size());
    }

    @Test
    public void searchWithFilterAndEnabledAttribute() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user3");
        user.setFirstName("user3First");
        user.setLastName("user3Last");
        user.setEmail("user3@localhost");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(false));
        this.createUser(user);
        List searchFilterUserNameAndDisabled = this.managedRealm.admin().users().search("user3", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertEquals((int)1, (int)searchFilterUserNameAndDisabled.size());
        Assertions.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchFilterUserNameAndDisabled.get(0)).getUsername());
        List searchFilterMailAndDisabled = this.managedRealm.admin().users().search("user3@localhost", Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertEquals((int)1, (int)searchFilterMailAndDisabled.size());
        Assertions.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchFilterMailAndDisabled.get(0)).getUsername());
        List searchFilterLastNameAndEnabled = this.managedRealm.admin().users().search("user3Last", Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5));
        Assertions.assertEquals((int)0, (int)searchFilterLastNameAndEnabled.size());
    }

    @Test
    public void searchByIdp() {
        this.createUser();
        String identityProviderAlias1 = "identity-provider-alias1";
        this.addSampleIdentityProvider("identity-provider-alias1", 0);
        String identityProviderAlias2 = "identity-provider-alias2";
        this.addSampleIdentityProvider("identity-provider-alias2", 1);
        String commonIdpUserId = "commonIdpUserId";
        String idp1User1Username = "idp1user1";
        String idp1User1KeycloakId = this.createUser("idp1user1", "idp1user1@localhost");
        String idp1User1UserId = "idp1user1Id";
        FederatedIdentityRepresentation link1_1 = new FederatedIdentityRepresentation();
        link1_1.setUserId("idp1user1Id");
        link1_1.setUserName("idp1user1");
        this.addFederatedIdentity(idp1User1KeycloakId, "identity-provider-alias1", link1_1);
        String idp1User2Username = "idp1user2";
        String idp1User2KeycloakId = this.createUser("idp1user2", "idp1user2@localhost");
        FederatedIdentityRepresentation link1_2 = new FederatedIdentityRepresentation();
        link1_2.setUserId("commonIdpUserId");
        link1_2.setUserName("idp1user2");
        this.addFederatedIdentity(idp1User2KeycloakId, "identity-provider-alias1", link1_2);
        String idp2UserUsername = "idp2user";
        String idp2UserKeycloakId = this.createUser("idp2user", "idp2user@localhost");
        FederatedIdentityRepresentation link2 = new FederatedIdentityRepresentation();
        link2.setUserId("commonIdpUserId");
        link2.setUserName("idp2user");
        this.addFederatedIdentity(idp2UserKeycloakId, "identity-provider-alias2", link2);
        List searchForAllUsers = this.managedRealm.admin().users().search(null, null, null, null, null, null, null, null, null, null, null);
        Assertions.assertEquals((int)4, (int)searchForAllUsers.size());
        List searchByIdpAlias = this.managedRealm.admin().users().search(null, null, null, null, null, "identity-provider-alias1", null, null, null, null, null);
        Assertions.assertEquals((int)2, (int)searchByIdpAlias.size());
        Assertions.assertEquals((Object)"idp1user1", (Object)((UserRepresentation)searchByIdpAlias.get(0)).getUsername());
        Assertions.assertEquals((Object)"idp1user2", (Object)((UserRepresentation)searchByIdpAlias.get(1)).getUsername());
        List searchByIdpUserId = this.managedRealm.admin().users().search(null, null, null, null, null, null, "commonIdpUserId", null, null, null, null);
        Assertions.assertEquals((int)2, (int)searchByIdpUserId.size());
        Assertions.assertEquals((Object)"idp1user2", (Object)((UserRepresentation)searchByIdpUserId.get(0)).getUsername());
        Assertions.assertEquals((Object)"idp2user", (Object)((UserRepresentation)searchByIdpUserId.get(1)).getUsername());
        List searchByIdpAliasAndUserId = this.managedRealm.admin().users().search(null, null, null, null, null, "identity-provider-alias1", "idp1user1Id", null, null, null, null);
        Assertions.assertEquals((int)1, (int)searchByIdpAliasAndUserId.size());
        Assertions.assertEquals((Object)"idp1user1", (Object)((UserRepresentation)searchByIdpAliasAndUserId.get(0)).getUsername());
    }

    @Test
    public void searchByIdpAndEnabled() {
        String identityProviderAlias = "identity-provider-alias";
        this.addSampleIdentityProvider("identity-provider-alias", 0);
        UserRepresentation disabledUser = new UserRepresentation();
        String disabledUsername = "disabled_username";
        disabledUser.setUsername("disabled_username");
        disabledUser.setEmail("disabled@localhost");
        disabledUser.setEnabled(Boolean.valueOf(false));
        String disabledUserKeycloakId = this.createUser(disabledUser);
        FederatedIdentityRepresentation disabledUserLink = new FederatedIdentityRepresentation();
        String disabledUserId = "disabledUserId";
        disabledUserLink.setUserId("disabledUserId");
        disabledUserLink.setUserName("disabled_username");
        this.addFederatedIdentity(disabledUserKeycloakId, "identity-provider-alias", disabledUserLink);
        UserRepresentation enabledUser = new UserRepresentation();
        String enabledUsername = "enabled_username";
        enabledUser.setUsername("enabled_username");
        enabledUser.setEmail("enabled@localhost");
        enabledUser.setEnabled(Boolean.valueOf(true));
        String enabledUserKeycloakId = this.createUser(enabledUser);
        FederatedIdentityRepresentation enabledUserLink = new FederatedIdentityRepresentation();
        String enabledUserId = "enabledUserId";
        enabledUserLink.setUserId("enabledUserId");
        enabledUserLink.setUserName("enabled_username");
        this.addFederatedIdentity(enabledUserKeycloakId, "identity-provider-alias", enabledUserLink);
        List searchByIdpAliasAndEnabled = this.managedRealm.admin().users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, Boolean.valueOf(true), null);
        Assertions.assertEquals((int)1, (int)searchByIdpAliasAndEnabled.size());
        Assertions.assertEquals((Object)"enabled_username", (Object)((UserRepresentation)searchByIdpAliasAndEnabled.get(0)).getUsername());
        List searchByIdpAliasAndDisabled = this.managedRealm.admin().users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, Boolean.valueOf(false), null);
        Assertions.assertEquals((int)1, (int)searchByIdpAliasAndDisabled.size());
        Assertions.assertEquals((Object)"disabled_username", (Object)((UserRepresentation)searchByIdpAliasAndDisabled.get(0)).getUsername());
        List searchByIdpAliasWithoutEnabledFlag = this.managedRealm.admin().users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, null, null);
        Assertions.assertEquals((int)2, (int)searchByIdpAliasWithoutEnabledFlag.size());
        Assertions.assertEquals((Object)"disabled_username", (Object)((UserRepresentation)searchByIdpAliasWithoutEnabledFlag.get(0)).getUsername());
        Assertions.assertEquals((Object)"enabled_username", (Object)((UserRepresentation)searchByIdpAliasWithoutEnabledFlag.get(1)).getUsername());
    }

    @Test
    public void searchById() {
        List<String> userIds = this.createUsers();
        String expectedUserId = userIds.get(0);
        List users = this.managedRealm.admin().users().search("id:" + expectedUserId, null, null);
        Assertions.assertEquals((int)1, (int)users.size());
        Assertions.assertEquals((Object)expectedUserId, (Object)((UserRepresentation)users.get(0)).getId());
        users = this.managedRealm.admin().users().search("id:   " + expectedUserId + "     ", null, null);
        Assertions.assertEquals((int)1, (int)users.size());
        Assertions.assertEquals((Object)expectedUserId, (Object)((UserRepresentation)users.get(0)).getId());
        String expectedUserId2 = userIds.get(1);
        List multipleUsers = this.managedRealm.admin().users().search(String.format("id:%s %s", expectedUserId, expectedUserId2), Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)multipleUsers, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((UserRepresentation)multipleUsers.get(0)).getId(), (Matcher)Matchers.is((Object)expectedUserId));
        MatcherAssert.assertThat((Object)((UserRepresentation)multipleUsers.get(1)).getId(), (Matcher)Matchers.is((Object)expectedUserId2));
        List multipleUsers2 = this.managedRealm.admin().users().search(String.format("id:  %s   %s  ", expectedUserId, expectedUserId2), Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat((Object)multipleUsers2, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((UserRepresentation)multipleUsers2.get(0)).getId(), (Matcher)Matchers.is((Object)expectedUserId));
        MatcherAssert.assertThat((Object)((UserRepresentation)multipleUsers2.get(1)).getId(), (Matcher)Matchers.is((Object)expectedUserId2));
    }

    @Test
    public void infixSearch() {
        List<String> userIds = this.createUsers();
        List users = this.managedRealm.admin().users().search("*1*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("*y*", null, null);
        MatcherAssert.assertThat((Object)users.size(), (Matcher)Matchers.is((Object)0));
        users = this.managedRealm.admin().users().search("*name*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("**", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("*first1*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("*last*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("*@localhost*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("*1@local*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
    }

    @Test
    public void prefixSearch() {
        List<String> userIds = this.createUsers();
        List users = this.managedRealm.admin().users().search("user", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("user*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("name", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
        users = this.managedRealm.admin().users().search("name*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
        users = this.managedRealm.admin().users().search("username1", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("username1*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search(null, null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("first1", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("first1*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("last", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("last*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
        users = this.managedRealm.admin().users().search("user1@local", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("user1@local*", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
    }

    @Test
    public void circumfixSearch() {
        this.createUsers();
        List users = this.managedRealm.admin().users().search("u*name", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void wildcardSearch() {
        UserProfileResource upResource = this.managedRealm.admin().users().userProfile();
        UPConfig upConfig = upResource.getConfiguration();
        Map prohibitedCharsOrigCfg = (Map)upConfig.getAttribute("username").getValidations().get("username-prohibited-characters");
        upConfig.getAttribute("username").getValidations().remove("username-prohibited-characters");
        upResource.update(upConfig);
        this.adminEvents.clear();
        try {
            this.createUser("0user\\\\0", "email0@emal");
            this.createUser("1user\\\\", "email1@emal");
            this.createUser("2user\\\\%", "email2@emal");
            this.createUser("3user\\\\*", "email3@emal");
            this.createUser("4user\\\\_", "email4@emal");
            MatcherAssert.assertThat((Object)this.managedRealm.admin().users().search("*", null, null), (Matcher)Matchers.hasSize((int)5));
            MatcherAssert.assertThat((Object)this.managedRealm.admin().users().search("*user\\", null, null), (Matcher)Matchers.hasSize((int)5));
            MatcherAssert.assertThat((Object)this.managedRealm.admin().users().search("\"2user\\\\%\"", null, null), (Matcher)Matchers.hasSize((int)1));
        }
        finally {
            upConfig.getAttribute("username").addValidation("username-prohibited-characters", prohibitedCharsOrigCfg);
            upResource.update(upConfig);
        }
    }

    @Test
    public void exactSearch() {
        List<String> userIds = this.createUsers();
        List users = this.managedRealm.admin().users().search("\"username1\"", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("\"user\"", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
        users = this.managedRealm.admin().users().search("\"\"", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)0));
        users = this.managedRealm.admin().users().search("\"first1\"", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
        users = this.managedRealm.admin().users().search("\"user1@localhost\"", null, null);
        MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)userIds.get(0), (Matcher)Matchers.equalTo((Object)((UserRepresentation)users.get(0)).getId()));
    }

    @Test
    public void searchWithExactMatch() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("test_username");
        user.setFirstName("test_first_name");
        user.setLastName("test_last_name");
        user.setEmail("test_email@test.com");
        user.setEnabled(Boolean.valueOf(true));
        user.setEmailVerified(Boolean.valueOf(true));
        this.createUser(user);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("test_username2");
        user2.setFirstName("test_first_name2");
        user2.setLastName("test_last_name");
        user2.setEmail("test_email@test.com2");
        user2.setEnabled(Boolean.valueOf(true));
        user2.setEmailVerified(Boolean.valueOf(true));
        this.createUser(user2);
        UserRepresentation user3 = new UserRepresentation();
        user3.setUsername("test_username3");
        user3.setFirstName("test_first_name");
        user3.setLastName("test_last_name3");
        user3.setEmail("test_email@test.com3");
        user3.setEnabled(Boolean.valueOf(true));
        user3.setEmailVerified(Boolean.valueOf(true));
        this.createUser(user3);
        List users = this.managedRealm.admin().users().search(null, null, null, "test_email@test.co", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
        users = this.managedRealm.admin().users().search(null, null, null, "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search(null, null, "test_last", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
        users = this.managedRealm.admin().users().search(null, null, "test_last_name", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search(null, "test_first", "test_last_name", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
        users = this.managedRealm.admin().users().search(null, "test_first_name", "test_last_name", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search("test_usernam", "test_first_name", "test_last_name", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)0, (int)users.size());
        users = this.managedRealm.admin().users().search("test_username", "test_first_name", "test_last_name", "test_email@test.com", Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)1, (int)users.size());
        users = this.managedRealm.admin().users().search(null, null, "test_last_name", null, Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)2, (int)users.size());
        users = this.managedRealm.admin().users().search(null, "test_first_name", null, null, Integer.valueOf(0), Integer.valueOf(10), null, null, Boolean.valueOf(true));
        Assertions.assertEquals((int)2, (int)users.size());
    }

    @Test
    public void countUsersNotServiceAccount() {
        this.createUsers();
        Integer count = this.managedRealm.admin().users().count();
        Assertions.assertEquals((int)9, (int)count);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-client");
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret("secret");
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Arrays.asList("http://url"));
        String clientId = ApiUtil.getCreatedId((Response)this.managedRealm.admin().clients().create(client));
        Assertions.assertEquals((int)9, (int)this.managedRealm.admin().users().count());
        this.managedRealm.admin().clients().get(clientId).remove();
    }

    @Test
    public void searchPaginated() {
        this.createUsers();
        List users = this.managedRealm.admin().users().search("username", Integer.valueOf(0), Integer.valueOf(1));
        Assertions.assertEquals((int)1, (int)users.size());
        Assertions.assertEquals((Object)"username1", (Object)((UserRepresentation)users.get(0)).getUsername());
        users = this.managedRealm.admin().users().search("username", Integer.valueOf(5), Integer.valueOf(2));
        Assertions.assertEquals((int)2, (int)users.size());
        Assertions.assertEquals((Object)"username6", (Object)((UserRepresentation)users.get(0)).getUsername());
        Assertions.assertEquals((Object)"username7", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.managedRealm.admin().users().search("username", Integer.valueOf(7), Integer.valueOf(20));
        Assertions.assertEquals((int)2, (int)users.size());
        Assertions.assertEquals((Object)"username8", (Object)((UserRepresentation)users.get(0)).getUsername());
        Assertions.assertEquals((Object)"username9", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.managedRealm.admin().users().search("username", Integer.valueOf(0), Integer.valueOf(20));
        Assertions.assertEquals((int)9, (int)users.size());
    }
}

