/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.user;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.credential.CredentialModel;
import org.keycloak.crypto.hash.Argon2Parameters;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.tests.admin.user.AbstractUserTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;
import org.keycloak.tests.utils.admin.ApiUtil;
import org.keycloak.testsuite.util.AccountHelper;

@KeycloakIntegrationTest
public class UserUpdateTest
extends AbstractUserTest {
    @InjectRealm(lifecycle=LifeCycle.METHOD)
    ManagedRealm managedRealm;
    @InjectOAuthClient
    OAuthClient oauth;

    @Test
    public void updateUserWithHashedCredentials() {
        UserRepresentation userRep = UserConfigBuilder.create().username("user_hashed_creds").name("Hashed", "User").email("user_hashed_creds@localhost").build();
        String userId = this.createUser(userRep);
        byte[] salt = new byte[]{-69, 85, 87, 99, 26, -107, 125, 99, -77, 30, -111, 118, 108, 100, -117, -56};
        PasswordCredentialModel credentialModel = PasswordCredentialModel.createFromValues((String)"pbkdf2-sha256", (byte[])salt, (int)27500, (String)"uskEPZWMr83pl2mzNB95SFXfIabe2UH9ClENVx/rrQqOjFEjL2aAOGpWsFNNF3qoll7Qht2mY5KxIDm3Rnve2w==");
        credentialModel.setCreatedDate(Long.valueOf(1001L));
        CredentialRepresentation hashedPassword = ModelToRepresentation.toRepresentation((CredentialModel)credentialModel);
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setCredentials(Collections.singletonList(hashedPassword));
        this.managedRealm.admin().users().get(userId).update(userRepresentation);
        this.oauth.openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.fillLogin("user_hashed_creds", "admin");
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        AccountHelper.logout((RealmResource)this.managedRealm.admin(), (String)"user_hashed_creds");
    }

    @Test
    public void updateUserWithNewUsername() {
        this.switchEditUsernameAllowedOn(true);
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        this.updateUser(user, userRep);
        userRep = this.managedRealm.admin().users().get(id).toRepresentation();
        Assertions.assertEquals((Object)"user11", (Object)userRep.getUsername());
    }

    @Test
    public void updateUserWithoutUsername() {
        this.switchEditUsernameAllowedOn(true);
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation rep = new UserRepresentation();
        rep.setFirstName("Firstname");
        user.update(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.userResourcePath((String)id), (Object)rep, (ResourceType)ResourceType.USER);
        rep = new UserRepresentation();
        rep.setLastName("Lastname");
        user.update(rep);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.userResourcePath((String)id), (Object)rep, (ResourceType)ResourceType.USER);
        rep = this.managedRealm.admin().users().get(id).toRepresentation();
        Assertions.assertEquals((Object)"user1", (Object)rep.getUsername());
        Assertions.assertEquals((Object)"user1@localhost", (Object)rep.getEmail());
        Assertions.assertEquals((Object)"Firstname", (Object)rep.getFirstName());
        Assertions.assertEquals((Object)"Lastname", (Object)rep.getLastName());
    }

    @Test
    public void updateUserWithEmailAsUsernameEditUsernameDisabled() {
        this.switchRegistrationEmailAsUsername(true);
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        Assertions.assertFalse((boolean)rep.isEditUsernameAllowed());
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getUsername());
        userRep.setEmail("user11@localhost");
        this.updateUser(user, userRep);
        userRep = this.managedRealm.admin().users().get(id).toRepresentation();
        Assertions.assertEquals((Object)"user11@localhost", (Object)userRep.getUsername());
        Assertions.assertEquals((Object)"user11@localhost", (Object)userRep.getEmail());
    }

    @Test
    public void updateUserWithEmailAsUsernameEditUsernameAllowed() {
        this.switchRegistrationEmailAsUsername(true);
        this.switchEditUsernameAllowedOn(true);
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        Assertions.assertEquals((Object)"user1@localhost", (Object)userRep.getUsername());
        userRep.setEmail("user11@localhost");
        this.updateUser(user, userRep);
        userRep = this.managedRealm.admin().users().get(id).toRepresentation();
        Assertions.assertEquals((Object)"user11@localhost", (Object)userRep.getUsername());
        Assertions.assertEquals((Object)"user11@localhost", (Object)userRep.getEmail());
    }

    @Test
    public void updateUserWithExistingEmail() {
        String userId = this.createUser();
        Assertions.assertNotNull((Object)userId);
        Assertions.assertNotNull((Object)this.createUser("user2", "user2@localhost"));
        UserResource user = this.managedRealm.admin().users().get(userId);
        UserRepresentation userRep = user.toRepresentation();
        Assertions.assertNotNull((Object)userRep);
        userRep.setEmail("user2@localhost");
        try {
            this.updateUser(user, userRep);
            Assertions.fail((String)"Expected failure - Email conflict");
        }
        catch (ClientErrorException e) {
            Assertions.assertNotNull((Object)e.getResponse());
            MatcherAssert.assertThat((Object)e.getResponse().getStatus(), (Matcher)Matchers.is((Object)409));
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"User exists with same email", (Object)error.getErrorMessage());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
    }

    @Test
    public void updateUserWithNewUsernameNotPossible() {
        RealmRepresentation realmRep = this.managedRealm.admin().toRepresentation();
        Assertions.assertFalse((boolean)realmRep.isEditUsernameAllowed());
        String id = this.createUser();
        UserResource user = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        try {
            this.updateUser(user, userRep);
            Assertions.fail((String)"Should fail because realm does not allow edit username");
        }
        catch (BadRequestException expected) {
            ErrorRepresentation error = (ErrorRepresentation)expected.getResponse().readEntity(ErrorRepresentation.class);
            Assertions.assertEquals((Object)"error-user-attribute-read-only", (Object)error.getErrorMessage());
        }
        userRep = this.managedRealm.admin().users().get(id).toRepresentation();
        Assertions.assertEquals((Object)"user1", (Object)userRep.getUsername());
    }

    @Test
    public void updateUserWithNewUsernameAccessingViaOldUsername() {
        this.switchEditUsernameAllowedOn(true);
        this.createUser();
        try {
            UserResource user = this.managedRealm.admin().users().get("user1");
            UserRepresentation userRep = user.toRepresentation();
            userRep.setUsername("user1");
            this.updateUser(user, userRep);
            this.managedRealm.admin().users().get("user11").toRepresentation();
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)404, (int)e.getResponse().getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        finally {
            this.switchEditUsernameAllowedOn(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateUserWithExistingUsername() {
        this.switchEditUsernameAllowedOn(true);
        this.enableBruteForce(true);
        this.createUser();
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user2");
        String createdId = this.createUser(userRep);
        try {
            UserResource user = this.managedRealm.admin().users().get(createdId);
            userRep = user.toRepresentation();
            userRep.setUsername("user1");
            user.update(userRep);
            Assertions.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            Assertions.assertEquals((int)409, (int)e.getResponse().getStatus());
            Assertions.assertNull((Object)this.adminEvents.poll());
        }
        finally {
            this.enableBruteForce(false);
            this.switchEditUsernameAllowedOn(false);
        }
    }

    @Test
    public void updateUserWithRawCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_rawpw");
        user.setEmail("email.raw@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Arrays.asList(rawPassword));
        String id = this.createUser(user);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials("user_rawpw"));
        Assertions.assertNotNull((Object)credential, (String)"Expecting credential");
        Assertions.assertEquals((Object)"argon2", (Object)credential.getPasswordCredentialData().getAlgorithm());
        Assertions.assertEquals((int)Argon2Parameters.DEFAULT_ITERATIONS, (int)credential.getPasswordCredentialData().getHashIterations());
        Assertions.assertNotEquals((Object)"ABCD", (Object)credential.getPasswordSecretData().getValue());
        Assertions.assertEquals((Object)"password", (Object)credential.getType());
        UserResource userResource = this.managedRealm.admin().users().get(id);
        UserRepresentation userRep = userResource.toRepresentation();
        CredentialRepresentation rawPasswordForUpdate = new CredentialRepresentation();
        rawPasswordForUpdate.setValue("EFGH");
        rawPasswordForUpdate.setType("password");
        userRep.setCredentials(Arrays.asList(rawPasswordForUpdate));
        this.updateUser(userResource, userRep);
        PasswordCredentialModel updatedCredential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials("user_rawpw"));
        Assertions.assertNotNull((Object)updatedCredential, (String)"Expecting credential");
        Assertions.assertEquals((Object)"argon2", (Object)updatedCredential.getPasswordCredentialData().getAlgorithm());
        Assertions.assertEquals((int)Argon2Parameters.DEFAULT_ITERATIONS, (int)updatedCredential.getPasswordCredentialData().getHashIterations());
        Assertions.assertNotEquals((Object)"EFGH", (Object)updatedCredential.getPasswordSecretData().getValue());
        Assertions.assertEquals((Object)"password", (Object)updatedCredential.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessUserFromOtherRealm() {
        RealmRepresentation firstRealm = new RealmRepresentation();
        firstRealm.setRealm("first-realm");
        this.adminClient.realms().create(firstRealm);
        UserRepresentation firstUser = new UserRepresentation();
        firstUser.setUsername("first");
        firstUser.setEmail("first@first-realm.org");
        firstUser.setId(ApiUtil.getCreatedId((Response)this.adminClient.realm(firstRealm.getRealm()).users().create(firstUser)));
        RealmRepresentation secondRealm = new RealmRepresentation();
        secondRealm.setRealm("second-realm");
        this.adminClient.realms().create(secondRealm);
        this.adminClient.realm(firstRealm.getRealm()).users().get(firstUser.getId()).update(firstUser);
        try {
            this.adminClient.realm(secondRealm.getRealm()).users().get(firstUser.getId()).toRepresentation();
            Assertions.fail((String)"Should not have access to firstUser from another realm");
        }
        catch (NotFoundException notFoundException) {
        }
        finally {
            this.adminClient.realm(secondRealm.getRealm()).remove();
            this.adminClient.realm(firstRealm.getRealm()).remove();
        }
    }

    private void enableBruteForce(boolean enable) {
        RealmRepresentation rep = this.managedRealm.admin().toRepresentation();
        this.managedRealm.cleanup().add(r -> r.update(rep));
        rep.setBruteForceProtected(Boolean.valueOf(enable));
        this.managedRealm.admin().update(rep);
        AdminEventAssertion.assertSuccess((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll())).operationType(OperationType.UPDATE).representation((Object)rep).resourceType(ResourceType.REALM);
    }
}

