/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.userprofile;

import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.UserProfileResource;
import org.keycloak.representations.idm.UserProfileAttributeGroupMetadata;
import org.keycloak.representations.idm.UserProfileMetadata;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.userprofile.config.UPGroup;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.JsonTestUtils;
import org.keycloak.userprofile.config.UPConfigUtils;

@KeycloakIntegrationTest
public class UserProfileAdminTest {
    @InjectRealm(lifecycle=LifeCycle.CLASS)
    private ManagedRealm realm;

    @Test
    public void testDefaultConfigIfNoneSet() {
        JsonTestUtils.assertJsonEquals((String)UPConfigUtils.readSystemDefaultConfig(), (Object)this.realm.admin().users().userProfile().getConfiguration());
    }

    @Test
    public void testSetDefaultConfig() {
        this.realm.cleanup().add(r -> r.users().userProfile().update(null));
        UPConfig config = UPConfigUtils.parseSystemDefaultConfig().addOrReplaceAttribute(new UPAttribute("test"));
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        userProfile.update(config);
        JsonTestUtils.assertJsonEquals((Object)config, (Object)userProfile.getConfiguration());
    }

    @Test
    public void testEmailRequiredIfEmailAsUsernameEnabled() {
        this.realm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.registrationEmailAsUsername(true)});
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        UserProfileMetadata metadata = userProfile.getMetadata();
        Assertions.assertTrue((boolean)metadata.getAttributeMetadata("email").isRequired());
    }

    @Test
    public void testEmailNotRequiredIfEmailAsUsernameDisabled() {
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        UserProfileMetadata metadata = userProfile.getMetadata();
        Assertions.assertFalse((boolean)metadata.getAttributeMetadata("email").isRequired());
    }

    @Test
    public void testUsernameRequiredAndWritableIfEmailAsUsernameDisabledAndEditUsernameAllowed() {
        this.realm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.editUsernameAllowed(true)});
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        UserProfileMetadata metadata = userProfile.getMetadata();
        Assertions.assertTrue((boolean)metadata.getAttributeMetadata("username").isRequired());
        Assertions.assertFalse((boolean)metadata.getAttributeMetadata("username").isReadOnly());
    }

    @Test
    public void testUsernameRequiredAndWritableIfEmailAsUsernameDisabledAndEditUsernameDisabled() {
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        UserProfileMetadata metadata = userProfile.getMetadata();
        Assertions.assertTrue((boolean)metadata.getAttributeMetadata("username").isRequired());
        Assertions.assertFalse((boolean)metadata.getAttributeMetadata("username").isReadOnly());
    }

    @Test
    public void testUsernameNotRequiredIfEmailAsUsernameEnabled() {
        this.realm.updateWithCleanup(new ManagedRealm.RealmUpdate[]{r -> r.registrationEmailAsUsername(true)});
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        UserProfileMetadata metadata = userProfile.getMetadata();
        Assertions.assertFalse((boolean)metadata.getAttributeMetadata("username").isRequired());
        Assertions.assertTrue((boolean)metadata.getAttributeMetadata("username").isReadOnly());
    }

    @Test
    public void testGroupsMetadata() {
        this.realm.cleanup().add(r -> r.users().userProfile().update(null));
        UPConfig config = this.realm.admin().users().userProfile().getConfiguration();
        for (int i = 0; i < 3; ++i) {
            UPGroup group = new UPGroup();
            group.setName("name-" + i);
            group.setDisplayHeader("displayHeader-" + i);
            group.setDisplayDescription("displayDescription-" + i);
            group.setAnnotations(Map.of("k1", "v1", "k2", "v2", "k3", "v3"));
            config.addGroup(group);
        }
        UPAttribute firstName = config.getAttribute("firstName");
        firstName.setGroup(((UPGroup)config.getGroups().get(0)).getName());
        UserProfileResource userProfile = this.realm.admin().users().userProfile();
        userProfile.update(config);
        UserProfileMetadata metadata = this.realm.admin().users().userProfile().getMetadata();
        List groups = metadata.getGroups();
        Assertions.assertNotNull((Object)groups);
        Assertions.assertFalse((boolean)groups.isEmpty());
        Assertions.assertEquals((int)config.getGroups().size(), (int)groups.size());
        for (UPGroup group : config.getGroups()) {
            UserProfileAttributeGroupMetadata mGroup = metadata.getAttributeGroupMetadata(group.getName());
            Assertions.assertNotNull((Object)mGroup);
            Assertions.assertEquals((Object)group.getName(), (Object)mGroup.getName());
            Assertions.assertEquals((Object)group.getDisplayHeader(), (Object)mGroup.getDisplayHeader());
            Assertions.assertEquals((Object)group.getDisplayDescription(), (Object)mGroup.getDisplayDescription());
            if (group.getAnnotations() == null) {
                Assertions.assertEquals((Object)group.getAnnotations(), (Object)mGroup.getAnnotations());
                continue;
            }
            Assertions.assertEquals((int)group.getAnnotations().size(), (int)mGroup.getAnnotations().size());
        }
        Assertions.assertEquals((Object)((UPGroup)config.getGroups().get(0)).getName(), (Object)metadata.getAttributeMetadata("firstName").getGroup());
    }
}

