/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.userstorage;

import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testframework.annotations.InjectAdminEvents;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.events.AdminEvents;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.tests.utils.admin.ApiUtil;

public class AbstractUserStorageRestTest {
    @InjectRealm
    ManagedRealm managedRealm;
    @InjectAdminEvents
    AdminEvents adminEvents;

    protected String createComponent(ComponentRepresentation rep) {
        Response resp = this.managedRealm.admin().components().add(rep);
        Assertions.assertEquals((int)201, (int)resp.getStatus());
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        this.adminEvents.clear();
        return id;
    }

    protected void removeComponent(String id) {
        this.managedRealm.admin().components().component(id).remove();
        this.adminEvents.clear();
    }

    protected ComponentRepresentation createBasicLDAPProviderRep() {
        ComponentRepresentation ldapRep = new ComponentRepresentation();
        ldapRep.setName("ldap2");
        ldapRep.setProviderId("ldap");
        ldapRep.setProviderType(UserStorageProvider.class.getName());
        ldapRep.setConfig(new MultivaluedHashMap());
        ldapRep.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.name());
        return ldapRep;
    }
}

