/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.userstorage;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.events.AdminEventAssertion;
import org.keycloak.tests.admin.userstorage.AbstractUserStorageRestTest;
import org.keycloak.tests.utils.admin.AdminEventPaths;

@KeycloakIntegrationTest
public class UserStorageKerberosRestTest
extends AbstractUserStorageRestTest {
    @Test
    public void testKerberosAuthenticatorEnabledAutomatically() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.managedRealm.admin().flows().updateExecutions("browser", kerberosExecution);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"browser"), (Object)kerberosExecution, (ResourceType)ResourceType.AUTH_EXECUTION);
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.adminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"false");
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.adminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.adminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.managedRealm.admin().flows().updateExecutions("browser", kerberosExecution);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"browser"), (Object)kerberosExecution, (ResourceType)ResourceType.AUTH_EXECUTION);
        this.removeComponent(id);
    }

    @Test
    public void testKerberosAuthenticatorChangedOnlyIfDisabled() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        this.managedRealm.admin().flows().updateExecutions("browser", kerberosExecution);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"browser"), (Object)kerberosExecution, (ResourceType)ResourceType.AUTH_EXECUTION);
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.adminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.managedRealm.admin().flows().updateExecutions("browser", kerberosExecution);
        AdminEventAssertion.assertEvent((AdminEventRepresentation)((AdminEventRepresentation)this.adminEvents.poll()), (OperationType)OperationType.UPDATE, (String)AdminEventPaths.authUpdateExecutionPath((String)"browser"), (Object)kerberosExecution, (ResourceType)ResourceType.AUTH_EXECUTION);
        this.removeComponent(id);
    }

    @Test
    public void testKerberosAuthenticatorDisabledWhenProviderRemoved() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        this.managedRealm.admin().components().component(id).remove();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation kerberosRep = new ComponentRepresentation();
        kerberosRep.setName("kerberos");
        kerberosRep.setProviderId("kerberos");
        kerberosRep.setProviderType(UserStorageProvider.class.getName());
        kerberosRep.setConfig(new MultivaluedHashMap());
        kerberosRep.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        id = this.createComponent(kerberosRep);
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        this.managedRealm.admin().flows().updateExecutions("browser", kerberosExecution);
        this.managedRealm.admin().components().component(id).remove();
        kerberosExecution = this.findKerberosExecution();
        Assertions.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
    }

    private AuthenticationExecutionInfoRepresentation findKerberosExecution() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = null;
        List executionReps = this.managedRealm.admin().flows().getExecutions("browser");
        kerberosExecution = UserStorageKerberosRestTest.findExecutionByProvider("auth-spnego", executionReps);
        Assertions.assertNotNull((Object)kerberosExecution);
        return kerberosExecution;
    }

    private static AuthenticationExecutionInfoRepresentation findExecutionByProvider(String provider, List<AuthenticationExecutionInfoRepresentation> executions) {
        for (AuthenticationExecutionInfoRepresentation exec : executions) {
            if (!provider.equals(exec.getProviderId())) continue;
            return exec;
        }
        return null;
    }
}

