/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.admin.userstorage;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.tests.admin.userstorage.AbstractUserStorageRestTest;
import org.keycloak.tests.utils.Assert;

@KeycloakIntegrationTest
public class UserStorageRestTest
extends AbstractUserStorageRestTest {
    @Test
    public void testValidateAndCreateLdapProviderCustomSearchFilter() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"dc=something");
        Response resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something");
        resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"dc=something)");
        resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        Assertions.assertTrue((boolean)this.managedRealm.admin().components().query(this.managedRealm.getId(), UserStorageProvider.class.getName()).isEmpty());
        Assertions.assertNull((Object)this.adminEvents.poll());
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something)");
        String id1 = this.createComponent(ldapRep);
        ComponentRepresentation ldapRep2 = new ComponentRepresentation();
        ldapRep2.setName("ldap3");
        ldapRep2.setProviderId("ldap");
        ldapRep2.setProviderType(UserStorageProvider.class.getName());
        ldapRep2.setConfig(new MultivaluedHashMap());
        ldapRep2.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        ldapRep2.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.name());
        ldapRep2.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager");
        ldapRep2.getConfig().putSingle((Object)"bindCredential", (Object)"password");
        String id2 = this.createComponent(ldapRep2);
        List providerInstances = this.managedRealm.admin().components().query(this.managedRealm.getId(), UserStorageProvider.class.getName());
        Assertions.assertEquals((int)providerInstances.size(), (int)2);
        this.removeComponent(id1);
        this.removeComponent(id2);
    }

    @Test
    public void testValidateAndCreateLdapProviderEditMode() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().remove((Object)"editMode");
        Response resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.READ_ONLY.name());
        ldapRep.getConfig().putSingle((Object)"validatePasswordPolicy", (Object)"true");
        resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.name());
        ldapRep.getConfig().putSingle((Object)"validatePasswordPolicy", (Object)"true");
        resp = this.managedRealm.admin().components().add(ldapRep);
        Assertions.assertEquals((int)400, (int)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.name());
        ldapRep.getConfig().putSingle((Object)"syncRegistrations", (Object)"true");
        String id1 = this.createComponent(ldapRep);
        this.removeComponent(id1);
    }

    @Test
    public void testUpdateProvider() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager");
        ldapRep.getConfig().putSingle((Object)"bindCredential", (Object)"password");
        String id = this.createComponent(ldapRep);
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something2");
        ldapRep.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager-updated");
        try {
            this.managedRealm.admin().components().component(id).update(ldapRep);
            Assertions.fail((String)"Not expected to successfull update");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        this.assertFederationProvider(this.managedRealm.admin().components().component(id).toRepresentation(), id, "ldap2", "ldap", "bindDn", "cn=manager", "bindCredential", "**********");
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something2)");
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.adminEvents.clear();
        ldapRep = this.managedRealm.admin().components().component(id).toRepresentation();
        this.assertFederationProvider(ldapRep, id, "ldap2", "ldap", "bindDn", "cn=manager-updated", "bindCredential", "**********", "customUserSearchFilter", "(dc=something2)");
        ldapRep.setName("ldap2");
        this.managedRealm.admin().components().component(id).update(ldapRep);
        this.assertFederationProvider(this.managedRealm.admin().components().component(id).toRepresentation(), id, "ldap2", "ldap", "bindDn", "cn=manager-updated", "bindCredential", "**********", "customUserSearchFilter", "(dc=something2)");
        this.removeComponent(id);
    }

    @Test
    public void testLDAPMapperProviderConfigurationForVendorOther() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"vendor", (Object)"other");
        String ldapModelId = this.createComponent(ldapRep);
        ComponentTypeRepresentation groupLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "group-ldap-mapper");
        ConfigPropertyRepresentation groupRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(groupLDAPMapperType, "user.roles.retrieve.strategy");
        List options = groupRetrieverConfigProperty.getOptions();
        Assert.assertNames((List)options, (String[])new String[]{"LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE"});
        Assertions.assertFalse((boolean)groupRetrieverConfigProperty.getHelpText().contains("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        ComponentTypeRepresentation roleLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "role-ldap-mapper");
        ConfigPropertyRepresentation roleRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(roleLDAPMapperType, "user.roles.retrieve.strategy");
        options = roleRetrieverConfigProperty.getOptions();
        Assert.assertNames((List)options, (String[])new String[]{"LOAD_ROLES_BY_MEMBER_ATTRIBUTE", "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE"});
        Assertions.assertFalse((boolean)roleRetrieverConfigProperty.getHelpText().contains("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        this.removeComponent(ldapModelId);
    }

    @Test
    public void testLDAPMapperProviderConfigurationForVendorMSAD() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"vendor", (Object)"ad");
        String ldapModelId = this.createComponent(ldapRep);
        ComponentTypeRepresentation groupLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "group-ldap-mapper");
        ConfigPropertyRepresentation groupRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(groupLDAPMapperType, "user.roles.retrieve.strategy");
        List options = groupRetrieverConfigProperty.getOptions();
        Assert.assertNames((List)options, (String[])new String[]{"LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE", "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY"});
        Assertions.assertTrue((boolean)groupRetrieverConfigProperty.getHelpText().contains("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        ComponentTypeRepresentation roleLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "role-ldap-mapper");
        ConfigPropertyRepresentation roleRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(roleLDAPMapperType, "user.roles.retrieve.strategy");
        options = roleRetrieverConfigProperty.getOptions();
        Assert.assertNames((List)options, (String[])new String[]{"LOAD_ROLES_BY_MEMBER_ATTRIBUTE", "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE", "LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY"});
        Assertions.assertTrue((boolean)roleRetrieverConfigProperty.getHelpText().contains("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        this.removeComponent(ldapModelId);
    }

    private void assertFederationProvider(ComponentRepresentation rep, String id, String displayName, String providerId, String ... config) {
        Assertions.assertEquals((Object)id, (Object)rep.getId());
        Assertions.assertEquals((Object)displayName, (Object)rep.getName());
        Assertions.assertEquals((Object)providerId, (Object)rep.getProviderId());
        Assert.assertMultivaluedMap((MultivaluedHashMap)rep.getConfig(), (String[])config);
    }

    private ComponentTypeRepresentation findMapperTypeConfiguration(String ldapModelId, String mapperProviderId) {
        ComponentResource ldapProvider = this.managedRealm.admin().components().component(ldapModelId);
        List componentTypes = ldapProvider.getSubcomponentConfig(LDAPStorageMapper.class.getName());
        return componentTypes.stream().filter(componentType -> mapperProviderId.equals(componentType.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Not able to find mapper with provider id: " + mapperProviderId));
    }

    private ConfigPropertyRepresentation getUserRolesRetrieveStrategyConfigProperty(ComponentTypeRepresentation componentType, String propertyName) {
        return componentType.getProperties().stream().filter(configPropertyRep -> propertyName.equals(configPropertyRep.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Not able to find config property with name: " + propertyName));
    }
}

