/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testframework.annotations.InjectEvents;
import org.keycloak.testframework.events.EventAssertion;
import org.keycloak.testframework.events.Events;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.OAuthIdentityProvider;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.ClientCredentialsGrantRequest;

public abstract class AbstractFederatedClientAuthTest {
    private final String expectedTokenIssuer;
    private final String internalClientId;
    private final String externalClientId;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectEvents
    Events events;

    public AbstractFederatedClientAuthTest(String expectedTokenIssuer, String internalClientId, String externalClientId) {
        this.expectedTokenIssuer = expectedTokenIssuer;
        this.internalClientId = internalClientId;
        this.externalClientId = externalClientId;
    }

    @Test
    public void testValidToken() {
        JsonWebToken token = this.createDefaultToken();
        this.assertSuccess(this.internalClientId, this.doClientGrant(token));
        this.assertSuccess(this.internalClientId, token.getId(), this.expectedTokenIssuer, this.externalClientId, (EventRepresentation)this.events.poll());
    }

    @Test
    public void testInvalidSignature() {
        OAuthIdentityProvider.OAuthIdentityProviderKeys keys = this.getIdentityProvider().createKeys();
        JsonWebToken jwt = this.createDefaultToken();
        String jws = this.getIdentityProvider().encodeToken(jwt, keys);
        this.assertFailure("Invalid client or Invalid client credentials", this.doClientGrant(jws));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testInvalidSub() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.subject("invalid");
        Assertions.assertFalse((boolean)this.doClientGrant(jwt).isSuccess());
        this.assertFailure(null, this.expectedTokenIssuer, "invalid", jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    @Test
    public void testExpired() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.exp(Long.valueOf(Time.currentTime() - 30));
        this.assertFailure("Token is not active", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testMissingExp() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.exp(null);
        this.assertFailure("Token exp claim is required", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testInvalidNbf() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.nbf(Long.valueOf(Time.currentTime() + 60));
        this.assertFailure("Token is not active", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testInvalidAud() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.audience(new String[]{"invalid"});
        this.assertFailure("Invalid token audience", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testMissingAud() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.audience(new String[]{null});
        this.assertFailure("Invalid token audience", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testMultipleAud() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.audience(new String[]{jwt.getAudience()[0], "invalid"});
        this.assertFailure("Multiple audiences not allowed", this.doClientGrant(jwt));
        this.assertFailure(this.internalClientId, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testValidInvalidAssertionType() {
        JsonWebToken jwt = this.createDefaultToken();
        String jws = this.getIdentityProvider().encodeToken(jwt);
        AccessTokenResponse response = (AccessTokenResponse)((ClientCredentialsGrantRequest)this.oAuthClient.clientCredentialsGrantRequest().clientJwt(jws, "urn:ietf:params:oauth:client-assertion-type:invalid")).send();
        this.assertFailure(response);
        this.assertFailure(null, this.expectedTokenIssuer, this.externalClientId, jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    protected abstract OAuthIdentityProvider getIdentityProvider();

    protected abstract JsonWebToken createDefaultToken();

    protected AccessTokenResponse doClientGrant(JsonWebToken token) {
        String jws = this.getIdentityProvider().encodeToken(token);
        return this.doClientGrant(jws);
    }

    protected AccessTokenResponse doClientGrant(String jws) {
        AccessTokenResponse response = (AccessTokenResponse)((ClientCredentialsGrantRequest)this.oAuthClient.clientCredentialsGrantRequest().clientJwt(jws, this.getClientAssertionType())).send();
        return response;
    }

    protected void assertSuccess(String expectedClientId, AccessTokenResponse response) {
        Assertions.assertTrue((boolean)response.isSuccess());
        AccessToken accessToken = (AccessToken)this.oAuthClient.parseToken(response.getAccessToken(), AccessToken.class);
        Assertions.assertEquals((Object)expectedClientId, (Object)accessToken.getIssuedFor());
    }

    protected void assertSuccess(String expectedClientId, String expectedAssertionId, String expectedAssertionIssuer, String expectedAssertionSub, EventRepresentation event) {
        EventAssertion.assertSuccess((EventRepresentation)event).type(EventType.CLIENT_LOGIN).clientId(expectedClientId).details("client_assertion_id", expectedAssertionId).details("client_assertion_issuer", expectedAssertionIssuer).details("client_assertion_sub", expectedAssertionSub).details("client_auth_method", "federated-jwt").details("grant_type", "client_credentials").details("username", "service-account-" + expectedClientId);
    }

    protected void assertFailure(AccessTokenResponse response) {
        this.assertFailure("Invalid client or Invalid client credentials", response);
    }

    protected void assertFailure(String expectedErrorDescription, AccessTokenResponse response) {
        Assertions.assertFalse((boolean)response.isSuccess());
        Assertions.assertEquals((Object)"invalid_client", (Object)response.getError());
        Assertions.assertEquals((Object)expectedErrorDescription, (Object)response.getErrorDescription());
    }

    protected void assertFailure(String expectedClientId, String expectedAssertionIssuer, String expectedAssertionSub, String expectedAssertionId, EventRepresentation event) {
        this.assertFailure(expectedClientId, expectedAssertionIssuer, expectedAssertionSub, expectedAssertionId, "invalid_client_credentials", event);
    }

    protected void assertFailure(String expectedClientId, String expectedAssertionIssuer, String expectedAssertionSub, String expectedAssertionId, String expectedError, EventRepresentation event) {
        EventAssertion.assertError((EventRepresentation)event).type(EventType.CLIENT_LOGIN_ERROR).clientId(expectedClientId).error(expectedError).details("client_assertion_id", expectedAssertionId).details("client_assertion_issuer", expectedAssertionIssuer).details("client_assertion_sub", expectedAssertionSub).details("grant_type", "client_credentials");
    }

    protected String getClientAssertionType() {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    }
}

