/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ClientConfig;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.client.authentication.external.ClientAuthIdpServerConfig;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.ClientCredentialsGrantRequest;

@KeycloakIntegrationTest(config=ClientAuthIdpServerConfig.class)
public class FederatedClientAuthFromKeycloakTest {
    private static final String IDP_ALIAS = "keycloak-idp";
    @InjectRealm(config=InternalRealmConfig.class)
    ManagedRealm internalRealm;
    @InjectRealm(ref="external")
    ManagedRealm externalRealm;
    @InjectOAuthClient
    OAuthClient internalOAuthClient;
    @InjectOAuthClient(ref="external", realmRef="external", config=ExternalClientConfig.class)
    OAuthClient externalOAuthClient;

    @Test
    public void testValidToken() {
        String externalClientAssertion = this.externalOAuthClient.doClientCredentialsGrantAccessTokenRequest().getAccessToken();
        AccessTokenResponse send = (AccessTokenResponse)((ClientCredentialsGrantRequest)this.internalOAuthClient.clientCredentialsGrantRequest().clientJwt(externalClientAssertion)).send();
        Assertions.assertTrue((boolean)send.isSuccess());
    }

    public static class ExternalClientConfig
    implements ClientConfig {
        public ClientConfigBuilder configure(ClientConfigBuilder client) {
            ProtocolMapperRepresentation subMapper = new ProtocolMapperRepresentation();
            subMapper.setName("fixed-sub");
            subMapper.setProtocol("openid-connect");
            subMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
            subMapper.getConfig().put("claim.name", "sub");
            subMapper.getConfig().put("claim.value", "myclient");
            subMapper.getConfig().put("access.token.claim", "true");
            ProtocolMapperRepresentation audMapper = new ProtocolMapperRepresentation();
            audMapper.setName("fixed-audience");
            audMapper.setProtocol("openid-connect");
            audMapper.setProtocolMapper("oidc-audience-mapper");
            audMapper.getConfig().put("included.custom.audience", "http://localhost:8080/realms/default");
            audMapper.getConfig().put("access.token.claim", "true");
            return client.clientId("myclient").defaultClientScopes(new String[0]).serviceAccountsEnabled(true).secret("mysecret").protocolMappers(List.of(subMapper, audMapper));
        }
    }

    public static class InternalRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.identityProvider(IdentityProviderBuilder.create().providerId("oidc").alias(FederatedClientAuthFromKeycloakTest.IDP_ALIAS).setAttribute("issuer", "http://localhost:8080/realms/external").setAttribute("supportsClientAssertions", "true").setAttribute("useJwksUrl", "true").setAttribute("jwksUrl", "http://localhost:8080/realms/external/protocol/openid-connect/certs").setAttribute("validateSignature", "true").build());
            realm.addClient("myclient").serviceAccountsEnabled(true).authenticatorType("federated-jwt").attribute("jwt.credential.issuer", FederatedClientAuthFromKeycloakTest.IDP_ALIAS).attribute("jwt.credential.sub", "myclient");
            return realm;
        }
    }
}

