/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.OAuthIdentityProvider;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthIdentityProvider;
import org.keycloak.testframework.realm.ClientConfigBuilder;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.client.authentication.external.ClientAuthIdpServerConfig;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.ClientCredentialsGrantRequest;

@KeycloakIntegrationTest(config=ClientAuthIdpServerConfig.class)
public class FederatedClientAuthMappingTest {
    private static final String IDP_ALIAS = "external-idp";
    @InjectRealm(config=ExernalClientAuthRealmConfig.class)
    protected ManagedRealm realm;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectOAuthIdentityProvider
    OAuthIdentityProvider identityProvider;

    @Test
    public void testSimple() {
        Assertions.assertTrue((boolean)this.doClientGrant(this.createDefaultToken("external-simple-1"), "internal-simple-1"));
        Assertions.assertTrue((boolean)this.doClientGrant(this.createDefaultToken("external-simple-2"), "internal-simple-2"));
    }

    @Test
    public void testUrn() {
        Assertions.assertTrue((boolean)this.doClientGrant(this.createDefaultToken("spiffe://client/urn"), "internal-urn"));
    }

    @Test
    public void testUri() {
        Assertions.assertTrue((boolean)this.doClientGrant(this.createDefaultToken("bf4c696e-89dc-4e40-a833-90fa5f8786e0"), "internal-uuid"));
    }

    @Test
    public void testDuplicatedExternal() {
        Assertions.assertFalse((boolean)this.doClientGrant(this.createDefaultToken("external-duplicated"), null));
    }

    private boolean doClientGrant(JsonWebToken token, String expectedInternalClientId) {
        String jws = this.identityProvider.encodeToken(token);
        AccessTokenResponse response = (AccessTokenResponse)((ClientCredentialsGrantRequest)this.oAuthClient.clientCredentialsGrantRequest().clientJwt(jws)).send();
        if (response.isSuccess()) {
            AccessToken accessToken = (AccessToken)this.oAuthClient.parseToken(response.getAccessToken(), AccessToken.class);
            Assertions.assertEquals((Object)expectedInternalClientId, (Object)accessToken.getIssuedFor());
        }
        return response.isSuccess();
    }

    private JsonWebToken createDefaultToken(String externalClientId) {
        JsonWebToken token = new JsonWebToken();
        token.id(UUID.randomUUID().toString());
        token.issuer("http://127.0.0.1:8500");
        token.audience(new String[]{this.oAuthClient.getEndpoints().getIssuer()});
        token.iat(Long.valueOf(Time.currentTime()));
        token.exp(Long.valueOf(Time.currentTime() + 300));
        token.subject(externalClientId);
        return token;
    }

    public static class ExernalClientAuthRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.identityProvider(IdentityProviderBuilder.create().providerId("oidc").alias(FederatedClientAuthMappingTest.IDP_ALIAS).setAttribute("issuer", "http://127.0.0.1:8500").setAttribute("useJwksUrl", "true").setAttribute("jwksUrl", "http://127.0.0.1:8500/idp/jwks").setAttribute("validateSignature", "true").setAttribute("supportsClientAssertions", "true").build());
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-simple-1"), "external-simple-1");
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-simple-2"), "external-simple-2");
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-urn"), "spiffe://client/urn");
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-uuid"), "bf4c696e-89dc-4e40-a833-90fa5f8786e0");
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-duplicated-1"), "external-duplicated");
            ExernalClientAuthRealmConfig.createClient(realm.addClient("internal-duplicated-2"), "external-duplicated");
            return realm;
        }

        private static void createClient(ClientConfigBuilder client, String externalId) {
            client.serviceAccountsEnabled(true).authenticatorType("federated-jwt").attribute("jwt.credential.issuer", FederatedClientAuthMappingTest.IDP_ALIAS).attribute("jwt.credential.sub", externalId);
        }
    }
}

