/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.keycloak.common.util.Time;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthIdentityProvider;
import org.keycloak.testframework.oauth.annotations.InjectOAuthIdentityProvider;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.tests.client.authentication.external.AbstractFederatedClientAuthTest;
import org.keycloak.tests.client.authentication.external.ClientAuthIdpServerConfig;
import org.keycloak.testsuite.util.IdentityProviderBuilder;

@KeycloakIntegrationTest(config=ClientAuthIdpServerConfig.class)
public class FederatedClientAuthTest
extends AbstractFederatedClientAuthTest {
    private static final String IDP_ALIAS = "external-idp";
    private static final String TOKEN_ISSUER = "http://127.0.0.1:8500";
    private static final String INTERNAL_CLIENT_ID = "internal-myclient";
    private static final String EXTERNAL_CLIENT_ID = "external-myclient";
    @InjectRealm(config=ExernalClientAuthRealmConfig.class)
    protected ManagedRealm realm;
    @InjectOAuthIdentityProvider
    OAuthIdentityProvider identityProvider;

    public FederatedClientAuthTest() {
        super(TOKEN_ISSUER, INTERNAL_CLIENT_ID, EXTERNAL_CLIENT_ID);
    }

    @Test
    public void testInvalidIssuer() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.issuer("http://invalid");
        this.assertFailure("Invalid client or Invalid client credentials", this.doClientGrant(jwt));
        this.assertFailure(null, "http://invalid", jwt.getSubject(), jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    @Test
    public void testMissingIssuer() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.issuer(null);
        Assertions.assertFalse((boolean)this.doClientGrant(jwt).isSuccess());
        this.assertFailure(null, null, jwt.getSubject(), jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    @Test
    public void testMissingJti() {
        JsonWebToken jwt = this.createDefaultToken();
        jwt.id(null);
        Assertions.assertFalse((boolean)this.doClientGrant(jwt).isSuccess());
        this.assertFailure(INTERNAL_CLIENT_ID, TOKEN_ISSUER, jwt.getSubject(), jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testReuseNotPermitted() {
        JsonWebToken jwt = this.createDefaultToken();
        this.assertSuccess(INTERNAL_CLIENT_ID, this.doClientGrant(jwt));
        this.assertSuccess(INTERNAL_CLIENT_ID, jwt.getId(), TOKEN_ISSUER, EXTERNAL_CLIENT_ID, (EventRepresentation)this.events.poll());
        this.assertFailure("Token reuse detected", this.doClientGrant(jwt));
        this.assertFailure(INTERNAL_CLIENT_ID, TOKEN_ISSUER, EXTERNAL_CLIENT_ID, jwt.getId(), (EventRepresentation)this.events.poll());
    }

    @Test
    public void testReusePermitted() {
        this.realm.updateIdentityProviderWithCleanup(IDP_ALIAS, rep -> rep.getConfig().put("supportsClientAssertionReuse", "true"));
        JsonWebToken jwt = this.createDefaultToken();
        this.assertSuccess(INTERNAL_CLIENT_ID, this.doClientGrant(jwt));
        this.assertSuccess(INTERNAL_CLIENT_ID, jwt.getId(), TOKEN_ISSUER, EXTERNAL_CLIENT_ID, (EventRepresentation)this.events.poll());
        this.assertSuccess(INTERNAL_CLIENT_ID, this.doClientGrant(jwt));
        this.assertSuccess(INTERNAL_CLIENT_ID, jwt.getId(), TOKEN_ISSUER, EXTERNAL_CLIENT_ID, (EventRepresentation)this.events.poll());
    }

    @Test
    public void testClientAssertionsNotSupported() {
        this.realm.updateIdentityProviderWithCleanup(IDP_ALIAS, rep -> rep.getConfig().remove("supportsClientAssertions"));
        JsonWebToken jwt = this.createDefaultToken();
        this.assertFailure(this.doClientGrant(jwt));
        this.assertFailure(null, TOKEN_ISSUER, EXTERNAL_CLIENT_ID, jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    @Override
    protected OAuthIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    protected JsonWebToken createDefaultToken() {
        JsonWebToken token = new JsonWebToken();
        token.id(UUID.randomUUID().toString());
        token.issuer(TOKEN_ISSUER);
        token.audience(new String[]{this.oAuthClient.getEndpoints().getIssuer()});
        token.iat(Long.valueOf(Time.currentTime()));
        token.exp(Long.valueOf(Time.currentTime() + 300));
        token.subject(EXTERNAL_CLIENT_ID);
        return token;
    }

    public static class ExernalClientAuthRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.identityProvider(IdentityProviderBuilder.create().providerId("oidc").alias(FederatedClientAuthTest.IDP_ALIAS).setAttribute("issuer", FederatedClientAuthTest.TOKEN_ISSUER).setAttribute("useJwksUrl", "true").setAttribute("jwksUrl", "http://127.0.0.1:8500/idp/jwks").setAttribute("validateSignature", "true").setAttribute("supportsClientAssertions", "true").build());
            realm.addClient(FederatedClientAuthTest.INTERNAL_CLIENT_ID).serviceAccountsEnabled(true).authenticatorType("federated-jwt").attribute("jwt.credential.issuer", FederatedClientAuthTest.IDP_ALIAS).attribute("jwt.credential.sub", FederatedClientAuthTest.EXTERNAL_CLIENT_ID);
            return realm;
        }
    }
}

