/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthIdentityProvider;
import org.keycloak.testframework.oauth.OAuthIdentityProviderConfig;
import org.keycloak.testframework.oauth.OAuthIdentityProviderConfigBuilder;
import org.keycloak.testframework.oauth.annotations.InjectOAuthIdentityProvider;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.RealmConfig;
import org.keycloak.testframework.realm.RealmConfigBuilder;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.client.authentication.external.AbstractFederatedClientAuthTest;
import org.keycloak.tests.client.authentication.external.ClientAuthIdpServerConfig;
import org.keycloak.testsuite.util.IdentityProviderBuilder;

@KeycloakIntegrationTest(config=SpiffeServerConfig.class)
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class SpiffeClientAuthTest
extends AbstractFederatedClientAuthTest {
    private static final String INTERNAL_CLIENT_ID = "myclient";
    private static final String EXTERNAL_CLIENT_ID = "spiffe://mytrust-domain/myclient";
    private static final String IDP_ALIAS = "spiffe-idp";
    private static final String TRUST_DOMAIN = "spiffe://mytrust-domain";
    private static final String BUNDLE_ENDPOINT = "http://127.0.0.1:8500/idp/jwks";
    @InjectRealm(config=ExernalClientAuthRealmConfig.class)
    protected ManagedRealm realm;
    @InjectOAuthIdentityProvider(config=SpiffeIdpConfig.class)
    OAuthIdentityProvider identityProvider;

    public SpiffeClientAuthTest() {
        super(null, INTERNAL_CLIENT_ID, EXTERNAL_CLIENT_ID);
    }

    @Test
    public void testInvalidTrustDomain() {
        this.realm.updateIdentityProviderWithCleanup(IDP_ALIAS, rep -> rep.getConfig().put("issuer", "spiffe://different-domain"));
        JsonWebToken jwt = this.createDefaultToken();
        this.assertFailure(this.doClientGrant(jwt));
        this.assertFailure(null, null, jwt.getSubject(), jwt.getId(), "client_not_found", (EventRepresentation)this.events.poll());
    }

    @Test
    public void testReuse() {
        JsonWebToken jwt = this.createDefaultToken();
        this.assertSuccess(INTERNAL_CLIENT_ID, this.doClientGrant(jwt));
        this.assertSuccess(INTERNAL_CLIENT_ID, jwt.getId(), null, EXTERNAL_CLIENT_ID, (EventRepresentation)this.events.poll());
        this.assertSuccess(INTERNAL_CLIENT_ID, this.doClientGrant(jwt));
        this.assertSuccess(INTERNAL_CLIENT_ID, jwt.getId(), null, EXTERNAL_CLIENT_ID, (EventRepresentation)this.events.poll());
    }

    @Override
    protected OAuthIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    @Override
    protected JsonWebToken createDefaultToken() {
        JsonWebToken token = new JsonWebToken();
        token.id(null);
        token.audience(new String[]{this.oAuthClient.getEndpoints().getIssuer()});
        token.exp(Long.valueOf(Time.currentTime() + 300));
        token.subject(EXTERNAL_CLIENT_ID);
        return token;
    }

    @Override
    protected String getClientAssertionType() {
        return "urn:ietf:params:oauth:client-assertion-type:jwt-spiffe";
    }

    public static class ExernalClientAuthRealmConfig
    implements RealmConfig {
        public RealmConfigBuilder configure(RealmConfigBuilder realm) {
            realm.identityProvider(IdentityProviderBuilder.create().providerId("spiffe").alias(SpiffeClientAuthTest.IDP_ALIAS).setAttribute("issuer", SpiffeClientAuthTest.TRUST_DOMAIN).setAttribute("bundleEndpoint", SpiffeClientAuthTest.BUNDLE_ENDPOINT).build());
            realm.addClient(SpiffeClientAuthTest.INTERNAL_CLIENT_ID).serviceAccountsEnabled(true).authenticatorType("federated-jwt").attribute("jwt.credential.issuer", SpiffeClientAuthTest.IDP_ALIAS).attribute("jwt.credential.sub", SpiffeClientAuthTest.EXTERNAL_CLIENT_ID);
            return realm;
        }
    }

    public static class SpiffeIdpConfig
    implements OAuthIdentityProviderConfig {
        public OAuthIdentityProviderConfigBuilder configure(OAuthIdentityProviderConfigBuilder config) {
            return config.spiffe();
        }
    }

    public static class SpiffeServerConfig
    extends ClientAuthIdpServerConfig {
        @Override
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return super.configure(config).features(new Profile.Feature[]{Profile.Feature.SPIFFE});
        }
    }
}

