/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.client.authentication.external;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.resource.IdentityProvidersResource;
import org.keycloak.http.simple.SimpleHttp;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.IdentityProviderShowInAccountConsole;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectSimpleHttp;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.remote.providers.runonserver.RunOnServer;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.tests.client.authentication.external.SpiffeClientAuthTest;
import org.keycloak.tests.common.BasicUserConfig;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.openqa.selenium.NoSuchElementException;

@KeycloakIntegrationTest(config=SpiffeClientAuthTest.SpiffeServerConfig.class)
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class SpiffeConfigTest {
    @InjectRealm
    ManagedRealm realm;
    @InjectUser(config=BasicUserConfig.class)
    ManagedUser user;
    @InjectRunOnServer
    RunOnServerClient runOnServer;
    @InjectSimpleHttp
    SimpleHttp simpleHttp;
    @InjectOAuthClient
    OAuthClient oAuthClient;
    @InjectPage
    LoginPage loginPage;

    @Test
    public void testConfig() throws IOException {
        IdentityProvidersResource idps = this.realm.admin().identityProviders();
        IdentityProviderRepresentation rep = this.createConfig("testConfig", "spiffe://test", "https://localhost");
        Assertions.assertEquals((int)201, (int)idps.create(rep).getStatus());
        this.checkNotDisplayOnLoginPages("testConfig");
        this.checkNoIdpsInAccountConsole();
        rep = this.realm.admin().identityProviders().get("testConfig").toRepresentation();
        Assertions.assertTrue((boolean)rep.isHideOnLogin());
        Assertions.assertEquals((Object)IdentityProviderShowInAccountConsole.NEVER.name(), rep.getConfig().get("showInAccountConsole"));
        this.runOnServer.run((RunOnServer & Serializable)s -> {
            IdentityProviderModel idp = ((IdentityProviderStorageProvider)s.getProvider(IdentityProviderStorageProvider.class, "jpa")).getByAlias("testConfig");
            Assertions.assertTrue((boolean)idp.isHideOnLogin());
            Assertions.assertEquals((Object)IdentityProviderShowInAccountConsole.NEVER.name(), idp.getConfig().get("showInAccountConsole"));
        });
    }

    @Test
    public void testInvalidConfig() {
        this.testInvalidConfig("testInvalidConfig1", "with-port:8080", "https://localhost");
        this.testInvalidConfig("testInvalidConfig2", "without-spiffe-scheme", "https://localhost");
        this.testInvalidConfig("testInvalidConfig3", "spiffe://valid", "invalid-url");
    }

    private void checkNotDisplayOnLoginPages(String alias) {
        this.oAuthClient.openLoginForm();
        Assertions.assertThrows(NoSuchElementException.class, () -> this.loginPage.findSocialButton(alias));
    }

    private void checkNoIdpsInAccountConsole() throws IOException {
        String accessToken = ((AccessTokenResponse)this.oAuthClient.passwordGrantRequest(this.user.getUsername(), this.user.getPassword()).send()).getAccessToken();
        String accountUrl = this.realm.getBaseUrl() + "/account//linked-accounts";
        JsonNode json = this.simpleHttp.doGet(accountUrl).auth(accessToken).asJson();
        Assertions.assertEquals((int)0, (int)json.size());
    }

    private void testInvalidConfig(String alias, String trustDomain, String bundleEndpoint) {
        IdentityProviderRepresentation idp = this.createConfig(alias, trustDomain, bundleEndpoint);
        try (Response r = this.realm.admin().identityProviders().create(idp);){
            Assertions.assertEquals((int)400, (int)r.getStatus());
        }
    }

    private IdentityProviderRepresentation createConfig(String alias, String trustDomain, String bundleEndpoint) {
        return IdentityProviderBuilder.create().providerId("spiffe").alias(alias).setAttribute("issuer", trustDomain).setAttribute("bundleEndpoint", bundleEndpoint).build();
    }
}

