/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.db;

import org.keycloak.testframework.annotations.InjectTestDatabase;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.conditions.DisabledForDatabases;
import org.keycloak.testframework.database.DatabaseConfig;
import org.keycloak.testframework.database.DatabaseConfigBuilder;
import org.keycloak.testframework.database.TestDatabase;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.db.AbstractDBSchemaTest;

@KeycloakIntegrationTest(config=CaseSensitiveServerConfig.class)
@DisabledForDatabases(value={"mssql", "tidb"})
public class CaseSensitiveSchemaTest
extends AbstractDBSchemaTest {
    @InjectTestDatabase(config=CaseSensitiveDatabaseConfig.class)
    TestDatabase db;

    public static class CaseSensitiveDatabaseConfig
    implements DatabaseConfig {
        public DatabaseConfigBuilder configure(DatabaseConfigBuilder database) {
            if ("postgres".equals(AbstractDBSchemaTest.dbType()) || "edb".equals(AbstractDBSchemaTest.dbType())) {
                database.initScript("org/keycloak/tests/db/case-sensitive-schema-postgres.sql");
            }
            return database;
        }
    }

    public static class CaseSensitiveServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return switch (AbstractDBSchemaTest.dbType()) {
                case "postgres", "edb" -> config.option("db-schema", "KEYCLOAK");
                case "dev-file", "dev-mem" -> config.option("db-url-properties", ";INIT=CREATE SCHEMA IF NOT EXISTS keycloak").option("db-schema", "keycloak");
                default -> config.option("db-schema", "keycloak");
            };
        }
    }
}

