/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.db;

import org.keycloak.testframework.annotations.InjectTestDatabase;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.conditions.DisabledForDatabases;
import org.keycloak.testframework.database.DatabaseConfig;
import org.keycloak.testframework.database.DatabaseConfigBuilder;
import org.keycloak.testframework.database.TestDatabase;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.db.AbstractDBSchemaTest;

@KeycloakIntegrationTest(config=PreserveSchemaCaseServerConfig.class)
@DisabledForDatabases(value={"mssql", "oracle", "tidb"})
public class PreserveSchemaCaseLiquibaseTest
extends AbstractDBSchemaTest {
    @InjectTestDatabase(config=PreserveSchemaCaseDatabaseConfig.class, lifecycle=LifeCycle.CLASS)
    TestDatabase db;

    private static class PreserveSchemaCaseDatabaseConfig
    implements DatabaseConfig {
        private PreserveSchemaCaseDatabaseConfig() {
        }

        public DatabaseConfigBuilder configure(DatabaseConfigBuilder database) {
            if (AbstractDBSchemaTest.dbType().equals("postgres") || AbstractDBSchemaTest.dbType().equals("edb")) {
                return database.initScript("org/keycloak/tests/db/preserve-schema-case-liquibase-postgres.sql");
            }
            return database.database("keycloak-t");
        }
    }

    public static class PreserveSchemaCaseServerConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            switch (AbstractDBSchemaTest.dbType()) {
                case "dev-file": 
                case "dev-mem": {
                    config.option("db-url-properties", ";INIT=CREATE SCHEMA IF NOT EXISTS \"keycloak-t\"");
                }
            }
            return config.option("db-schema", "keycloak-t");
        }
    }
}

