/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.forms;

import org.junit.jupiter.api.Test;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.server.KeycloakServerConfig;
import org.keycloak.testframework.server.KeycloakServerConfigBuilder;
import org.keycloak.tests.forms.AuthzEndpointRequestParserTest;

@KeycloakIntegrationTest(config=AuthzEndpointRequestParserConfig.class)
public class AuthzEndpointRequestParserCustomConfigTest
extends AuthzEndpointRequestParserTest {
    @Override
    @Test
    public void testParamsLength() {
        String loginHint100 = SecretGenerator.getInstance().randomString(100);
        String state100 = SecretGenerator.getInstance().randomString(100);
        this.oauth.loginForm().loginHint(loginHint100).state(state100).open();
        this.assertLogin(loginHint100, state100);
        String loginHint200 = SecretGenerator.getInstance().randomString(200);
        String state200 = SecretGenerator.getInstance().randomString(200);
        this.oauth.loginForm().loginHint(loginHint200).state(state200).open();
        this.assertLogin("", state200);
        String state2100 = SecretGenerator.getInstance().randomString(2100);
        this.oauth.loginForm().state(state2100).open();
        this.assertLogin("", state2100);
        String state3100 = SecretGenerator.getInstance().randomString(3100);
        this.oauth.loginForm().state(state3100).open();
        this.assertLogin("", null);
    }

    public static class AuthzEndpointRequestParserConfig
    implements KeycloakServerConfig {
        public KeycloakServerConfigBuilder configure(KeycloakServerConfigBuilder config) {
            return config.option("spi-login-protocol--openid-connect--req-params-default-max-size", "3000").option("spi-login-protocol--openid-connect--req-params-max-size--login_hint", "100");
        }
    }
}

