/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.forms;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.testframework.annotations.InjectRealm;
import org.keycloak.testframework.annotations.InjectUser;
import org.keycloak.testframework.annotations.KeycloakIntegrationTest;
import org.keycloak.testframework.oauth.OAuthClient;
import org.keycloak.testframework.oauth.annotations.InjectOAuthClient;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.realm.ManagedUser;
import org.keycloak.testframework.realm.UserConfig;
import org.keycloak.testframework.realm.UserConfigBuilder;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.keycloak.testframework.ui.page.LoginPage;
import org.keycloak.testsuite.util.AccountHelper;
import org.openqa.selenium.WebDriver;

@KeycloakIntegrationTest
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class AuthzEndpointRequestParserTest {
    @InjectWebDriver
    WebDriver driver;
    @InjectRealm
    ManagedRealm realm;
    @InjectUser(ref="test-user", config=TestUserConfig.class)
    ManagedUser managedUser;
    @InjectOAuthClient
    OAuthClient oauth;
    @InjectPage
    LoginPage loginPage;

    @Test
    public void testAuthenticationBackwardsCompatible() {
        SecretGenerator.getInstance().randomString(2001);
        this.oauth.loginForm().param("paramkey1_too_long", SecretGenerator.getInstance().randomString(2001)).param("paramkey2", "paramvalue2").param("paramkey3", "paramvalue3").param("paramkey4", "paramvalue4").param("paramkey5", "paramvalue5").param("paramkey6_too_many", "paramvalue6").open();
        this.loginPage.assertCurrent();
    }

    @Test
    public void testParamsLength() {
        String loginHint200 = SecretGenerator.getInstance().randomString(200);
        String state200 = SecretGenerator.getInstance().randomString(200);
        this.oauth.loginForm().loginHint(loginHint200).state(state200).open();
        this.assertLogin(loginHint200, state200);
        String loginHint500 = SecretGenerator.getInstance().randomString(500);
        String state500 = SecretGenerator.getInstance().randomString(500);
        this.oauth.loginForm().loginHint(loginHint500).state(state500).open();
        this.assertLogin("", state500);
        String state4100 = SecretGenerator.getInstance().randomString(4100);
        this.oauth.loginForm().state(state4100).open();
        this.assertLogin("", null);
    }

    protected void assertLogin(String loginHintExpected, String stateExpected) {
        this.loginPage.assertCurrent();
        Assertions.assertEquals((Object)loginHintExpected, (Object)this.loginPage.getUsername());
        this.loginPage.clearUsernameInput();
        this.loginPage.fillLogin("test-user", "password");
        this.loginPage.submit();
        Assertions.assertTrue((boolean)this.driver.getPageSource().contains("Happy days"));
        String state = this.oauth.parseLoginResponse().getState();
        Assertions.assertEquals((Object)stateExpected, (Object)state);
        AccountHelper.logout((RealmResource)this.realm.admin(), (String)"test-user");
    }

    private static class TestUserConfig
    implements UserConfig {
        private TestUserConfig() {
        }

        public UserConfigBuilder configure(UserConfigBuilder user) {
            user.username("test-user");
            user.password("password");
            user.name("My", "Test");
            user.email("test@email.org");
            user.emailVerified(true);
            return user;
        }
    }
}

